/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.util;

import java.io.Closeable;
import java.io.IOException;
import org.apache.shiro.lang.util.ByteSource;
import org.apache.shiro.util.ByteUtils;

public class ByteSourceWrapper
implements Closeable {
    private byte[] bytes;

    private ByteSourceWrapper(byte[] bytes2) {
        this.bytes = bytes2;
    }

    public static ByteSourceWrapper wrap(Object value) {
        if (value instanceof byte[]) {
            byte[] bytes2 = (byte[])value;
            return new ByteSourceWrapper(bytes2);
        }
        if (value instanceof ByteSource) {
            byte[] bytes3 = ((ByteSource)value).getBytes();
            return new ByteSourceWrapper(bytes3);
        }
        throw new IllegalArgumentException();
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public void close() throws IOException {
        ByteUtils.wipe(this.bytes);
    }
}

