/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto.hash.format;

import org.apache.shiro.crypto.hash.format.Base64Format;
import org.apache.shiro.crypto.hash.format.HashFormat;
import org.apache.shiro.crypto.hash.format.HexFormat;
import org.apache.shiro.crypto.hash.format.Shiro1CryptFormat;

public enum ProvidedHashFormat {
    HEX(HexFormat.class),
    BASE64(Base64Format.class),
    SHIRO1(Shiro1CryptFormat.class);

    private final Class<? extends HashFormat> clazz;

    private ProvidedHashFormat(Class<? extends HashFormat> clazz) {
        this.clazz = clazz;
    }

    Class<? extends HashFormat> getHashFormatClass() {
        return this.clazz;
    }

    public static ProvidedHashFormat byId(String id) {
        if (id == null) {
            return null;
        }
        try {
            return ProvidedHashFormat.valueOf(id.toUpperCase());
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }
}

