/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.util.CollectionUtils;

public class MapCache<K, V>
implements Cache<K, V> {
    private final Map<K, V> map;
    private final String name;

    public MapCache(String name2, Map<K, V> backingMap) {
        if (name2 == null) {
            throw new IllegalArgumentException("Cache name cannot be null.");
        }
        if (backingMap == null) {
            throw new IllegalArgumentException("Backing map cannot be null.");
        }
        this.name = name2;
        this.map = backingMap;
    }

    @Override
    public V get(K key2) throws CacheException {
        return this.map.get(key2);
    }

    @Override
    public V put(K key2, V value) throws CacheException {
        return this.map.put(key2, value);
    }

    @Override
    public V remove(K key2) throws CacheException {
        return this.map.remove(key2);
    }

    @Override
    public void clear() throws CacheException {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Set<K> keys() {
        Set<K> keys2 = this.map.keySet();
        if (!keys2.isEmpty()) {
            return Collections.unmodifiableSet(keys2);
        }
        return Collections.emptySet();
    }

    @Override
    public Collection<V> values() {
        Collection<V> values = this.map.values();
        if (!CollectionUtils.isEmpty(values)) {
            return Collections.unmodifiableCollection(values);
        }
        return Collections.emptySet();
    }

    public String toString() {
        return "MapCache '" + this.name + "' (" + this.map.size() + " entries)";
    }
}

