/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.cache;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.util.Destroyable;
import org.apache.shiro.util.LifecycleUtils;
import org.apache.shiro.util.StringUtils;

public abstract class AbstractCacheManager
implements CacheManager,
Destroyable {
    private final ConcurrentMap<String, Cache> caches = new ConcurrentHashMap<String, Cache>();

    @Override
    public <K, V> Cache<K, V> getCache(String name2) throws IllegalArgumentException, CacheException {
        Cache existing;
        if (!StringUtils.hasText(name2)) {
            throw new IllegalArgumentException("Cache name cannot be null or empty.");
        }
        Cache cache = (Cache)this.caches.get(name2);
        if (cache == null && (existing = this.caches.putIfAbsent(name2, cache = this.createCache(name2))) != null) {
            cache = existing;
        }
        return cache;
    }

    protected abstract Cache createCache(String var1) throws CacheException;

    @Override
    public void destroy() throws Exception {
        while (!this.caches.isEmpty()) {
            for (Cache cache : this.caches.values()) {
                LifecycleUtils.destroy(cache);
            }
            this.caches.clear();
        }
    }

    public String toString() {
        Collection values = this.caches.values();
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append(" with ").append(this.caches.size()).append(" cache(s)): [");
        int i = 0;
        for (Cache cache : values) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(cache.toString());
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }
}

