/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.Hashtable;

public class ContextAccessController {
    private static final Hashtable<Object, Object> readOnlyContexts = new Hashtable();
    private static final Hashtable<Object, Object> securityTokens = new Hashtable();

    public static void setSecurityToken(Object name2, Object token) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(ContextAccessController.class.getName() + ".setSecurityToken"));
        }
        if (!securityTokens.containsKey(name2) && token != null) {
            securityTokens.put(name2, token);
        }
    }

    public static void unsetSecurityToken(Object name2, Object token) {
        if (ContextAccessController.checkSecurityToken(name2, token)) {
            securityTokens.remove(name2);
        }
    }

    public static boolean checkSecurityToken(Object name2, Object token) {
        Object refToken = securityTokens.get(name2);
        return refToken == null || refToken.equals(token);
    }

    public static void setWritable(Object name2, Object token) {
        if (ContextAccessController.checkSecurityToken(name2, token)) {
            readOnlyContexts.remove(name2);
        }
    }

    public static void setReadOnly(Object name2) {
        readOnlyContexts.put(name2, name2);
    }

    public static boolean isWritable(Object name2) {
        return !readOnlyContexts.containsKey(name2);
    }
}

