/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.util.Args;

public class FileBody
extends AbstractContentBody {
    private final File file;
    private final String filename;

    @Deprecated
    public FileBody(File file2, String filename, String mimeType, String charset) {
        this(file2, ContentType.create(mimeType, charset), filename);
    }

    @Deprecated
    public FileBody(File file2, String mimeType, String charset) {
        this(file2, null, mimeType, charset);
    }

    @Deprecated
    public FileBody(File file2, String mimeType) {
        this(file2, ContentType.create(mimeType), null);
    }

    public FileBody(File file2) {
        this(file2, ContentType.DEFAULT_BINARY, file2 != null ? file2.getName() : null);
    }

    public FileBody(File file2, ContentType contentType, String filename) {
        super(contentType);
        Args.notNull(file2, "File");
        this.file = file2;
        this.filename = filename;
    }

    public FileBody(File file2, ContentType contentType) {
        this(file2, contentType, file2 != null ? file2.getName() : null);
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream out) throws IOException {
        Args.notNull(out, "Output stream");
        FileInputStream in = new FileInputStream(this.file);
        try {
            int l;
            byte[] tmp = new byte[4096];
            while ((l = ((InputStream)in).read(tmp)) != -1) {
                out.write(tmp, 0, l);
            }
            out.flush();
        }
        finally {
            ((InputStream)in).close();
        }
    }

    @Override
    public String getTransferEncoding() {
        return "binary";
    }

    @Override
    public long getContentLength() {
        return this.file.length();
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public File getFile() {
        return this.file;
    }
}

