/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.collections4.OrderedIterator;
import org.apache.commons.collections4.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections4.list.UnmodifiableList;
import org.apache.commons.collections4.set.AbstractSerializableSetDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOrderedSet<E>
extends AbstractSerializableSetDecorator<E> {
    private static final long serialVersionUID = -228664372470420141L;
    private final List<E> setOrder;

    public static <E> ListOrderedSet<E> listOrderedSet(Set<E> set2, List<E> list) {
        if (set2 == null) {
            throw new IllegalArgumentException("Set must not be null");
        }
        if (list == null) {
            throw new IllegalArgumentException("List must not be null");
        }
        if (set2.size() > 0 || list.size() > 0) {
            throw new IllegalArgumentException("Set and List must be empty");
        }
        return new ListOrderedSet<E>(set2, list);
    }

    public static <E> ListOrderedSet<E> listOrderedSet(Set<E> set2) {
        return new ListOrderedSet<E>(set2);
    }

    public static <E> ListOrderedSet<E> listOrderedSet(List<E> list) {
        if (list == null) {
            throw new IllegalArgumentException("List must not be null");
        }
        HashSet<E> set2 = new HashSet<E>(list);
        list.retainAll(set2);
        return new ListOrderedSet<E>(set2, list);
    }

    public ListOrderedSet() {
        super(new HashSet());
        this.setOrder = new ArrayList();
    }

    protected ListOrderedSet(Set<E> set2) {
        super(set2);
        this.setOrder = new ArrayList<E>(set2);
    }

    protected ListOrderedSet(Set<E> set2, List<E> list) {
        super(set2);
        if (list == null) {
            throw new IllegalArgumentException("List must not be null");
        }
        this.setOrder = list;
    }

    public List<E> asList() {
        return UnmodifiableList.unmodifiableList(this.setOrder);
    }

    @Override
    public void clear() {
        this.decorated().clear();
        this.setOrder.clear();
    }

    @Override
    public OrderedIterator<E> iterator() {
        return new OrderedSetIterator(this.setOrder.listIterator(), this.decorated());
    }

    @Override
    public boolean add(E object) {
        if (this.decorated().add(object)) {
            this.setOrder.add(object);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        boolean result = false;
        for (E e2 : coll) {
            result |= this.add(e2);
        }
        return result;
    }

    @Override
    public boolean remove(Object object) {
        boolean result = this.decorated().remove(object);
        if (result) {
            this.setOrder.remove(object);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        boolean result = false;
        for (Object name2 : coll) {
            result |= this.remove(name2);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        HashSet collectionRetainAll = new HashSet();
        for (Object next2 : coll) {
            if (!this.decorated().contains(next2)) continue;
            collectionRetainAll.add(next2);
        }
        if (collectionRetainAll.size() == this.decorated().size()) {
            return false;
        }
        if (collectionRetainAll.size() == 0) {
            this.clear();
        } else {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (collectionRetainAll.contains(it.next())) continue;
                it.remove();
            }
        }
        return true;
    }

    @Override
    public Object[] toArray() {
        return this.setOrder.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.setOrder.toArray(a);
    }

    public E get(int index2) {
        return this.setOrder.get(index2);
    }

    public int indexOf(Object object) {
        return this.setOrder.indexOf(object);
    }

    public void add(int index2, E object) {
        if (!this.contains(object)) {
            this.decorated().add(object);
            this.setOrder.add(index2, object);
        }
    }

    public boolean addAll(int index2, Collection<? extends E> coll) {
        boolean changed = false;
        ArrayList<E> toAdd = new ArrayList<E>();
        for (E e2 : coll) {
            if (this.contains(e2)) continue;
            this.decorated().add(e2);
            toAdd.add(e2);
            changed = true;
        }
        if (changed) {
            this.setOrder.addAll(index2, toAdd);
        }
        return changed;
    }

    public Object remove(int index2) {
        E obj = this.setOrder.remove(index2);
        this.remove(obj);
        return obj;
    }

    @Override
    public String toString() {
        return this.setOrder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OrderedSetIterator<E>
    extends AbstractIteratorDecorator<E>
    implements OrderedIterator<E> {
        private final Collection<E> set;
        private E last;

        private OrderedSetIterator(ListIterator<E> iterator, Collection<E> set2) {
            super(iterator);
            this.set = set2;
        }

        @Override
        public E next() {
            this.last = this.getIterator().next();
            return this.last;
        }

        @Override
        public void remove() {
            this.set.remove(this.last);
            this.getIterator().remove();
            this.last = null;
        }

        @Override
        public boolean hasPrevious() {
            return ((ListIterator)this.getIterator()).hasPrevious();
        }

        @Override
        public E previous() {
            this.last = ((ListIterator)this.getIterator()).previous();
            return this.last;
        }
    }
}

