/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.Collection;
import java.util.Comparator;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.comparators.BooleanComparator;
import org.apache.commons.collections4.comparators.ComparableComparator;
import org.apache.commons.collections4.comparators.ComparatorChain;
import org.apache.commons.collections4.comparators.NullComparator;
import org.apache.commons.collections4.comparators.ReverseComparator;
import org.apache.commons.collections4.comparators.TransformingComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparatorUtils {
    public static final Comparator NATURAL_COMPARATOR = ComparableComparator.comparableComparator();

    private ComparatorUtils() {
    }

    public static <E extends Comparable<? super E>> Comparator<E> naturalComparator() {
        return NATURAL_COMPARATOR;
    }

    public static <E extends Comparable<? super E>> Comparator<E> chainedComparator(Comparator<E> ... comparators) {
        ComparatorChain<E> chain = new ComparatorChain<E>();
        for (Comparator<E> comparator2 : comparators) {
            if (comparator2 == null) {
                throw new NullPointerException("Comparator cannot be null");
            }
            chain.addComparator(comparator2);
        }
        return chain;
    }

    public static <E extends Comparable<? super E>> Comparator<E> chainedComparator(Collection<Comparator<E>> comparators) {
        return ComparatorUtils.chainedComparator(comparators.toArray(new Comparator[comparators.size()]));
    }

    public static <E> Comparator<E> reversedComparator(Comparator<E> comparator2) {
        return new ReverseComparator<E>(comparator2);
    }

    public static Comparator<Boolean> booleanComparator(boolean trueFirst) {
        return BooleanComparator.booleanComparator(trueFirst);
    }

    public static <E> Comparator<E> nullLowComparator(Comparator<E> comparator2) {
        if (comparator2 == null) {
            comparator2 = NATURAL_COMPARATOR;
        }
        return new NullComparator(comparator2, false);
    }

    public static <E> Comparator<E> nullHighComparator(Comparator<E> comparator2) {
        if (comparator2 == null) {
            comparator2 = NATURAL_COMPARATOR;
        }
        return new NullComparator(comparator2, true);
    }

    public static <I, O> Comparator<I> transformedComparator(Comparator<O> comparator2, Transformer<? super I, ? extends O> transformer) {
        if (comparator2 == null) {
            comparator2 = NATURAL_COMPARATOR;
        }
        return new TransformingComparator<I, O>(transformer, comparator2);
    }

    public static <E> E min(E o1, E o2, Comparator<E> comparator2) {
        int c;
        if (comparator2 == null) {
            comparator2 = NATURAL_COMPARATOR;
        }
        return (c = comparator2.compare(o1, o2)) < 0 ? o1 : o2;
    }

    public static <E> E max(E o1, E o2, Comparator<E> comparator2) {
        int c;
        if (comparator2 == null) {
            comparator2 = NATURAL_COMPARATOR;
        }
        return (c = comparator2.compare(o1, o2)) > 0 ? o1 : o2;
    }
}

