/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.list;

import java.util.List;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.list.AbstractSerializableListDecorator;

public class LazyList
extends AbstractSerializableListDecorator {
    private static final long serialVersionUID = -1708388017160694542L;
    protected final Factory factory;

    public static List decorate(List list, Factory factory) {
        return new LazyList(list, factory);
    }

    protected LazyList(List list, Factory factory) {
        super(list);
        if (factory == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        this.factory = factory;
    }

    public Object get(int index2) {
        int size = this.getList().size();
        if (index2 < size) {
            Object object = this.getList().get(index2);
            if (object == null) {
                object = this.factory.create();
                this.getList().set(index2, object);
                return object;
            }
            return object;
        }
        for (int i = size; i < index2; ++i) {
            this.getList().add(null);
        }
        Object object = this.factory.create();
        this.getList().add(object);
        return object;
    }

    public List subList(int fromIndex, int toIndex) {
        List sub = this.getList().subList(fromIndex, toIndex);
        return new LazyList(sub, this.factory);
    }
}

