/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.bidimap;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.KeyValue;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.OrderedBidiMap;
import org.apache.commons.collections.OrderedIterator;
import org.apache.commons.collections.OrderedMapIterator;
import org.apache.commons.collections.iterators.EmptyOrderedMapIterator;
import org.apache.commons.collections.keyvalue.UnmodifiableMapEntry;

public class TreeBidiMap
implements OrderedBidiMap {
    private static final int KEY = 0;
    private static final int VALUE = 1;
    private static final int MAPENTRY = 2;
    private static final int INVERSEMAPENTRY = 3;
    private static final int SUM_OF_INDICES = 1;
    private static final int FIRST_INDEX = 0;
    private static final int NUMBER_OF_INDICES = 2;
    private static final String[] dataName = new String[]{"key", "value"};
    private Node[] rootNode = new Node[2];
    private int nodeCount = 0;
    private int modifications = 0;
    private Set keySet;
    private Set valuesSet;
    private Set entrySet;
    private Inverse inverse = null;

    public TreeBidiMap() {
    }

    public TreeBidiMap(Map map2) {
        this.putAll(map2);
    }

    public int size() {
        return this.nodeCount;
    }

    public boolean isEmpty() {
        return this.nodeCount == 0;
    }

    public boolean containsKey(Object key2) {
        TreeBidiMap.checkKey(key2);
        return this.lookup((Comparable)key2, 0) != null;
    }

    public boolean containsValue(Object value) {
        TreeBidiMap.checkValue(value);
        return this.lookup((Comparable)value, 1) != null;
    }

    public Object get(Object key2) {
        return this.doGet((Comparable)key2, 0);
    }

    public Object put(Object key2, Object value) {
        return this.doPut((Comparable)key2, (Comparable)value, 0);
    }

    public void putAll(Map map2) {
        Iterator it = map2.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key2) {
        return this.doRemove((Comparable)key2, 0);
    }

    public void clear() {
        this.modify();
        this.nodeCount = 0;
        this.rootNode[0] = null;
        this.rootNode[1] = null;
    }

    public Object getKey(Object value) {
        return this.doGet((Comparable)value, 1);
    }

    public Object removeValue(Object value) {
        return this.doRemove((Comparable)value, 1);
    }

    public Object firstKey() {
        if (this.nodeCount == 0) {
            throw new NoSuchElementException("Map is empty");
        }
        return TreeBidiMap.leastNode(this.rootNode[0], 0).getKey();
    }

    public Object lastKey() {
        if (this.nodeCount == 0) {
            throw new NoSuchElementException("Map is empty");
        }
        return TreeBidiMap.greatestNode(this.rootNode[0], 0).getKey();
    }

    public Object nextKey(Object key2) {
        TreeBidiMap.checkKey(key2);
        Node node2 = this.nextGreater(this.lookup((Comparable)key2, 0), 0);
        return node2 == null ? null : node2.getKey();
    }

    public Object previousKey(Object key2) {
        TreeBidiMap.checkKey(key2);
        Node node2 = this.nextSmaller(this.lookup((Comparable)key2, 0), 0);
        return node2 == null ? null : node2.getKey();
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new View(this, 0, 0);
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.valuesSet == null) {
            this.valuesSet = new View(this, 0, 1);
        }
        return this.valuesSet;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            return new EntryView(this, 0, 2);
        }
        return this.entrySet;
    }

    public MapIterator mapIterator() {
        if (this.isEmpty()) {
            return EmptyOrderedMapIterator.INSTANCE;
        }
        return new ViewMapIterator(this, 0);
    }

    public OrderedMapIterator orderedMapIterator() {
        if (this.isEmpty()) {
            return EmptyOrderedMapIterator.INSTANCE;
        }
        return new ViewMapIterator(this, 0);
    }

    public BidiMap inverseBidiMap() {
        return this.inverseOrderedBidiMap();
    }

    public OrderedBidiMap inverseOrderedBidiMap() {
        if (this.inverse == null) {
            this.inverse = new Inverse(this);
        }
        return this.inverse;
    }

    public boolean equals(Object obj) {
        return this.doEquals(obj, 0);
    }

    public int hashCode() {
        return this.doHashCode(0);
    }

    public String toString() {
        return this.doToString(0);
    }

    private Object doGet(Comparable obj, int index2) {
        TreeBidiMap.checkNonNullComparable(obj, index2);
        Node node2 = this.lookup(obj, index2);
        return node2 == null ? null : node2.getData(TreeBidiMap.oppositeIndex(index2));
    }

    private Object doPut(Comparable key2, Comparable value, int index2) {
        Object prev2;
        block6: {
            TreeBidiMap.checkKeyAndValue(key2, value);
            prev2 = index2 == 0 ? this.doGet(key2, 0) : this.doGet(value, 1);
            this.doRemove(key2, 0);
            this.doRemove(value, 1);
            Node node2 = this.rootNode[0];
            if (node2 == null) {
                Node root2;
                this.rootNode[0] = root2 = new Node(key2, value);
                this.rootNode[1] = root2;
                this.grow();
            } else {
                while (true) {
                    int cmp;
                    if ((cmp = TreeBidiMap.compare(key2, node2.getData(0))) == 0) {
                        throw new IllegalArgumentException("Cannot store a duplicate key (\"" + key2 + "\") in this Map");
                    }
                    if (cmp < 0) {
                        if (node2.getLeft(0) != null) {
                            node2 = node2.getLeft(0);
                            continue;
                        }
                        Node newNode = new Node(key2, value);
                        this.insertValue(newNode);
                        node2.setLeft(newNode, 0);
                        newNode.setParent(node2, 0);
                        this.doRedBlackInsert(newNode, 0);
                        this.grow();
                        break block6;
                    }
                    if (node2.getRight(0) == null) break;
                    node2 = node2.getRight(0);
                }
                Node newNode = new Node(key2, value);
                this.insertValue(newNode);
                node2.setRight(newNode, 0);
                newNode.setParent(node2, 0);
                this.doRedBlackInsert(newNode, 0);
                this.grow();
            }
        }
        return prev2;
    }

    private Object doRemove(Comparable o, int index2) {
        Node node2 = this.lookup(o, index2);
        Comparable rval = null;
        if (node2 != null) {
            rval = node2.getData(TreeBidiMap.oppositeIndex(index2));
            this.doRedBlackDelete(node2);
        }
        return rval;
    }

    private Node lookup(Comparable data2, int index2) {
        Node rval = null;
        Node node2 = this.rootNode[index2];
        while (node2 != null) {
            int cmp = TreeBidiMap.compare(data2, node2.getData(index2));
            if (cmp == 0) {
                rval = node2;
                break;
            }
            node2 = cmp < 0 ? node2.getLeft(index2) : node2.getRight(index2);
        }
        return rval;
    }

    private Node nextGreater(Node node2, int index2) {
        Node rval = null;
        if (node2 == null) {
            rval = null;
        } else if (node2.getRight(index2) != null) {
            rval = TreeBidiMap.leastNode(node2.getRight(index2), index2);
        } else {
            Node parent = node2.getParent(index2);
            Node child = node2;
            while (parent != null && child == parent.getRight(index2)) {
                child = parent;
                parent = parent.getParent(index2);
            }
            rval = parent;
        }
        return rval;
    }

    private Node nextSmaller(Node node2, int index2) {
        Node rval = null;
        if (node2 == null) {
            rval = null;
        } else if (node2.getLeft(index2) != null) {
            rval = TreeBidiMap.greatestNode(node2.getLeft(index2), index2);
        } else {
            Node parent = node2.getParent(index2);
            Node child = node2;
            while (parent != null && child == parent.getLeft(index2)) {
                child = parent;
                parent = parent.getParent(index2);
            }
            rval = parent;
        }
        return rval;
    }

    private static int oppositeIndex(int index2) {
        return 1 - index2;
    }

    private static int compare(Comparable o1, Comparable o2) {
        return o1.compareTo(o2);
    }

    private static Node leastNode(Node node2, int index2) {
        Node rval = node2;
        if (rval != null) {
            while (rval.getLeft(index2) != null) {
                rval = rval.getLeft(index2);
            }
        }
        return rval;
    }

    private static Node greatestNode(Node node2, int index2) {
        Node rval = node2;
        if (rval != null) {
            while (rval.getRight(index2) != null) {
                rval = rval.getRight(index2);
            }
        }
        return rval;
    }

    private static void copyColor(Node from, Node to, int index2) {
        if (to != null) {
            if (from == null) {
                to.setBlack(index2);
            } else {
                to.copyColor(from, index2);
            }
        }
    }

    private static boolean isRed(Node node2, int index2) {
        return node2 == null ? false : node2.isRed(index2);
    }

    private static boolean isBlack(Node node2, int index2) {
        return node2 == null ? true : node2.isBlack(index2);
    }

    private static void makeRed(Node node2, int index2) {
        if (node2 != null) {
            node2.setRed(index2);
        }
    }

    private static void makeBlack(Node node2, int index2) {
        if (node2 != null) {
            node2.setBlack(index2);
        }
    }

    private static Node getGrandParent(Node node2, int index2) {
        return TreeBidiMap.getParent(TreeBidiMap.getParent(node2, index2), index2);
    }

    private static Node getParent(Node node2, int index2) {
        return node2 == null ? null : node2.getParent(index2);
    }

    private static Node getRightChild(Node node2, int index2) {
        return node2 == null ? null : node2.getRight(index2);
    }

    private static Node getLeftChild(Node node2, int index2) {
        return node2 == null ? null : node2.getLeft(index2);
    }

    private static boolean isLeftChild(Node node2, int index2) {
        return node2 == null ? true : (node2.getParent(index2) == null ? false : node2 == node2.getParent(index2).getLeft(index2));
    }

    private static boolean isRightChild(Node node2, int index2) {
        return node2 == null ? true : (node2.getParent(index2) == null ? false : node2 == node2.getParent(index2).getRight(index2));
    }

    private void rotateLeft(Node node2, int index2) {
        Node rightChild = node2.getRight(index2);
        node2.setRight(rightChild.getLeft(index2), index2);
        if (rightChild.getLeft(index2) != null) {
            rightChild.getLeft(index2).setParent(node2, index2);
        }
        rightChild.setParent(node2.getParent(index2), index2);
        if (node2.getParent(index2) == null) {
            this.rootNode[index2] = rightChild;
        } else if (node2.getParent(index2).getLeft(index2) == node2) {
            node2.getParent(index2).setLeft(rightChild, index2);
        } else {
            node2.getParent(index2).setRight(rightChild, index2);
        }
        rightChild.setLeft(node2, index2);
        node2.setParent(rightChild, index2);
    }

    private void rotateRight(Node node2, int index2) {
        Node leftChild = node2.getLeft(index2);
        node2.setLeft(leftChild.getRight(index2), index2);
        if (leftChild.getRight(index2) != null) {
            leftChild.getRight(index2).setParent(node2, index2);
        }
        leftChild.setParent(node2.getParent(index2), index2);
        if (node2.getParent(index2) == null) {
            this.rootNode[index2] = leftChild;
        } else if (node2.getParent(index2).getRight(index2) == node2) {
            node2.getParent(index2).setRight(leftChild, index2);
        } else {
            node2.getParent(index2).setLeft(leftChild, index2);
        }
        leftChild.setRight(node2, index2);
        node2.setParent(leftChild, index2);
    }

    private void doRedBlackInsert(Node insertedNode, int index2) {
        Node currentNode = insertedNode;
        TreeBidiMap.makeRed(currentNode, index2);
        while (currentNode != null && currentNode != this.rootNode[index2] && TreeBidiMap.isRed(currentNode.getParent(index2), index2)) {
            Node y;
            if (TreeBidiMap.isLeftChild(TreeBidiMap.getParent(currentNode, index2), index2)) {
                y = TreeBidiMap.getRightChild(TreeBidiMap.getGrandParent(currentNode, index2), index2);
                if (TreeBidiMap.isRed(y, index2)) {
                    TreeBidiMap.makeBlack(TreeBidiMap.getParent(currentNode, index2), index2);
                    TreeBidiMap.makeBlack(y, index2);
                    TreeBidiMap.makeRed(TreeBidiMap.getGrandParent(currentNode, index2), index2);
                    currentNode = TreeBidiMap.getGrandParent(currentNode, index2);
                    continue;
                }
                if (TreeBidiMap.isRightChild(currentNode, index2)) {
                    currentNode = TreeBidiMap.getParent(currentNode, index2);
                    this.rotateLeft(currentNode, index2);
                }
                TreeBidiMap.makeBlack(TreeBidiMap.getParent(currentNode, index2), index2);
                TreeBidiMap.makeRed(TreeBidiMap.getGrandParent(currentNode, index2), index2);
                if (TreeBidiMap.getGrandParent(currentNode, index2) == null) continue;
                this.rotateRight(TreeBidiMap.getGrandParent(currentNode, index2), index2);
                continue;
            }
            y = TreeBidiMap.getLeftChild(TreeBidiMap.getGrandParent(currentNode, index2), index2);
            if (TreeBidiMap.isRed(y, index2)) {
                TreeBidiMap.makeBlack(TreeBidiMap.getParent(currentNode, index2), index2);
                TreeBidiMap.makeBlack(y, index2);
                TreeBidiMap.makeRed(TreeBidiMap.getGrandParent(currentNode, index2), index2);
                currentNode = TreeBidiMap.getGrandParent(currentNode, index2);
                continue;
            }
            if (TreeBidiMap.isLeftChild(currentNode, index2)) {
                currentNode = TreeBidiMap.getParent(currentNode, index2);
                this.rotateRight(currentNode, index2);
            }
            TreeBidiMap.makeBlack(TreeBidiMap.getParent(currentNode, index2), index2);
            TreeBidiMap.makeRed(TreeBidiMap.getGrandParent(currentNode, index2), index2);
            if (TreeBidiMap.getGrandParent(currentNode, index2) == null) continue;
            this.rotateLeft(TreeBidiMap.getGrandParent(currentNode, index2), index2);
        }
        TreeBidiMap.makeBlack(this.rootNode[index2], index2);
    }

    private void doRedBlackDelete(Node deletedNode) {
        for (int index2 = 0; index2 < 2; ++index2) {
            Node replacement;
            if (deletedNode.getLeft(index2) != null && deletedNode.getRight(index2) != null) {
                this.swapPosition(this.nextGreater(deletedNode, index2), deletedNode, index2);
            }
            Node node2 = replacement = deletedNode.getLeft(index2) != null ? deletedNode.getLeft(index2) : deletedNode.getRight(index2);
            if (replacement != null) {
                replacement.setParent(deletedNode.getParent(index2), index2);
                if (deletedNode.getParent(index2) == null) {
                    this.rootNode[index2] = replacement;
                } else if (deletedNode == deletedNode.getParent(index2).getLeft(index2)) {
                    deletedNode.getParent(index2).setLeft(replacement, index2);
                } else {
                    deletedNode.getParent(index2).setRight(replacement, index2);
                }
                deletedNode.setLeft(null, index2);
                deletedNode.setRight(null, index2);
                deletedNode.setParent(null, index2);
                if (!TreeBidiMap.isBlack(deletedNode, index2)) continue;
                this.doRedBlackDeleteFixup(replacement, index2);
                continue;
            }
            if (deletedNode.getParent(index2) == null) {
                this.rootNode[index2] = null;
                continue;
            }
            if (TreeBidiMap.isBlack(deletedNode, index2)) {
                this.doRedBlackDeleteFixup(deletedNode, index2);
            }
            if (deletedNode.getParent(index2) == null) continue;
            if (deletedNode == deletedNode.getParent(index2).getLeft(index2)) {
                deletedNode.getParent(index2).setLeft(null, index2);
            } else {
                deletedNode.getParent(index2).setRight(null, index2);
            }
            deletedNode.setParent(null, index2);
        }
        this.shrink();
    }

    private void doRedBlackDeleteFixup(Node replacementNode, int index2) {
        Node currentNode = replacementNode;
        while (currentNode != this.rootNode[index2] && TreeBidiMap.isBlack(currentNode, index2)) {
            Node siblingNode;
            if (TreeBidiMap.isLeftChild(currentNode, index2)) {
                siblingNode = TreeBidiMap.getRightChild(TreeBidiMap.getParent(currentNode, index2), index2);
                if (TreeBidiMap.isRed(siblingNode, index2)) {
                    TreeBidiMap.makeBlack(siblingNode, index2);
                    TreeBidiMap.makeRed(TreeBidiMap.getParent(currentNode, index2), index2);
                    this.rotateLeft(TreeBidiMap.getParent(currentNode, index2), index2);
                    siblingNode = TreeBidiMap.getRightChild(TreeBidiMap.getParent(currentNode, index2), index2);
                }
                if (TreeBidiMap.isBlack(TreeBidiMap.getLeftChild(siblingNode, index2), index2) && TreeBidiMap.isBlack(TreeBidiMap.getRightChild(siblingNode, index2), index2)) {
                    TreeBidiMap.makeRed(siblingNode, index2);
                    currentNode = TreeBidiMap.getParent(currentNode, index2);
                    continue;
                }
                if (TreeBidiMap.isBlack(TreeBidiMap.getRightChild(siblingNode, index2), index2)) {
                    TreeBidiMap.makeBlack(TreeBidiMap.getLeftChild(siblingNode, index2), index2);
                    TreeBidiMap.makeRed(siblingNode, index2);
                    this.rotateRight(siblingNode, index2);
                    siblingNode = TreeBidiMap.getRightChild(TreeBidiMap.getParent(currentNode, index2), index2);
                }
                TreeBidiMap.copyColor(TreeBidiMap.getParent(currentNode, index2), siblingNode, index2);
                TreeBidiMap.makeBlack(TreeBidiMap.getParent(currentNode, index2), index2);
                TreeBidiMap.makeBlack(TreeBidiMap.getRightChild(siblingNode, index2), index2);
                this.rotateLeft(TreeBidiMap.getParent(currentNode, index2), index2);
                currentNode = this.rootNode[index2];
                continue;
            }
            siblingNode = TreeBidiMap.getLeftChild(TreeBidiMap.getParent(currentNode, index2), index2);
            if (TreeBidiMap.isRed(siblingNode, index2)) {
                TreeBidiMap.makeBlack(siblingNode, index2);
                TreeBidiMap.makeRed(TreeBidiMap.getParent(currentNode, index2), index2);
                this.rotateRight(TreeBidiMap.getParent(currentNode, index2), index2);
                siblingNode = TreeBidiMap.getLeftChild(TreeBidiMap.getParent(currentNode, index2), index2);
            }
            if (TreeBidiMap.isBlack(TreeBidiMap.getRightChild(siblingNode, index2), index2) && TreeBidiMap.isBlack(TreeBidiMap.getLeftChild(siblingNode, index2), index2)) {
                TreeBidiMap.makeRed(siblingNode, index2);
                currentNode = TreeBidiMap.getParent(currentNode, index2);
                continue;
            }
            if (TreeBidiMap.isBlack(TreeBidiMap.getLeftChild(siblingNode, index2), index2)) {
                TreeBidiMap.makeBlack(TreeBidiMap.getRightChild(siblingNode, index2), index2);
                TreeBidiMap.makeRed(siblingNode, index2);
                this.rotateLeft(siblingNode, index2);
                siblingNode = TreeBidiMap.getLeftChild(TreeBidiMap.getParent(currentNode, index2), index2);
            }
            TreeBidiMap.copyColor(TreeBidiMap.getParent(currentNode, index2), siblingNode, index2);
            TreeBidiMap.makeBlack(TreeBidiMap.getParent(currentNode, index2), index2);
            TreeBidiMap.makeBlack(TreeBidiMap.getLeftChild(siblingNode, index2), index2);
            this.rotateRight(TreeBidiMap.getParent(currentNode, index2), index2);
            currentNode = this.rootNode[index2];
        }
        TreeBidiMap.makeBlack(currentNode, index2);
    }

    private void swapPosition(Node x, Node y, int index2) {
        boolean yWasLeftChild;
        Node xFormerParent = x.getParent(index2);
        Node xFormerLeftChild = x.getLeft(index2);
        Node xFormerRightChild = x.getRight(index2);
        Node yFormerParent = y.getParent(index2);
        Node yFormerLeftChild = y.getLeft(index2);
        Node yFormerRightChild = y.getRight(index2);
        boolean xWasLeftChild = x.getParent(index2) != null && x == x.getParent(index2).getLeft(index2);
        boolean bl = yWasLeftChild = y.getParent(index2) != null && y == y.getParent(index2).getLeft(index2);
        if (x == yFormerParent) {
            x.setParent(y, index2);
            if (yWasLeftChild) {
                y.setLeft(x, index2);
                y.setRight(xFormerRightChild, index2);
            } else {
                y.setRight(x, index2);
                y.setLeft(xFormerLeftChild, index2);
            }
        } else {
            x.setParent(yFormerParent, index2);
            if (yFormerParent != null) {
                if (yWasLeftChild) {
                    yFormerParent.setLeft(x, index2);
                } else {
                    yFormerParent.setRight(x, index2);
                }
            }
            y.setLeft(xFormerLeftChild, index2);
            y.setRight(xFormerRightChild, index2);
        }
        if (y == xFormerParent) {
            y.setParent(x, index2);
            if (xWasLeftChild) {
                x.setLeft(y, index2);
                x.setRight(yFormerRightChild, index2);
            } else {
                x.setRight(y, index2);
                x.setLeft(yFormerLeftChild, index2);
            }
        } else {
            y.setParent(xFormerParent, index2);
            if (xFormerParent != null) {
                if (xWasLeftChild) {
                    xFormerParent.setLeft(y, index2);
                } else {
                    xFormerParent.setRight(y, index2);
                }
            }
            x.setLeft(yFormerLeftChild, index2);
            x.setRight(yFormerRightChild, index2);
        }
        if (x.getLeft(index2) != null) {
            x.getLeft(index2).setParent(x, index2);
        }
        if (x.getRight(index2) != null) {
            x.getRight(index2).setParent(x, index2);
        }
        if (y.getLeft(index2) != null) {
            y.getLeft(index2).setParent(y, index2);
        }
        if (y.getRight(index2) != null) {
            y.getRight(index2).setParent(y, index2);
        }
        x.swapColors(y, index2);
        if (this.rootNode[index2] == x) {
            this.rootNode[index2] = y;
        } else if (this.rootNode[index2] == y) {
            this.rootNode[index2] = x;
        }
    }

    private static void checkNonNullComparable(Object o, int index2) {
        if (o == null) {
            throw new NullPointerException(dataName[index2] + " cannot be null");
        }
        if (!(o instanceof Comparable)) {
            throw new ClassCastException(dataName[index2] + " must be Comparable");
        }
    }

    private static void checkKey(Object key2) {
        TreeBidiMap.checkNonNullComparable(key2, 0);
    }

    private static void checkValue(Object value) {
        TreeBidiMap.checkNonNullComparable(value, 1);
    }

    private static void checkKeyAndValue(Object key2, Object value) {
        TreeBidiMap.checkKey(key2);
        TreeBidiMap.checkValue(value);
    }

    private void modify() {
        ++this.modifications;
    }

    private void grow() {
        this.modify();
        ++this.nodeCount;
    }

    private void shrink() {
        this.modify();
        --this.nodeCount;
    }

    private void insertValue(Node newNode) throws IllegalArgumentException {
        block4: {
            Node node2 = this.rootNode[1];
            while (true) {
                int cmp;
                if ((cmp = TreeBidiMap.compare(newNode.getData(1), node2.getData(1))) == 0) {
                    throw new IllegalArgumentException("Cannot store a duplicate value (\"" + newNode.getData(1) + "\") in this Map");
                }
                if (cmp < 0) {
                    if (node2.getLeft(1) != null) {
                        node2 = node2.getLeft(1);
                        continue;
                    }
                    node2.setLeft(newNode, 1);
                    newNode.setParent(node2, 1);
                    this.doRedBlackInsert(newNode, 1);
                    break block4;
                }
                if (node2.getRight(1) == null) break;
                node2 = node2.getRight(1);
            }
            node2.setRight(newNode, 1);
            newNode.setParent(node2, 1);
            this.doRedBlackInsert(newNode, 1);
        }
    }

    private boolean doEquals(Object obj, int type2) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        if (other.size() != this.size()) {
            return false;
        }
        if (this.nodeCount > 0) {
            try {
                ViewMapIterator it = new ViewMapIterator(this, type2);
                while (it.hasNext()) {
                    Object key2 = it.next();
                    Object value = it.getValue();
                    if (value.equals(other.get(key2))) continue;
                    return false;
                }
            }
            catch (ClassCastException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }
        return true;
    }

    private int doHashCode(int type2) {
        int total = 0;
        if (this.nodeCount > 0) {
            ViewMapIterator it = new ViewMapIterator(this, type2);
            while (it.hasNext()) {
                Object key2 = it.next();
                Object value = it.getValue();
                total += key2.hashCode() ^ value.hashCode();
            }
        }
        return total;
    }

    private String doToString(int type2) {
        if (this.nodeCount == 0) {
            return "{}";
        }
        StringBuffer buf = new StringBuffer(this.nodeCount * 32);
        buf.append('{');
        ViewMapIterator it = new ViewMapIterator(this, type2);
        boolean hasNext = it.hasNext();
        while (hasNext) {
            Object key2 = it.next();
            Object value = it.getValue();
            buf.append(key2 == this ? "(this Map)" : key2).append('=').append(value == this ? "(this Map)" : value);
            hasNext = it.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append('}');
        return buf.toString();
    }

    static class Inverse
    implements OrderedBidiMap {
        private final TreeBidiMap main;
        private Set keySet;
        private Set valuesSet;
        private Set entrySet;

        Inverse(TreeBidiMap main2) {
            this.main = main2;
        }

        public int size() {
            return this.main.size();
        }

        public boolean isEmpty() {
            return this.main.isEmpty();
        }

        public Object get(Object key2) {
            return this.main.getKey(key2);
        }

        public Object getKey(Object value) {
            return this.main.get(value);
        }

        public boolean containsKey(Object key2) {
            return this.main.containsValue(key2);
        }

        public boolean containsValue(Object value) {
            return this.main.containsKey(value);
        }

        public Object firstKey() {
            if (this.main.nodeCount == 0) {
                throw new NoSuchElementException("Map is empty");
            }
            return TreeBidiMap.leastNode(this.main.rootNode[1], 1).getValue();
        }

        public Object lastKey() {
            if (this.main.nodeCount == 0) {
                throw new NoSuchElementException("Map is empty");
            }
            return TreeBidiMap.greatestNode(this.main.rootNode[1], 1).getValue();
        }

        public Object nextKey(Object key2) {
            TreeBidiMap.checkKey(key2);
            Node node2 = this.main.nextGreater(this.main.lookup((Comparable)key2, 1), 1);
            return node2 == null ? null : node2.getValue();
        }

        public Object previousKey(Object key2) {
            TreeBidiMap.checkKey(key2);
            Node node2 = this.main.nextSmaller(this.main.lookup((Comparable)key2, 1), 1);
            return node2 == null ? null : node2.getValue();
        }

        public Object put(Object key2, Object value) {
            return this.main.doPut((Comparable)value, (Comparable)key2, 1);
        }

        public void putAll(Map map2) {
            Iterator it = map2.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }

        public Object remove(Object key2) {
            return this.main.removeValue(key2);
        }

        public Object removeValue(Object value) {
            return this.main.remove(value);
        }

        public void clear() {
            this.main.clear();
        }

        public Set keySet() {
            if (this.keySet == null) {
                this.keySet = new View(this.main, 1, 1);
            }
            return this.keySet;
        }

        public Collection values() {
            if (this.valuesSet == null) {
                this.valuesSet = new View(this.main, 1, 0);
            }
            return this.valuesSet;
        }

        public Set entrySet() {
            if (this.entrySet == null) {
                return new EntryView(this.main, 1, 3);
            }
            return this.entrySet;
        }

        public MapIterator mapIterator() {
            if (this.isEmpty()) {
                return EmptyOrderedMapIterator.INSTANCE;
            }
            return new ViewMapIterator(this.main, 1);
        }

        public OrderedMapIterator orderedMapIterator() {
            if (this.isEmpty()) {
                return EmptyOrderedMapIterator.INSTANCE;
            }
            return new ViewMapIterator(this.main, 1);
        }

        public BidiMap inverseBidiMap() {
            return this.main;
        }

        public OrderedBidiMap inverseOrderedBidiMap() {
            return this.main;
        }

        public boolean equals(Object obj) {
            return this.main.doEquals(obj, 1);
        }

        public int hashCode() {
            return this.main.doHashCode(1);
        }

        public String toString() {
            return this.main.doToString(1);
        }
    }

    static class Node
    implements Map.Entry,
    KeyValue {
        private Comparable[] data;
        private Node[] leftNode;
        private Node[] rightNode;
        private Node[] parentNode;
        private boolean[] blackColor;
        private int hashcodeValue;
        private boolean calculatedHashCode;

        Node(Comparable key2, Comparable value) {
            this.data = new Comparable[]{key2, value};
            this.leftNode = new Node[2];
            this.rightNode = new Node[2];
            this.parentNode = new Node[2];
            this.blackColor = new boolean[]{true, true};
            this.calculatedHashCode = false;
        }

        private Comparable getData(int index2) {
            return this.data[index2];
        }

        private void setLeft(Node node2, int index2) {
            this.leftNode[index2] = node2;
        }

        private Node getLeft(int index2) {
            return this.leftNode[index2];
        }

        private void setRight(Node node2, int index2) {
            this.rightNode[index2] = node2;
        }

        private Node getRight(int index2) {
            return this.rightNode[index2];
        }

        private void setParent(Node node2, int index2) {
            this.parentNode[index2] = node2;
        }

        private Node getParent(int index2) {
            return this.parentNode[index2];
        }

        private void swapColors(Node node2, int index2) {
            int n = index2;
            this.blackColor[n] = this.blackColor[n] ^ node2.blackColor[index2];
            int n2 = index2;
            node2.blackColor[n2] = node2.blackColor[n2] ^ this.blackColor[index2];
            int n3 = index2;
            this.blackColor[n3] = this.blackColor[n3] ^ node2.blackColor[index2];
        }

        private boolean isBlack(int index2) {
            return this.blackColor[index2];
        }

        private boolean isRed(int index2) {
            return !this.blackColor[index2];
        }

        private void setBlack(int index2) {
            this.blackColor[index2] = true;
        }

        private void setRed(int index2) {
            this.blackColor[index2] = false;
        }

        private void copyColor(Node node2, int index2) {
            this.blackColor[index2] = node2.blackColor[index2];
        }

        public Object getKey() {
            return this.data[0];
        }

        public Object getValue() {
            return this.data[1];
        }

        public Object setValue(Object ignored) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Map.Entry.setValue is not supported");
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)obj;
            return this.data[0].equals(e2.getKey()) && this.data[1].equals(e2.getValue());
        }

        public int hashCode() {
            if (!this.calculatedHashCode) {
                this.hashcodeValue = this.data[0].hashCode() ^ this.data[1].hashCode();
                this.calculatedHashCode = true;
            }
            return this.hashcodeValue;
        }
    }

    static class EntryView
    extends View {
        private final int oppositeType;

        EntryView(TreeBidiMap main2, int orderType, int dataType) {
            super(main2, orderType, dataType);
            this.oppositeType = TreeBidiMap.oppositeIndex(orderType);
        }

        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Object value = entry.getValue();
            Node node2 = this.main.lookup((Comparable)entry.getKey(), this.orderType);
            return node2 != null && node2.getData(this.oppositeType).equals(value);
        }

        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Object value = entry.getValue();
            Node node2 = this.main.lookup((Comparable)entry.getKey(), this.orderType);
            if (node2 != null && node2.getData(this.oppositeType).equals(value)) {
                this.main.doRedBlackDelete(node2);
                return true;
            }
            return false;
        }
    }

    static class ViewMapIterator
    extends ViewIterator
    implements OrderedMapIterator {
        private final int oppositeType;

        ViewMapIterator(TreeBidiMap main2, int orderType) {
            super(main2, orderType, orderType);
            this.oppositeType = TreeBidiMap.oppositeIndex(this.dataType);
        }

        public Object getKey() {
            if (this.lastReturnedNode == null) {
                throw new IllegalStateException("Iterator getKey() can only be called after next() and before remove()");
            }
            return this.lastReturnedNode.getData(this.dataType);
        }

        public Object getValue() {
            if (this.lastReturnedNode == null) {
                throw new IllegalStateException("Iterator getValue() can only be called after next() and before remove()");
            }
            return this.lastReturnedNode.getData(this.oppositeType);
        }

        public Object setValue(Object obj) {
            throw new UnsupportedOperationException();
        }
    }

    static class ViewIterator
    implements OrderedIterator {
        protected final TreeBidiMap main;
        protected final int orderType;
        protected final int dataType;
        protected Node lastReturnedNode;
        protected Node nextNode;
        protected Node previousNode;
        private int expectedModifications;

        ViewIterator(TreeBidiMap main2, int orderType, int dataType) {
            this.main = main2;
            this.orderType = orderType;
            this.dataType = dataType;
            this.expectedModifications = main2.modifications;
            this.nextNode = TreeBidiMap.leastNode(main2.rootNode[orderType], orderType);
            this.lastReturnedNode = null;
            this.previousNode = null;
        }

        public final boolean hasNext() {
            return this.nextNode != null;
        }

        public final Object next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            if (this.main.modifications != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            this.lastReturnedNode = this.nextNode;
            this.previousNode = this.nextNode;
            this.nextNode = this.main.nextGreater(this.nextNode, this.orderType);
            return this.doGetData();
        }

        public boolean hasPrevious() {
            return this.previousNode != null;
        }

        public Object previous() {
            if (this.previousNode == null) {
                throw new NoSuchElementException();
            }
            if (this.main.modifications != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            this.nextNode = this.lastReturnedNode;
            if (this.nextNode == null) {
                this.nextNode = this.main.nextGreater(this.previousNode, this.orderType);
            }
            this.lastReturnedNode = this.previousNode;
            this.previousNode = this.main.nextSmaller(this.previousNode, this.orderType);
            return this.doGetData();
        }

        protected Object doGetData() {
            switch (this.dataType) {
                case 0: {
                    return this.lastReturnedNode.getKey();
                }
                case 1: {
                    return this.lastReturnedNode.getValue();
                }
                case 2: {
                    return this.lastReturnedNode;
                }
                case 3: {
                    return new UnmodifiableMapEntry(this.lastReturnedNode.getValue(), this.lastReturnedNode.getKey());
                }
            }
            return null;
        }

        public final void remove() {
            if (this.lastReturnedNode == null) {
                throw new IllegalStateException();
            }
            if (this.main.modifications != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            this.main.doRedBlackDelete(this.lastReturnedNode);
            ++this.expectedModifications;
            this.lastReturnedNode = null;
            this.previousNode = this.nextNode == null ? TreeBidiMap.greatestNode(this.main.rootNode[this.orderType], this.orderType) : this.main.nextSmaller(this.nextNode, this.orderType);
        }
    }

    static class View
    extends AbstractSet {
        protected final TreeBidiMap main;
        protected final int orderType;
        protected final int dataType;

        View(TreeBidiMap main2, int orderType, int dataType) {
            this.main = main2;
            this.orderType = orderType;
            this.dataType = dataType;
        }

        public Iterator iterator() {
            return new ViewIterator(this.main, this.orderType, this.dataType);
        }

        public int size() {
            return this.main.size();
        }

        public boolean contains(Object obj) {
            TreeBidiMap.checkNonNullComparable(obj, this.dataType);
            return this.main.lookup((Comparable)obj, this.dataType) != null;
        }

        public boolean remove(Object obj) {
            return this.main.doRemove((Comparable)obj, this.dataType) != null;
        }

        public void clear() {
            this.main.clear();
        }
    }
}

