/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExtendedProperties
extends Hashtable {
    private ExtendedProperties defaults;
    protected String file;
    protected String basePath;
    protected String fileSeparator = System.getProperty("file.separator");
    protected boolean isInitialized = false;
    protected static String include = "include";
    protected ArrayList keysAsListed = new ArrayList();
    protected static final String START_TOKEN = "${";
    protected static final String END_TOKEN = "}";

    protected String interpolate(String base) {
        return this.interpolateHelper(base, null);
    }

    protected String interpolateHelper(String base, List priorVariables) {
        if (base == null) {
            return null;
        }
        if (priorVariables == null) {
            priorVariables = new ArrayList<String>();
            priorVariables.add(base);
        }
        int begin = -1;
        int end = -1;
        int prec = 0 - END_TOKEN.length();
        String variable = null;
        StringBuffer result = new StringBuffer();
        while ((begin = base.indexOf(START_TOKEN, prec + END_TOKEN.length())) > -1 && (end = base.indexOf(END_TOKEN, begin)) > -1) {
            result.append(base.substring(prec + END_TOKEN.length(), begin));
            variable = base.substring(begin + START_TOKEN.length(), end);
            if (priorVariables.contains(variable)) {
                String initialBase = priorVariables.remove(0).toString();
                priorVariables.add(variable);
                StringBuffer priorVariableSb = new StringBuffer();
                Iterator it = priorVariables.iterator();
                while (it.hasNext()) {
                    priorVariableSb.append(it.next());
                    if (!it.hasNext()) continue;
                    priorVariableSb.append("->");
                }
                throw new IllegalStateException("infinite loop in property interpolation of " + initialBase + ": " + priorVariableSb.toString());
            }
            priorVariables.add(variable);
            Object value = this.getProperty(variable);
            if (value != null) {
                result.append(this.interpolateHelper(value.toString(), priorVariables));
                priorVariables.remove(priorVariables.size() - 1);
            } else if (this.defaults != null && this.defaults.getString(variable, null) != null) {
                result.append(this.defaults.getString(variable));
            } else {
                result.append(START_TOKEN).append(variable).append(END_TOKEN);
            }
            prec = end;
        }
        result.append(base.substring(prec + END_TOKEN.length(), base.length()));
        return result.toString();
    }

    private static String escape(String s) {
        StringBuffer buf = new StringBuffer(s);
        for (int i = 0; i < buf.length(); ++i) {
            char c = buf.charAt(i);
            if (c != ',' && c != '\\') continue;
            buf.insert(i, '\\');
            ++i;
        }
        return buf.toString();
    }

    private static String unescape(String s) {
        StringBuffer buf = new StringBuffer(s);
        for (int i = 0; i < buf.length() - 1; ++i) {
            char c1 = buf.charAt(i);
            char c2 = buf.charAt(i + 1);
            if (c1 != '\\' || c2 != '\\') continue;
            buf.deleteCharAt(i);
        }
        return buf.toString();
    }

    private static int countPreceding(String line, int index2, char ch) {
        int i;
        for (i = index2 - 1; i >= 0 && line.charAt(i) == ch; --i) {
        }
        return index2 - 1 - i;
    }

    private static boolean endsWithSlash(String line) {
        if (!line.endsWith("\\")) {
            return false;
        }
        return ExtendedProperties.countPreceding(line, line.length() - 1, '\\') % 2 == 0;
    }

    public ExtendedProperties() {
    }

    public ExtendedProperties(String file2) throws IOException {
        this(file2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedProperties(String file2, String defaultFile) throws IOException {
        this.file = file2;
        this.basePath = new File(file2).getAbsolutePath();
        this.basePath = this.basePath.substring(0, this.basePath.lastIndexOf(this.fileSeparator) + 1);
        FileInputStream in = null;
        try {
            in = new FileInputStream(file2);
            this.load(in);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {}
        }
        if (defaultFile != null) {
            this.defaults = new ExtendedProperties(defaultFile);
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public String getInclude() {
        return include;
    }

    public void setInclude(String inc2) {
        include = inc2;
    }

    public void load(InputStream input) throws IOException {
        this.load(input, null);
    }

    public synchronized void load(InputStream input, String enc) throws IOException {
        PropertiesReader reader2 = null;
        if (enc != null) {
            try {
                reader2 = new PropertiesReader(new InputStreamReader(input, enc));
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
        }
        if (reader2 == null) {
            try {
                reader2 = new PropertiesReader(new InputStreamReader(input, "8859_1"));
            }
            catch (UnsupportedEncodingException ex) {
                reader2 = new PropertiesReader(new InputStreamReader(input));
            }
        }
        try {
            while (true) {
                String line;
                if ((line = reader2.readProperty()) == null) {
                    return;
                }
                int equalSign = line.indexOf(61);
                if (equalSign <= 0) continue;
                String key2 = line.substring(0, equalSign).trim();
                String value = line.substring(equalSign + 1).trim();
                if ("".equals(value)) continue;
                if (this.getInclude() != null && key2.equalsIgnoreCase(this.getInclude())) {
                    File file2 = null;
                    if (value.startsWith(this.fileSeparator)) {
                        file2 = new File(value);
                    } else {
                        if (value.startsWith("." + this.fileSeparator)) {
                            value = value.substring(2);
                        }
                        file2 = new File(this.basePath + value);
                    }
                    if (file2 == null || !file2.exists() || !file2.canRead()) continue;
                    this.load(new FileInputStream(file2));
                    continue;
                }
                this.addProperty(key2, value);
            }
        }
        finally {
            this.isInitialized = true;
        }
    }

    public Object getProperty(String key2) {
        Object obj = this.get(key2);
        if (obj == null && this.defaults != null) {
            obj = this.defaults.get(key2);
        }
        return obj;
    }

    public void addProperty(String key2, Object value) {
        if (value instanceof String) {
            String str2 = (String)value;
            if (str2.indexOf(",") > 0) {
                PropertiesTokenizer tokenizer = new PropertiesTokenizer(str2);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    this.addPropertyInternal(key2, ExtendedProperties.unescape(token));
                }
            } else {
                this.addPropertyInternal(key2, ExtendedProperties.unescape(str2));
            }
        } else {
            this.addPropertyInternal(key2, value);
        }
        this.isInitialized = true;
    }

    private void addPropertyDirect(String key2, Object value) {
        if (!this.containsKey(key2)) {
            this.keysAsListed.add(key2);
        }
        this.put(key2, value);
    }

    private void addPropertyInternal(String key2, Object value) {
        Object current = this.get(key2);
        if (current instanceof String) {
            Vector<Object> values = new Vector<Object>(2);
            values.add(current);
            values.add(value);
            this.put(key2, values);
        } else if (current instanceof List) {
            ((List)current).add(value);
        } else {
            if (!this.containsKey(key2)) {
                this.keysAsListed.add(key2);
            }
            this.put(key2, value);
        }
    }

    public void setProperty(String key2, Object value) {
        this.clearProperty(key2);
        this.addProperty(key2, value);
    }

    public synchronized void save(OutputStream output, String header) throws IOException {
        if (output == null) {
            return;
        }
        PrintWriter theWrtr = new PrintWriter(output);
        if (header != null) {
            theWrtr.println(header);
        }
        Enumeration theKeys = this.keys();
        while (theKeys.hasMoreElements()) {
            String key2 = (String)theKeys.nextElement();
            Object value = this.get(key2);
            if (value != null) {
                if (value instanceof String) {
                    StringBuffer currentOutput = new StringBuffer();
                    currentOutput.append(key2);
                    currentOutput.append("=");
                    currentOutput.append(ExtendedProperties.escape((String)value));
                    theWrtr.println(currentOutput.toString());
                } else if (value instanceof List) {
                    List values = (List)value;
                    Iterator it = values.iterator();
                    while (it.hasNext()) {
                        String currentElement = (String)it.next();
                        StringBuffer currentOutput = new StringBuffer();
                        currentOutput.append(key2);
                        currentOutput.append("=");
                        currentOutput.append(ExtendedProperties.escape(currentElement));
                        theWrtr.println(currentOutput.toString());
                    }
                }
            }
            theWrtr.println();
            theWrtr.flush();
        }
    }

    public void combine(ExtendedProperties props) {
        Iterator it = props.getKeys();
        while (it.hasNext()) {
            String key2 = (String)it.next();
            this.setProperty(key2, props.get(key2));
        }
    }

    public void clearProperty(String key2) {
        if (this.containsKey(key2)) {
            for (int i = 0; i < this.keysAsListed.size(); ++i) {
                if (!this.keysAsListed.get(i).equals(key2)) continue;
                this.keysAsListed.remove(i);
                break;
            }
            this.remove(key2);
        }
    }

    public Iterator getKeys() {
        return this.keysAsListed.iterator();
    }

    public Iterator getKeys(String prefix) {
        Iterator keys2 = this.getKeys();
        ArrayList matchingKeys = new ArrayList();
        while (keys2.hasNext()) {
            Object key2 = keys2.next();
            if (!(key2 instanceof String) || !((String)key2).startsWith(prefix)) continue;
            matchingKeys.add(key2);
        }
        return matchingKeys.iterator();
    }

    public ExtendedProperties subset(String prefix) {
        ExtendedProperties c = new ExtendedProperties();
        Iterator keys2 = this.getKeys();
        boolean validSubset = false;
        while (keys2.hasNext()) {
            Object key2 = keys2.next();
            if (!(key2 instanceof String) || !((String)key2).startsWith(prefix)) continue;
            if (!validSubset) {
                validSubset = true;
            }
            String newKey = null;
            newKey = ((String)key2).length() == prefix.length() ? prefix : ((String)key2).substring(prefix.length() + 1);
            c.addPropertyDirect(newKey, this.get(key2));
        }
        if (validSubset) {
            return c;
        }
        return null;
    }

    public void display() {
        Iterator i = this.getKeys();
        while (i.hasNext()) {
            String key2 = (String)i.next();
            Object value = this.get(key2);
            System.out.println(key2 + " => " + value);
        }
    }

    public String getString(String key2) {
        return this.getString(key2, null);
    }

    public String getString(String key2, String defaultValue) {
        Object value = this.get(key2);
        if (value instanceof String) {
            return this.interpolate((String)value);
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.interpolate(this.defaults.getString(key2, defaultValue));
            }
            return this.interpolate(defaultValue);
        }
        if (value instanceof List) {
            return this.interpolate((String)((List)value).get(0));
        }
        throw new ClassCastException('\'' + key2 + "' doesn't map to a String object");
    }

    public Properties getProperties(String key2) {
        return this.getProperties(key2, new Properties());
    }

    public Properties getProperties(String key2, Properties defaults) {
        String[] tokens = this.getStringArray(key2);
        Properties props = new Properties(defaults);
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            int equalSign = token.indexOf(61);
            if (equalSign <= 0) {
                throw new IllegalArgumentException('\'' + token + "' does not contain " + "an equals sign");
            }
            String pkey = token.substring(0, equalSign).trim();
            String pvalue = token.substring(equalSign + 1).trim();
            props.put(pkey, pvalue);
        }
        return props;
    }

    public String[] getStringArray(String key2) {
        List values;
        Object value = this.get(key2);
        if (value instanceof String) {
            values = new Vector(1);
            values.add(value);
        } else if (value instanceof List) {
            values = (List)value;
        } else {
            if (value == null) {
                if (this.defaults != null) {
                    return this.defaults.getStringArray(key2);
                }
                return new String[0];
            }
            throw new ClassCastException('\'' + key2 + "' doesn't map to a String/List object");
        }
        String[] tokens = new String[values.size()];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = (String)values.get(i);
        }
        return tokens;
    }

    public Vector getVector(String key2) {
        return this.getVector(key2, null);
    }

    public Vector getVector(String key2, Vector defaultValue) {
        Object value = this.get(key2);
        if (value instanceof List) {
            return new Vector((List)value);
        }
        if (value instanceof String) {
            Vector values = new Vector(1);
            values.add(value);
            this.put(key2, values);
            return values;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getVector(key2, defaultValue);
            }
            return defaultValue == null ? new Vector() : defaultValue;
        }
        throw new ClassCastException('\'' + key2 + "' doesn't map to a Vector object");
    }

    public List getList(String key2) {
        return this.getList(key2, null);
    }

    public List getList(String key2, List defaultValue) {
        Object value = this.get(key2);
        if (value instanceof List) {
            return new ArrayList((List)value);
        }
        if (value instanceof String) {
            ArrayList values = new ArrayList(1);
            values.add(value);
            this.put(key2, values);
            return values;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getList(key2, defaultValue);
            }
            return defaultValue == null ? new ArrayList() : defaultValue;
        }
        throw new ClassCastException('\'' + key2 + "' doesn't map to a List object");
    }

    public boolean getBoolean(String key2) {
        Boolean b = this.getBoolean(key2, null);
        if (b != null) {
            return b;
        }
        throw new NoSuchElementException('\'' + key2 + "' doesn't map to an existing object");
    }

    public boolean getBoolean(String key2, boolean defaultValue) {
        return this.getBoolean(key2, new Boolean(defaultValue));
    }

    public Boolean getBoolean(String key2, Boolean defaultValue) {
        Object value = this.get(key2);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String s = this.testBoolean((String)value);
            Boolean b = new Boolean(s);
            this.put(key2, b);
            return b;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getBoolean(key2, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException('\'' + key2 + "' doesn't map to a Boolean object");
    }

    public String testBoolean(String value) {
        String s = value.toLowerCase();
        if (s.equals("true") || s.equals("on") || s.equals("yes")) {
            return "true";
        }
        if (s.equals("false") || s.equals("off") || s.equals("no")) {
            return "false";
        }
        return null;
    }

    public byte getByte(String key2) {
        Byte b = this.getByte(key2, null);
        if (b != null) {
            return b;
        }
        throw new NoSuchElementException('\'' + key2 + " doesn't map to an existing object");
    }

    public byte getByte(String key2, byte defaultValue) {
        return this.getByte(key2, new Byte(defaultValue));
    }

    public Byte getByte(String key2, Byte defaultValue) {
        Object value = this.get(key2);
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            Byte b = new Byte((String)value);
            this.put(key2, b);
            return b;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getByte(key2, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException('\'' + key2 + "' doesn't map to a Byte object");
    }

    public short getShort(String key2) {
        Short s = this.getShort(key2, null);
        if (s != null) {
            return s;
        }
        throw new NoSuchElementException('\'' + key2 + "' doesn't map to an existing object");
    }

    public short getShort(String key2, short defaultValue) {
        return this.getShort(key2, new Short(defaultValue));
    }

    public Short getShort(String key2, Short defaultValue) {
        Object value = this.get(key2);
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            Short s = new Short((String)value);
            this.put(key2, s);
            return s;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getShort(key2, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException('\'' + key2 + "' doesn't map to a Short object");
    }

    public int getInt(String name2) {
        return this.getInteger(name2);
    }

    public int getInt(String name2, int def) {
        return this.getInteger(name2, def);
    }

    public int getInteger(String key2) {
        Integer i = this.getInteger(key2, null);
        if (i != null) {
            return i;
        }
        throw new NoSuchElementException('\'' + key2 + "' doesn't map to an existing object");
    }

    public int getInteger(String key2, int defaultValue) {
        Integer i = this.getInteger(key2, null);
        if (i == null) {
            return defaultValue;
        }
        return i;
    }

    public Integer getInteger(String key2, Integer defaultValue) {
        Object value = this.get(key2);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            Integer i = new Integer((String)value);
            this.put(key2, i);
            return i;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getInteger(key2, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException('\'' + key2 + "' doesn't map to a Integer object");
    }

    public long getLong(String key2) {
        Long l = this.getLong(key2, null);
        if (l != null) {
            return l;
        }
        throw new NoSuchElementException('\'' + key2 + "' doesn't map to an existing object");
    }

    public long getLong(String key2, long defaultValue) {
        return this.getLong(key2, new Long(defaultValue));
    }

    public Long getLong(String key2, Long defaultValue) {
        Object value = this.get(key2);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            Long l = new Long((String)value);
            this.put(key2, l);
            return l;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getLong(key2, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException('\'' + key2 + "' doesn't map to a Long object");
    }

    public float getFloat(String key2) {
        Float f = this.getFloat(key2, null);
        if (f != null) {
            return f.floatValue();
        }
        throw new NoSuchElementException('\'' + key2 + "' doesn't map to an existing object");
    }

    public float getFloat(String key2, float defaultValue) {
        return this.getFloat(key2, new Float(defaultValue)).floatValue();
    }

    public Float getFloat(String key2, Float defaultValue) {
        Object value = this.get(key2);
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof String) {
            Float f = new Float((String)value);
            this.put(key2, f);
            return f;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getFloat(key2, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException('\'' + key2 + "' doesn't map to a Float object");
    }

    public double getDouble(String key2) {
        Double d = this.getDouble(key2, null);
        if (d != null) {
            return d;
        }
        throw new NoSuchElementException('\'' + key2 + "' doesn't map to an existing object");
    }

    public double getDouble(String key2, double defaultValue) {
        return this.getDouble(key2, new Double(defaultValue));
    }

    public Double getDouble(String key2, Double defaultValue) {
        Object value = this.get(key2);
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            Double d = new Double((String)value);
            this.put(key2, d);
            return d;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getDouble(key2, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException('\'' + key2 + "' doesn't map to a Double object");
    }

    public static ExtendedProperties convertProperties(Properties props) {
        ExtendedProperties c = new ExtendedProperties();
        Enumeration<?> e2 = props.propertyNames();
        while (e2.hasMoreElements()) {
            String s = (String)e2.nextElement();
            c.setProperty(s, props.getProperty(s));
        }
        return c;
    }

    static class PropertiesTokenizer
    extends StringTokenizer {
        static final String DELIMITER = ",";

        public PropertiesTokenizer(String string2) {
            super(string2, DELIMITER);
        }

        public boolean hasMoreTokens() {
            return super.hasMoreTokens();
        }

        public String nextToken() {
            StringBuffer buffer = new StringBuffer();
            while (this.hasMoreTokens()) {
                String token = super.nextToken();
                if (ExtendedProperties.endsWithSlash(token)) {
                    buffer.append(token.substring(0, token.length() - 1));
                    buffer.append(DELIMITER);
                    continue;
                }
                buffer.append(token);
                break;
            }
            return buffer.toString().trim();
        }
    }

    static class PropertiesReader
    extends LineNumberReader {
        public PropertiesReader(Reader reader2) {
            super(reader2);
        }

        public String readProperty() throws IOException {
            StringBuffer buffer = new StringBuffer();
            String line = this.readLine();
            while (line != null) {
                if ((line = line.trim()).length() != 0 && line.charAt(0) != '#') {
                    if (ExtendedProperties.endsWithSlash(line)) {
                        line = line.substring(0, line.length() - 1);
                        buffer.append(line);
                    } else {
                        buffer.append(line);
                        return buffer.toString();
                    }
                }
                line = this.readLine();
            }
            return null;
        }
    }
}

