/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ContextClassLoaderLocal;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.expression.Resolver;
import org.apache.commons.beanutils.locale.LocaleConvertUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleBeanUtilsBean
extends BeanUtilsBean {
    private static final ContextClassLoaderLocal<LocaleBeanUtilsBean> LOCALE_BEANS_BY_CLASSLOADER = new ContextClassLoaderLocal<LocaleBeanUtilsBean>(){

        @Override
        protected LocaleBeanUtilsBean initialValue() {
            return new LocaleBeanUtilsBean();
        }
    };
    private final Log log = LogFactory.getLog(LocaleBeanUtilsBean.class);
    private final LocaleConvertUtilsBean localeConvertUtils;

    public static LocaleBeanUtilsBean getLocaleBeanUtilsInstance() {
        return LOCALE_BEANS_BY_CLASSLOADER.get();
    }

    public static void setInstance(LocaleBeanUtilsBean newInstance) {
        LOCALE_BEANS_BY_CLASSLOADER.set(newInstance);
    }

    public LocaleBeanUtilsBean() {
        this.localeConvertUtils = new LocaleConvertUtilsBean();
    }

    public LocaleBeanUtilsBean(LocaleConvertUtilsBean localeConvertUtils, ConvertUtilsBean convertUtilsBean, PropertyUtilsBean propertyUtilsBean) {
        super(convertUtilsBean, propertyUtilsBean);
        this.localeConvertUtils = localeConvertUtils;
    }

    public LocaleBeanUtilsBean(LocaleConvertUtilsBean localeConvertUtils) {
        this.localeConvertUtils = localeConvertUtils;
    }

    public LocaleConvertUtilsBean getLocaleConvertUtils() {
        return this.localeConvertUtils;
    }

    public Locale getDefaultLocale() {
        return this.getLocaleConvertUtils().getDefaultLocale();
    }

    public void setDefaultLocale(Locale locale) {
        this.getLocaleConvertUtils().setDefaultLocale(locale);
    }

    public boolean getApplyLocalized() {
        return this.getLocaleConvertUtils().getApplyLocalized();
    }

    public void setApplyLocalized(boolean newApplyLocalized) {
        this.getLocaleConvertUtils().setApplyLocalized(newApplyLocalized);
    }

    public String getIndexedProperty(Object bean2, String name2, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = this.getPropertyUtils().getIndexedProperty(bean2, name2);
        return this.getLocaleConvertUtils().convert(value, pattern);
    }

    @Override
    public String getIndexedProperty(Object bean2, String name2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getIndexedProperty(bean2, name2, null);
    }

    public String getIndexedProperty(Object bean2, String name2, int index2, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = this.getPropertyUtils().getIndexedProperty(bean2, name2, index2);
        return this.getLocaleConvertUtils().convert(value, pattern);
    }

    @Override
    public String getIndexedProperty(Object bean2, String name2, int index2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getIndexedProperty(bean2, name2, index2, null);
    }

    public String getSimpleProperty(Object bean2, String name2, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = this.getPropertyUtils().getSimpleProperty(bean2, name2);
        return this.getLocaleConvertUtils().convert(value, pattern);
    }

    @Override
    public String getSimpleProperty(Object bean2, String name2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getSimpleProperty(bean2, name2, null);
    }

    public String getMappedProperty(Object bean2, String name2, String key2, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = this.getPropertyUtils().getMappedProperty(bean2, name2, key2);
        return this.getLocaleConvertUtils().convert(value, pattern);
    }

    @Override
    public String getMappedProperty(Object bean2, String name2, String key2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getMappedProperty(bean2, name2, key2, null);
    }

    public String getMappedPropertyLocale(Object bean2, String name2, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = this.getPropertyUtils().getMappedProperty(bean2, name2);
        return this.getLocaleConvertUtils().convert(value, pattern);
    }

    @Override
    public String getMappedProperty(Object bean2, String name2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getMappedPropertyLocale(bean2, name2, null);
    }

    public String getNestedProperty(Object bean2, String name2, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = this.getPropertyUtils().getNestedProperty(bean2, name2);
        return this.getLocaleConvertUtils().convert(value, pattern);
    }

    @Override
    public String getNestedProperty(Object bean2, String name2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getNestedProperty(bean2, name2, null);
    }

    public String getProperty(Object bean2, String name2, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getNestedProperty(bean2, name2, pattern);
    }

    @Override
    public String getProperty(Object bean2, String name2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getNestedProperty(bean2, name2);
    }

    @Override
    public void setProperty(Object bean2, String name2, Object value) throws IllegalAccessException, InvocationTargetException {
        this.setProperty(bean2, name2, value, null);
    }

    public void setProperty(Object bean2, String name2, Object value, String pattern) throws IllegalAccessException, InvocationTargetException {
        if (this.log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder("  setProperty(");
            sb.append(bean2);
            sb.append(", ");
            sb.append(name2);
            sb.append(", ");
            if (value == null) {
                sb.append("<NULL>");
            } else if (value instanceof String) {
                sb.append((String)value);
            } else if (value instanceof String[]) {
                String[] values = (String[])value;
                sb.append('[');
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(values[i]);
                }
                sb.append(']');
            } else {
                sb.append(value.toString());
            }
            sb.append(')');
            this.log.trace(sb.toString());
        }
        Object target = bean2;
        Resolver resolver = this.getPropertyUtils().getResolver();
        while (resolver.hasNested(name2)) {
            try {
                target = this.getPropertyUtils().getProperty(target, resolver.next(name2));
                name2 = resolver.remove(name2);
            }
            catch (NoSuchMethodException e2) {
                return;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("    Target bean = " + target);
            this.log.trace("    Target name = " + name2);
        }
        String propName = resolver.getProperty(name2);
        int index2 = resolver.getIndex(name2);
        String key2 = resolver.getKey(name2);
        Class<?> type2 = this.definePropertyType(target, name2, propName);
        if (type2 != null) {
            Object newValue = this.convert(type2, index2, value, pattern);
            this.invokeSetter(target, propName, key2, index2, newValue);
        }
    }

    protected Class<?> definePropertyType(Object target, String name2, String propName) throws IllegalAccessException, InvocationTargetException {
        Class<?> type2 = null;
        if (target instanceof DynaBean) {
            DynaClass dynaClass = ((DynaBean)target).getDynaClass();
            DynaProperty dynaProperty = dynaClass.getDynaProperty(propName);
            if (dynaProperty == null) {
                return null;
            }
            type2 = dynaProperty.getType();
        } else {
            PropertyDescriptor descriptor2 = null;
            try {
                descriptor2 = this.getPropertyUtils().getPropertyDescriptor(target, name2);
                if (descriptor2 == null) {
                    return null;
                }
            }
            catch (NoSuchMethodException e2) {
                return null;
            }
            type2 = descriptor2 instanceof MappedPropertyDescriptor ? ((MappedPropertyDescriptor)descriptor2).getMappedPropertyType() : (descriptor2 instanceof IndexedPropertyDescriptor ? ((IndexedPropertyDescriptor)descriptor2).getIndexedPropertyType() : descriptor2.getPropertyType());
        }
        return type2;
    }

    protected Object convert(Class<?> type2, int index2, Object value, String pattern) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Converting value '" + value + "' to type:" + type2);
        }
        Object newValue = null;
        if (type2.isArray() && index2 < 0) {
            if (value instanceof String) {
                String[] values = new String[]{(String)value};
                newValue = this.getLocaleConvertUtils().convert(values, type2, pattern);
            } else {
                newValue = value instanceof String[] ? this.getLocaleConvertUtils().convert((String[])value, type2, pattern) : value;
            }
        } else {
            newValue = type2.isArray() ? (value instanceof String ? this.getLocaleConvertUtils().convert((String)value, type2.getComponentType(), pattern) : (value instanceof String[] ? this.getLocaleConvertUtils().convert(((String[])value)[0], type2.getComponentType(), pattern) : value)) : (value instanceof String ? this.getLocaleConvertUtils().convert((String)value, type2, pattern) : (value instanceof String[] ? this.getLocaleConvertUtils().convert(((String[])value)[0], type2, pattern) : value));
        }
        return newValue;
    }

    protected Object convert(Class<?> type2, int index2, Object value) {
        Object newValue = null;
        if (type2.isArray() && index2 < 0) {
            if (value instanceof String) {
                String[] values = new String[]{(String)value};
                newValue = ConvertUtils.convert(values, type2);
            } else {
                newValue = value instanceof String[] ? ConvertUtils.convert((String[])value, type2) : value;
            }
        } else {
            newValue = type2.isArray() ? (value instanceof String ? ConvertUtils.convert((String)value, type2.getComponentType()) : (value instanceof String[] ? ConvertUtils.convert(((String[])value)[0], type2.getComponentType()) : value)) : (value instanceof String ? ConvertUtils.convert((String)value, type2) : (value instanceof String[] ? ConvertUtils.convert(((String[])value)[0], type2) : value));
        }
        return newValue;
    }

    protected void invokeSetter(Object target, String propName, String key2, int index2, Object newValue) throws IllegalAccessException, InvocationTargetException {
        try {
            if (index2 >= 0) {
                this.getPropertyUtils().setIndexedProperty(target, propName, index2, newValue);
            } else if (key2 != null) {
                this.getPropertyUtils().setMappedProperty(target, propName, key2, newValue);
            } else {
                this.getPropertyUtils().setProperty(target, propName, newValue);
            }
        }
        catch (NoSuchMethodException e2) {
            throw new InvocationTargetException(e2, "Cannot set " + propName);
        }
    }

    @Deprecated
    protected Descriptor calculate(Object bean2, String name2) throws IllegalAccessException, InvocationTargetException {
        Object target = bean2;
        Resolver resolver = this.getPropertyUtils().getResolver();
        while (resolver.hasNested(name2)) {
            try {
                target = this.getPropertyUtils().getProperty(target, resolver.next(name2));
                name2 = resolver.remove(name2);
            }
            catch (NoSuchMethodException e2) {
                return null;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("    Target bean = " + target);
            this.log.trace("    Target name = " + name2);
        }
        String propName = resolver.getProperty(name2);
        int index2 = resolver.getIndex(name2);
        String key2 = resolver.getKey(name2);
        return new Descriptor(target, name2, propName, key2, index2);
    }

    @Deprecated
    protected class Descriptor {
        private int index = -1;
        private String name;
        private String propName;
        private String key;
        private Object target;

        public Descriptor(Object target, String name2, String propName, String key2, int index2) {
            this.setTarget(target);
            this.setName(name2);
            this.setPropName(propName);
            this.setKey(key2);
            this.setIndex(index2);
        }

        public Object getTarget() {
            return this.target;
        }

        public void setTarget(Object target) {
            this.target = target;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key2) {
            this.key = key2;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index2) {
            this.index = index2;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name2) {
            this.name = name2;
        }

        public String getPropName() {
            return this.propName;
        }

        public void setPropName(String propName) {
            this.propName = propName;
        }
    }
}

