/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale;

import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.locale.LocaleConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseLocaleConverter
implements LocaleConverter {
    private final Log log = LogFactory.getLog(BaseLocaleConverter.class);
    private Object defaultValue = null;
    protected boolean useDefault = false;
    protected Locale locale = Locale.getDefault();
    protected String pattern = null;
    protected boolean locPattern = false;

    protected BaseLocaleConverter(Locale locale, String pattern) {
        this(null, locale, pattern, false, false);
    }

    protected BaseLocaleConverter(Locale locale, String pattern, boolean locPattern) {
        this(null, locale, pattern, false, locPattern);
    }

    protected BaseLocaleConverter(Object defaultValue, Locale locale, String pattern) {
        this(defaultValue, locale, pattern, false);
    }

    protected BaseLocaleConverter(Object defaultValue, Locale locale, String pattern, boolean locPattern) {
        this(defaultValue, locale, pattern, true, locPattern);
    }

    private BaseLocaleConverter(Object defaultValue, Locale locale, String pattern, boolean useDefault, boolean locPattern) {
        if (useDefault) {
            this.defaultValue = defaultValue;
            this.useDefault = true;
        }
        if (locale != null) {
            this.locale = locale;
        }
        this.pattern = pattern;
        this.locPattern = locPattern;
    }

    protected abstract Object parse(Object var1, String var2) throws ParseException;

    public Object convert(Object value) {
        return this.convert(value, null);
    }

    public Object convert(Object value, String pattern) {
        return this.convert(null, value, pattern);
    }

    @Override
    public <T> T convert(Class<T> type2, Object value) {
        return this.convert(type2, value, null);
    }

    @Override
    public <T> T convert(Class<T> type2, Object value, String pattern) {
        Class<T> targetType = ConvertUtils.primitiveToWrapper(type2);
        if (value == null) {
            if (this.useDefault) {
                return this.getDefaultAs(targetType);
            }
            this.log.debug("Null value specified for conversion, returing null");
            return null;
        }
        try {
            if (pattern != null) {
                return BaseLocaleConverter.checkConversionResult(targetType, this.parse(value, pattern));
            }
            return BaseLocaleConverter.checkConversionResult(targetType, this.parse(value, this.pattern));
        }
        catch (Exception e2) {
            if (this.useDefault) {
                return this.getDefaultAs(targetType);
            }
            if (e2 instanceof ConversionException) {
                throw (ConversionException)e2;
            }
            throw new ConversionException(e2);
        }
    }

    private <T> T getDefaultAs(Class<T> type2) {
        return BaseLocaleConverter.checkConversionResult(type2, this.defaultValue);
    }

    private static <T> T checkConversionResult(Class<T> type2, Object result) {
        if (type2 == null) {
            Object temp = result;
            return (T)temp;
        }
        if (result == null) {
            return null;
        }
        if (type2.isInstance(result)) {
            return type2.cast(result);
        }
        throw new ConversionException("Unsupported target type: " + type2);
    }
}

