/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import org.apache.commons.beanutils.converters.AbstractConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BooleanConverter
extends AbstractConverter {
    @Deprecated
    public static final Object NO_DEFAULT = new Object();
    private String[] trueStrings = new String[]{"true", "yes", "y", "on", "1"};
    private String[] falseStrings = new String[]{"false", "no", "n", "off", "0"};

    public BooleanConverter() {
    }

    public BooleanConverter(Object defaultValue) {
        if (defaultValue != NO_DEFAULT) {
            this.setDefaultValue(defaultValue);
        }
    }

    public BooleanConverter(String[] trueStrings, String[] falseStrings) {
        this.trueStrings = BooleanConverter.copyStrings(trueStrings);
        this.falseStrings = BooleanConverter.copyStrings(falseStrings);
    }

    public BooleanConverter(String[] trueStrings, String[] falseStrings, Object defaultValue) {
        this.trueStrings = BooleanConverter.copyStrings(trueStrings);
        this.falseStrings = BooleanConverter.copyStrings(falseStrings);
        if (defaultValue != NO_DEFAULT) {
            this.setDefaultValue(defaultValue);
        }
    }

    protected Class<Boolean> getDefaultType() {
        return Boolean.class;
    }

    @Override
    protected <T> T convertToType(Class<T> type2, Object value) throws Throwable {
        if (Boolean.class.equals(type2) || Boolean.TYPE.equals(type2)) {
            int i;
            String stringValue = value.toString().toLowerCase();
            for (i = 0; i < this.trueStrings.length; ++i) {
                if (!this.trueStrings[i].equals(stringValue)) continue;
                return type2.cast(Boolean.TRUE);
            }
            for (i = 0; i < this.falseStrings.length; ++i) {
                if (!this.falseStrings[i].equals(stringValue)) continue;
                return type2.cast(Boolean.FALSE);
            }
        }
        throw this.conversionException(type2, value);
    }

    private static String[] copyStrings(String[] src) {
        String[] dst = new String[src.length];
        for (int i = 0; i < src.length; ++i) {
            dst[i] = src[i].toLowerCase();
        }
        return dst;
    }
}

