/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.beanutils.BeanIntrospectionData;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.DefaultBeanIntrospector;
import org.apache.commons.beanutils.DefaultIntrospectionContext;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.WeakFastHashMap;
import org.apache.commons.beanutils.WrapDynaBean;
import org.apache.commons.beanutils.expression.DefaultResolver;
import org.apache.commons.beanutils.expression.Resolver;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUtilsBean {
    private Resolver resolver = new DefaultResolver();
    private WeakFastHashMap<Class<?>, BeanIntrospectionData> descriptorsCache = null;
    private WeakFastHashMap<Class<?>, FastHashMap> mappedDescriptorsCache = null;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final Log log = LogFactory.getLog(PropertyUtils.class);
    private final List<BeanIntrospector> introspectors;

    protected static PropertyUtilsBean getInstance() {
        return BeanUtilsBean.getInstance().getPropertyUtils();
    }

    public PropertyUtilsBean() {
        this.descriptorsCache = new WeakFastHashMap();
        this.descriptorsCache.setFast(true);
        this.mappedDescriptorsCache = new WeakFastHashMap();
        this.mappedDescriptorsCache.setFast(true);
        this.introspectors = new CopyOnWriteArrayList<BeanIntrospector>();
        this.resetBeanIntrospectors();
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver == null ? new DefaultResolver() : resolver;
    }

    public final void resetBeanIntrospectors() {
        this.introspectors.clear();
        this.introspectors.add(DefaultBeanIntrospector.INSTANCE);
    }

    public void addBeanIntrospector(BeanIntrospector introspector) {
        if (introspector == null) {
            throw new IllegalArgumentException("BeanIntrospector must not be null!");
        }
        this.introspectors.add(introspector);
    }

    public boolean removeBeanIntrospector(BeanIntrospector introspector) {
        return this.introspectors.remove(introspector);
    }

    public void clearDescriptors() {
        this.descriptorsCache.clear();
        this.mappedDescriptorsCache.clear();
        Introspector.flushCaches();
    }

    public void copyProperties(Object dest, Object orig) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (dest == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (orig == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        if (orig instanceof DynaBean) {
            DynaProperty[] origDescriptors = ((DynaBean)orig).getDynaClass().getDynaProperties();
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name2 = origDescriptors[i].getName();
                if (!this.isReadable(orig, name2) || !this.isWriteable(dest, name2)) continue;
                try {
                    Object value = ((DynaBean)orig).get(name2);
                    if (dest instanceof DynaBean) {
                        ((DynaBean)dest).set(name2, value);
                        continue;
                    }
                    this.setSimpleProperty(dest, name2, value);
                    continue;
                }
                catch (NoSuchMethodException e2) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Error writing to '" + name2 + "' on class '" + dest.getClass() + "'", e2);
                }
            }
        } else if (orig instanceof Map) {
            for (Map.Entry entry : ((Map)orig).entrySet()) {
                String name3 = (String)entry.getKey();
                if (!this.isWriteable(dest, name3)) continue;
                try {
                    if (dest instanceof DynaBean) {
                        ((DynaBean)dest).set(name3, entry.getValue());
                        continue;
                    }
                    this.setSimpleProperty(dest, name3, entry.getValue());
                }
                catch (NoSuchMethodException e3) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Error writing to '" + name3 + "' on class '" + dest.getClass() + "'", e3);
                }
            }
        } else {
            PropertyDescriptor[] origDescriptors = this.getPropertyDescriptors(orig);
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name4 = origDescriptors[i].getName();
                if (!this.isReadable(orig, name4) || !this.isWriteable(dest, name4)) continue;
                try {
                    Object value = this.getSimpleProperty(orig, name4);
                    if (dest instanceof DynaBean) {
                        ((DynaBean)dest).set(name4, value);
                        continue;
                    }
                    this.setSimpleProperty(dest, name4, value);
                    continue;
                }
                catch (NoSuchMethodException e4) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Error writing to '" + name4 + "' on class '" + dest.getClass() + "'", e4);
                }
            }
        }
    }

    public Map<String, Object> describe(Object bean2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        HashMap<String, Object> description = new HashMap<String, Object>();
        if (bean2 instanceof DynaBean) {
            DynaProperty[] descriptors = ((DynaBean)bean2).getDynaClass().getDynaProperties();
            for (int i = 0; i < descriptors.length; ++i) {
                String name2 = descriptors[i].getName();
                description.put(name2, this.getProperty(bean2, name2));
            }
        } else {
            PropertyDescriptor[] descriptors = this.getPropertyDescriptors(bean2);
            for (int i = 0; i < descriptors.length; ++i) {
                String name3 = descriptors[i].getName();
                if (descriptors[i].getReadMethod() == null) continue;
                description.put(name3, this.getProperty(bean2, name3));
            }
        }
        return description;
    }

    public Object getIndexedProperty(Object bean2, String name2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name2 == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        int index2 = -1;
        try {
            index2 = this.resolver.getIndex(name2);
        }
        catch (IllegalArgumentException e2) {
            throw new IllegalArgumentException("Invalid indexed property '" + name2 + "' on bean class '" + bean2.getClass() + "' " + e2.getMessage());
        }
        if (index2 < 0) {
            throw new IllegalArgumentException("Invalid indexed property '" + name2 + "' on bean class '" + bean2.getClass() + "'");
        }
        name2 = this.resolver.getProperty(name2);
        return this.getIndexedProperty(bean2, name2, index2);
    }

    public Object getIndexedProperty(Object bean2, String name2, int index2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method readMethod;
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name2 == null || name2.length() == 0) {
            if (bean2.getClass().isArray()) {
                return Array.get(bean2, index2);
            }
            if (bean2 instanceof List) {
                return ((List)bean2).get(index2);
            }
        }
        if (name2 == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        if (bean2 instanceof DynaBean) {
            DynaProperty descriptor2 = ((DynaBean)bean2).getDynaClass().getDynaProperty(name2);
            if (descriptor2 == null) {
                throw new NoSuchMethodException("Unknown property '" + name2 + "' on bean class '" + bean2.getClass() + "'");
            }
            return ((DynaBean)bean2).get(name2, index2);
        }
        PropertyDescriptor descriptor3 = this.getPropertyDescriptor(bean2, name2);
        if (descriptor3 == null) {
            throw new NoSuchMethodException("Unknown property '" + name2 + "' on bean class '" + bean2.getClass() + "'");
        }
        if (descriptor3 instanceof IndexedPropertyDescriptor) {
            readMethod = ((IndexedPropertyDescriptor)descriptor3).getIndexedReadMethod();
            readMethod = MethodUtils.getAccessibleMethod(bean2.getClass(), readMethod);
            if (readMethod != null) {
                Object[] subscript = new Object[]{new Integer(index2)};
                try {
                    return this.invokeMethod(readMethod, bean2, subscript);
                }
                catch (InvocationTargetException e2) {
                    if (e2.getTargetException() instanceof IndexOutOfBoundsException) {
                        throw (IndexOutOfBoundsException)e2.getTargetException();
                    }
                    throw e2;
                }
            }
        }
        if ((readMethod = this.getReadMethod(bean2.getClass(), descriptor3)) == null) {
            throw new NoSuchMethodException("Property '" + name2 + "' has no " + "getter method on bean class '" + bean2.getClass() + "'");
        }
        Object value = this.invokeMethod(readMethod, bean2, EMPTY_OBJECT_ARRAY);
        if (!value.getClass().isArray()) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("Property '" + name2 + "' is not indexed on bean class '" + bean2.getClass() + "'");
            }
            return ((List)value).get(index2);
        }
        try {
            return Array.get(value, index2);
        }
        catch (ArrayIndexOutOfBoundsException e3) {
            throw new ArrayIndexOutOfBoundsException("Index: " + index2 + ", Size: " + Array.getLength(value) + " for property '" + name2 + "'");
        }
    }

    public Object getMappedProperty(Object bean2, String name2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name2 == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        String key2 = null;
        try {
            key2 = this.resolver.getKey(name2);
        }
        catch (IllegalArgumentException e2) {
            throw new IllegalArgumentException("Invalid mapped property '" + name2 + "' on bean class '" + bean2.getClass() + "' " + e2.getMessage());
        }
        if (key2 == null) {
            throw new IllegalArgumentException("Invalid mapped property '" + name2 + "' on bean class '" + bean2.getClass() + "'");
        }
        name2 = this.resolver.getProperty(name2);
        return this.getMappedProperty(bean2, name2, key2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getMappedProperty(Object bean2, String name2, String key2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name2 == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        if (key2 == null) {
            throw new IllegalArgumentException("No key specified for property '" + name2 + "' on bean class " + bean2.getClass() + "'");
        }
        if (bean2 instanceof DynaBean) {
            DynaProperty descriptor2 = ((DynaBean)bean2).getDynaClass().getDynaProperty(name2);
            if (descriptor2 != null) return ((DynaBean)bean2).get(name2, key2);
            throw new NoSuchMethodException("Unknown property '" + name2 + "'+ on bean class '" + bean2.getClass() + "'");
        }
        Object result = null;
        PropertyDescriptor descriptor3 = this.getPropertyDescriptor(bean2, name2);
        if (descriptor3 == null) {
            throw new NoSuchMethodException("Unknown property '" + name2 + "'+ on bean class '" + bean2.getClass() + "'");
        }
        if (descriptor3 instanceof MappedPropertyDescriptor) {
            Method readMethod = ((MappedPropertyDescriptor)descriptor3).getMappedReadMethod();
            readMethod = MethodUtils.getAccessibleMethod(bean2.getClass(), readMethod);
            if (readMethod == null) throw new NoSuchMethodException("Property '" + name2 + "' has no mapped getter method on bean class '" + bean2.getClass() + "'");
            Object[] keyArray = new Object[]{key2};
            return this.invokeMethod(readMethod, bean2, keyArray);
        }
        Method readMethod = this.getReadMethod(bean2.getClass(), descriptor3);
        if (readMethod == null) throw new NoSuchMethodException("Property '" + name2 + "' has no mapped getter method on bean class '" + bean2.getClass() + "'");
        Object invokeResult = this.invokeMethod(readMethod, bean2, EMPTY_OBJECT_ARRAY);
        if (!(invokeResult instanceof Map)) return result;
        return ((Map)invokeResult).get(key2);
    }

    @Deprecated
    public FastHashMap getMappedPropertyDescriptors(Class<?> beanClass) {
        if (beanClass == null) {
            return null;
        }
        return this.mappedDescriptorsCache.get(beanClass);
    }

    @Deprecated
    public FastHashMap getMappedPropertyDescriptors(Object bean2) {
        if (bean2 == null) {
            return null;
        }
        return this.getMappedPropertyDescriptors(bean2.getClass());
    }

    public Object getNestedProperty(Object bean2, String name2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name2 == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        while (this.resolver.hasNested(name2)) {
            String next2 = this.resolver.next(name2);
            Object nestedBean = null;
            nestedBean = bean2 instanceof Map ? this.getPropertyOfMapBean((Map)bean2, next2) : (this.resolver.isMapped(next2) ? this.getMappedProperty(bean2, next2) : (this.resolver.isIndexed(next2) ? this.getIndexedProperty(bean2, next2) : this.getSimpleProperty(bean2, next2)));
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + name2 + "' on bean class '" + bean2.getClass() + "'");
            }
            bean2 = nestedBean;
            name2 = this.resolver.remove(name2);
        }
        bean2 = bean2 instanceof Map ? this.getPropertyOfMapBean((Map)bean2, name2) : (this.resolver.isMapped(name2) ? this.getMappedProperty(bean2, name2) : (this.resolver.isIndexed(name2) ? this.getIndexedProperty(bean2, name2) : this.getSimpleProperty(bean2, name2)));
        return bean2;
    }

    protected Object getPropertyOfMapBean(Map<?, ?> bean2, String propertyName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String name2;
        if (this.resolver.isMapped(propertyName) && ((name2 = this.resolver.getProperty(propertyName)) == null || name2.length() == 0)) {
            propertyName = this.resolver.getKey(propertyName);
        }
        if (this.resolver.isIndexed(propertyName) || this.resolver.isMapped(propertyName)) {
            throw new IllegalArgumentException("Indexed or mapped properties are not supported on objects of type Map: " + propertyName);
        }
        return bean2.get(propertyName);
    }

    public Object getProperty(Object bean2, String name2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getNestedProperty(bean2, name2);
    }

    public PropertyDescriptor getPropertyDescriptor(Object bean2, String name2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name2 == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        while (this.resolver.hasNested(name2)) {
            String next2 = this.resolver.next(name2);
            Object nestedBean = this.getProperty(bean2, next2);
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next2 + "' on bean class '" + bean2.getClass() + "'");
            }
            bean2 = nestedBean;
            name2 = this.resolver.remove(name2);
        }
        if ((name2 = this.resolver.getProperty(name2)) == null) {
            return null;
        }
        BeanIntrospectionData data2 = this.getIntrospectionData(bean2.getClass());
        PropertyDescriptor result = data2.getDescriptor(name2);
        if (result != null) {
            return result;
        }
        FastHashMap mappedDescriptors = this.getMappedPropertyDescriptors(bean2);
        if (mappedDescriptors == null) {
            mappedDescriptors = new FastHashMap();
            mappedDescriptors.setFast(true);
            this.mappedDescriptorsCache.put(bean2.getClass(), mappedDescriptors);
        }
        if ((result = (PropertyDescriptor)mappedDescriptors.get(name2)) == null) {
            try {
                result = new MappedPropertyDescriptor(name2, bean2.getClass());
            }
            catch (IntrospectionException ie) {
                // empty catch block
            }
            if (result != null) {
                mappedDescriptors.put(name2, result);
            }
        }
        return result;
    }

    public PropertyDescriptor[] getPropertyDescriptors(Class<?> beanClass) {
        return this.getIntrospectionData(beanClass).getDescriptors();
    }

    public PropertyDescriptor[] getPropertyDescriptors(Object bean2) {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        return this.getPropertyDescriptors(bean2.getClass());
    }

    public Class<?> getPropertyEditorClass(Object bean2, String name2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name2 == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        PropertyDescriptor descriptor2 = this.getPropertyDescriptor(bean2, name2);
        if (descriptor2 != null) {
            return descriptor2.getPropertyEditorClass();
        }
        return null;
    }

    public Class<?> getPropertyType(Object bean2, String name2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object descriptor2;
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name2 == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        while (this.resolver.hasNested(name2)) {
            String next2 = this.resolver.next(name2);
            Object nestedBean = this.getProperty(bean2, next2);
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next2 + "' on bean class '" + bean2.getClass() + "'");
            }
            bean2 = nestedBean;
            name2 = this.resolver.remove(name2);
        }
        name2 = this.resolver.getProperty(name2);
        if (bean2 instanceof DynaBean) {
            descriptor2 = ((DynaBean)bean2).getDynaClass().getDynaProperty(name2);
            if (descriptor2 == null) {
                return null;
            }
            Class<?> type2 = ((DynaProperty)descriptor2).getType();
            if (type2 == null) {
                return null;
            }
            if (type2.isArray()) {
                return type2.getComponentType();
            }
            return type2;
        }
        descriptor2 = this.getPropertyDescriptor(bean2, name2);
        if (descriptor2 == null) {
            return null;
        }
        if (descriptor2 instanceof IndexedPropertyDescriptor) {
            return ((IndexedPropertyDescriptor)descriptor2).getIndexedPropertyType();
        }
        if (descriptor2 instanceof MappedPropertyDescriptor) {
            return ((MappedPropertyDescriptor)descriptor2).getMappedPropertyType();
        }
        return ((PropertyDescriptor)descriptor2).getPropertyType();
    }

    public Method getReadMethod(PropertyDescriptor descriptor2) {
        return MethodUtils.getAccessibleMethod(descriptor2.getReadMethod());
    }

    Method getReadMethod(Class<?> clazz, PropertyDescriptor descriptor2) {
        return MethodUtils.getAccessibleMethod(clazz, descriptor2.getReadMethod());
    }

    public Object getSimpleProperty(Object bean2, String name2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name2 == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        if (this.resolver.hasNested(name2)) {
            throw new IllegalArgumentException("Nested property names are not allowed: Property '" + name2 + "' on bean class '" + bean2.getClass() + "'");
        }
        if (this.resolver.isIndexed(name2)) {
            throw new IllegalArgumentException("Indexed property names are not allowed: Property '" + name2 + "' on bean class '" + bean2.getClass() + "'");
        }
        if (this.resolver.isMapped(name2)) {
            throw new IllegalArgumentException("Mapped property names are not allowed: Property '" + name2 + "' on bean class '" + bean2.getClass() + "'");
        }
        if (bean2 instanceof DynaBean) {
            DynaProperty descriptor2 = ((DynaBean)bean2).getDynaClass().getDynaProperty(name2);
            if (descriptor2 == null) {
                throw new NoSuchMethodException("Unknown property '" + name2 + "' on dynaclass '" + ((DynaBean)bean2).getDynaClass() + "'");
            }
            return ((DynaBean)bean2).get(name2);
        }
        PropertyDescriptor descriptor3 = this.getPropertyDescriptor(bean2, name2);
        if (descriptor3 == null) {
            throw new NoSuchMethodException("Unknown property '" + name2 + "' on class '" + bean2.getClass() + "'");
        }
        Method readMethod = this.getReadMethod(bean2.getClass(), descriptor3);
        if (readMethod == null) {
            throw new NoSuchMethodException("Property '" + name2 + "' has no getter method in class '" + bean2.getClass() + "'");
        }
        Object value = this.invokeMethod(readMethod, bean2, EMPTY_OBJECT_ARRAY);
        return value;
    }

    public Method getWriteMethod(PropertyDescriptor descriptor2) {
        return MethodUtils.getAccessibleMethod(descriptor2.getWriteMethod());
    }

    public Method getWriteMethod(Class<?> clazz, PropertyDescriptor descriptor2) {
        BeanIntrospectionData data2 = this.getIntrospectionData(clazz);
        return MethodUtils.getAccessibleMethod(clazz, data2.getWriteMethod(clazz, descriptor2));
    }

    public boolean isReadable(Object bean2, String name2) {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name2 == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        while (this.resolver.hasNested(name2)) {
            String next2 = this.resolver.next(name2);
            Object nestedBean = null;
            try {
                nestedBean = this.getProperty(bean2, next2);
            }
            catch (IllegalAccessException e2) {
                return false;
            }
            catch (InvocationTargetException e3) {
                return false;
            }
            catch (NoSuchMethodException e4) {
                return false;
            }
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next2 + "' on bean class '" + bean2.getClass() + "'");
            }
            bean2 = nestedBean;
            name2 = this.resolver.remove(name2);
        }
        name2 = this.resolver.getProperty(name2);
        if (bean2 instanceof WrapDynaBean) {
            bean2 = ((WrapDynaBean)bean2).getInstance();
        }
        if (bean2 instanceof DynaBean) {
            return ((DynaBean)bean2).getDynaClass().getDynaProperty(name2) != null;
        }
        try {
            PropertyDescriptor desc = this.getPropertyDescriptor(bean2, name2);
            if (desc != null) {
                Method readMethod = this.getReadMethod(bean2.getClass(), desc);
                if (readMethod == null) {
                    if (desc instanceof IndexedPropertyDescriptor) {
                        readMethod = ((IndexedPropertyDescriptor)desc).getIndexedReadMethod();
                    } else if (desc instanceof MappedPropertyDescriptor) {
                        readMethod = ((MappedPropertyDescriptor)desc).getMappedReadMethod();
                    }
                    readMethod = MethodUtils.getAccessibleMethod(bean2.getClass(), readMethod);
                }
                return readMethod != null;
            }
            return false;
        }
        catch (IllegalAccessException e5) {
            return false;
        }
        catch (InvocationTargetException e6) {
            return false;
        }
        catch (NoSuchMethodException e7) {
            return false;
        }
    }

    public boolean isWriteable(Object bean2, String name2) {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name2 == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        while (this.resolver.hasNested(name2)) {
            String next2 = this.resolver.next(name2);
            Object nestedBean = null;
            try {
                nestedBean = this.getProperty(bean2, next2);
            }
            catch (IllegalAccessException e2) {
                return false;
            }
            catch (InvocationTargetException e3) {
                return false;
            }
            catch (NoSuchMethodException e4) {
                return false;
            }
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next2 + "' on bean class '" + bean2.getClass() + "'");
            }
            bean2 = nestedBean;
            name2 = this.resolver.remove(name2);
        }
        name2 = this.resolver.getProperty(name2);
        if (bean2 instanceof WrapDynaBean) {
            bean2 = ((WrapDynaBean)bean2).getInstance();
        }
        if (bean2 instanceof DynaBean) {
            return ((DynaBean)bean2).getDynaClass().getDynaProperty(name2) != null;
        }
        try {
            PropertyDescriptor desc = this.getPropertyDescriptor(bean2, name2);
            if (desc != null) {
                Method writeMethod = this.getWriteMethod(bean2.getClass(), desc);
                if (writeMethod == null) {
                    if (desc instanceof IndexedPropertyDescriptor) {
                        writeMethod = ((IndexedPropertyDescriptor)desc).getIndexedWriteMethod();
                    } else if (desc instanceof MappedPropertyDescriptor) {
                        writeMethod = ((MappedPropertyDescriptor)desc).getMappedWriteMethod();
                    }
                    writeMethod = MethodUtils.getAccessibleMethod(bean2.getClass(), writeMethod);
                }
                return writeMethod != null;
            }
            return false;
        }
        catch (IllegalAccessException e5) {
            return false;
        }
        catch (InvocationTargetException e6) {
            return false;
        }
        catch (NoSuchMethodException e7) {
            return false;
        }
    }

    public void setIndexedProperty(Object bean2, String name2, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name2 == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        int index2 = -1;
        try {
            index2 = this.resolver.getIndex(name2);
        }
        catch (IllegalArgumentException e2) {
            throw new IllegalArgumentException("Invalid indexed property '" + name2 + "' on bean class '" + bean2.getClass() + "'");
        }
        if (index2 < 0) {
            throw new IllegalArgumentException("Invalid indexed property '" + name2 + "' on bean class '" + bean2.getClass() + "'");
        }
        name2 = this.resolver.getProperty(name2);
        this.setIndexedProperty(bean2, name2, index2, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setIndexedProperty(Object bean2, String name2, int index2, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method readMethod;
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name2 == null || name2.length() == 0) {
            if (bean2.getClass().isArray()) {
                Array.set(bean2, index2, value);
                return;
            }
            if (bean2 instanceof List) {
                List<Object> list = PropertyUtilsBean.toObjectList(bean2);
                list.set(index2, value);
                return;
            }
        }
        if (name2 == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        if (bean2 instanceof DynaBean) {
            DynaProperty descriptor2 = ((DynaBean)bean2).getDynaClass().getDynaProperty(name2);
            if (descriptor2 == null) {
                throw new NoSuchMethodException("Unknown property '" + name2 + "' on bean class '" + bean2.getClass() + "'");
            }
            ((DynaBean)bean2).set(name2, index2, value);
            return;
        }
        PropertyDescriptor descriptor3 = this.getPropertyDescriptor(bean2, name2);
        if (descriptor3 == null) {
            throw new NoSuchMethodException("Unknown property '" + name2 + "' on bean class '" + bean2.getClass() + "'");
        }
        if (descriptor3 instanceof IndexedPropertyDescriptor) {
            Method writeMethod = ((IndexedPropertyDescriptor)descriptor3).getIndexedWriteMethod();
            writeMethod = MethodUtils.getAccessibleMethod(bean2.getClass(), writeMethod);
            if (writeMethod != null) {
                Object[] subscript = new Object[]{new Integer(index2), value};
                try {
                    if (this.log.isTraceEnabled()) {
                        String valueClassName = value == null ? "<null>" : value.getClass().getName();
                        this.log.trace("setSimpleProperty: Invoking method " + writeMethod + " with index=" + index2 + ", value=" + value + " (class " + valueClassName + ")");
                    }
                    this.invokeMethod(writeMethod, bean2, subscript);
                    return;
                }
                catch (InvocationTargetException e2) {
                    if (!(e2.getTargetException() instanceof IndexOutOfBoundsException)) throw e2;
                    throw (IndexOutOfBoundsException)e2.getTargetException();
                }
            }
        }
        if ((readMethod = this.getReadMethod(bean2.getClass(), descriptor3)) == null) {
            throw new NoSuchMethodException("Property '" + name2 + "' has no getter method on bean class '" + bean2.getClass() + "'");
        }
        Object array2 = this.invokeMethod(readMethod, bean2, EMPTY_OBJECT_ARRAY);
        if (!array2.getClass().isArray()) {
            if (!(array2 instanceof List)) throw new IllegalArgumentException("Property '" + name2 + "' is not indexed on bean class '" + bean2.getClass() + "'");
            List<Object> list = PropertyUtilsBean.toObjectList(array2);
            list.set(index2, value);
            return;
        } else {
            Array.set(array2, index2, value);
        }
    }

    public void setMappedProperty(Object bean2, String name2, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name2 == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        String key2 = null;
        try {
            key2 = this.resolver.getKey(name2);
        }
        catch (IllegalArgumentException e2) {
            throw new IllegalArgumentException("Invalid mapped property '" + name2 + "' on bean class '" + bean2.getClass() + "'");
        }
        if (key2 == null) {
            throw new IllegalArgumentException("Invalid mapped property '" + name2 + "' on bean class '" + bean2.getClass() + "'");
        }
        name2 = this.resolver.getProperty(name2);
        this.setMappedProperty(bean2, name2, key2, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMappedProperty(Object bean2, String name2, String key2, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name2 == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        if (key2 == null) {
            throw new IllegalArgumentException("No key specified for property '" + name2 + "' on bean class '" + bean2.getClass() + "'");
        }
        if (bean2 instanceof DynaBean) {
            DynaProperty descriptor2 = ((DynaBean)bean2).getDynaClass().getDynaProperty(name2);
            if (descriptor2 == null) {
                throw new NoSuchMethodException("Unknown property '" + name2 + "' on bean class '" + bean2.getClass() + "'");
            }
            ((DynaBean)bean2).set(name2, key2, value);
            return;
        }
        PropertyDescriptor descriptor3 = this.getPropertyDescriptor(bean2, name2);
        if (descriptor3 == null) {
            throw new NoSuchMethodException("Unknown property '" + name2 + "' on bean class '" + bean2.getClass() + "'");
        }
        if (descriptor3 instanceof MappedPropertyDescriptor) {
            Method mappedWriteMethod = ((MappedPropertyDescriptor)descriptor3).getMappedWriteMethod();
            mappedWriteMethod = MethodUtils.getAccessibleMethod(bean2.getClass(), mappedWriteMethod);
            if (mappedWriteMethod == null) throw new NoSuchMethodException("Property '" + name2 + "' has no mapped setter method" + "on bean class '" + bean2.getClass() + "'");
            Object[] params = new Object[]{key2, value};
            if (this.log.isTraceEnabled()) {
                String valueClassName = value == null ? "<null>" : value.getClass().getName();
                this.log.trace("setSimpleProperty: Invoking method " + mappedWriteMethod + " with key=" + key2 + ", value=" + value + " (class " + valueClassName + ")");
            }
            this.invokeMethod(mappedWriteMethod, bean2, params);
            return;
        } else {
            Method readMethod = this.getReadMethod(bean2.getClass(), descriptor3);
            if (readMethod == null) throw new NoSuchMethodException("Property '" + name2 + "' has no mapped getter method on bean class '" + bean2.getClass() + "'");
            Object invokeResult = this.invokeMethod(readMethod, bean2, EMPTY_OBJECT_ARRAY);
            if (!(invokeResult instanceof Map)) return;
            Map<String, Object> map2 = PropertyUtilsBean.toPropertyMap(invokeResult);
            map2.put(key2, value);
        }
    }

    public void setNestedProperty(Object bean2, String name2, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name2 == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        while (this.resolver.hasNested(name2)) {
            String next2 = this.resolver.next(name2);
            Object nestedBean = null;
            nestedBean = bean2 instanceof Map ? this.getPropertyOfMapBean((Map)bean2, next2) : (this.resolver.isMapped(next2) ? this.getMappedProperty(bean2, next2) : (this.resolver.isIndexed(next2) ? this.getIndexedProperty(bean2, next2) : this.getSimpleProperty(bean2, next2)));
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + name2 + "' on bean class '" + bean2.getClass() + "'");
            }
            bean2 = nestedBean;
            name2 = this.resolver.remove(name2);
        }
        if (bean2 instanceof Map) {
            this.setPropertyOfMapBean(PropertyUtilsBean.toPropertyMap(bean2), name2, value);
        } else if (this.resolver.isMapped(name2)) {
            this.setMappedProperty(bean2, name2, value);
        } else if (this.resolver.isIndexed(name2)) {
            this.setIndexedProperty(bean2, name2, value);
        } else {
            this.setSimpleProperty(bean2, name2, value);
        }
    }

    protected void setPropertyOfMapBean(Map<String, Object> bean2, String propertyName, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String name2;
        if (this.resolver.isMapped(propertyName) && ((name2 = this.resolver.getProperty(propertyName)) == null || name2.length() == 0)) {
            propertyName = this.resolver.getKey(propertyName);
        }
        if (this.resolver.isIndexed(propertyName) || this.resolver.isMapped(propertyName)) {
            throw new IllegalArgumentException("Indexed or mapped properties are not supported on objects of type Map: " + propertyName);
        }
        bean2.put(propertyName, value);
    }

    public void setProperty(Object bean2, String name2, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.setNestedProperty(bean2, name2, value);
    }

    public void setSimpleProperty(Object bean2, String name2, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name2 == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        if (this.resolver.hasNested(name2)) {
            throw new IllegalArgumentException("Nested property names are not allowed: Property '" + name2 + "' on bean class '" + bean2.getClass() + "'");
        }
        if (this.resolver.isIndexed(name2)) {
            throw new IllegalArgumentException("Indexed property names are not allowed: Property '" + name2 + "' on bean class '" + bean2.getClass() + "'");
        }
        if (this.resolver.isMapped(name2)) {
            throw new IllegalArgumentException("Mapped property names are not allowed: Property '" + name2 + "' on bean class '" + bean2.getClass() + "'");
        }
        if (bean2 instanceof DynaBean) {
            DynaProperty descriptor2 = ((DynaBean)bean2).getDynaClass().getDynaProperty(name2);
            if (descriptor2 == null) {
                throw new NoSuchMethodException("Unknown property '" + name2 + "' on dynaclass '" + ((DynaBean)bean2).getDynaClass() + "'");
            }
            ((DynaBean)bean2).set(name2, value);
            return;
        }
        PropertyDescriptor descriptor3 = this.getPropertyDescriptor(bean2, name2);
        if (descriptor3 == null) {
            throw new NoSuchMethodException("Unknown property '" + name2 + "' on class '" + bean2.getClass() + "'");
        }
        Method writeMethod = this.getWriteMethod(bean2.getClass(), descriptor3);
        if (writeMethod == null) {
            throw new NoSuchMethodException("Property '" + name2 + "' has no setter method in class '" + bean2.getClass() + "'");
        }
        Object[] values = new Object[]{value};
        if (this.log.isTraceEnabled()) {
            String valueClassName = value == null ? "<null>" : value.getClass().getName();
            this.log.trace("setSimpleProperty: Invoking method " + writeMethod + " with value " + value + " (class " + valueClassName + ")");
        }
        this.invokeMethod(writeMethod, bean2, values);
    }

    private Object invokeMethod(Method method, Object bean2, Object[] values) throws IllegalAccessException, InvocationTargetException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified - this should have been checked before reaching this method");
        }
        try {
            return method.invoke(bean2, values);
        }
        catch (NullPointerException cause) {
            IllegalArgumentException e2;
            String valueString = "";
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        valueString = valueString + ", ";
                    }
                    valueString = values[i] == null ? valueString + "<null>" : valueString + values[i].getClass().getName();
                }
            }
            String expectedString = "";
            Class<?>[] parTypes = method.getParameterTypes();
            if (parTypes != null) {
                for (int i = 0; i < parTypes.length; ++i) {
                    if (i > 0) {
                        expectedString = expectedString + ", ";
                    }
                    expectedString = expectedString + parTypes[i].getName();
                }
            }
            if (!BeanUtils.initCause(e2 = new IllegalArgumentException("Cannot invoke " + method.getDeclaringClass().getName() + "." + method.getName() + " on bean class '" + bean2.getClass() + "' - " + cause.getMessage() + " - had objects of type \"" + valueString + "\" but expected signature \"" + expectedString + "\""), cause)) {
                this.log.error("Method invocation failed", cause);
            }
            throw e2;
        }
        catch (IllegalArgumentException cause) {
            IllegalArgumentException e3;
            String valueString = "";
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        valueString = valueString + ", ";
                    }
                    valueString = values[i] == null ? valueString + "<null>" : valueString + values[i].getClass().getName();
                }
            }
            String expectedString = "";
            Class<?>[] parTypes = method.getParameterTypes();
            if (parTypes != null) {
                for (int i = 0; i < parTypes.length; ++i) {
                    if (i > 0) {
                        expectedString = expectedString + ", ";
                    }
                    expectedString = expectedString + parTypes[i].getName();
                }
            }
            if (!BeanUtils.initCause(e3 = new IllegalArgumentException("Cannot invoke " + method.getDeclaringClass().getName() + "." + method.getName() + " on bean class '" + bean2.getClass() + "' - " + cause.getMessage() + " - had objects of type \"" + valueString + "\" but expected signature \"" + expectedString + "\""), cause)) {
                this.log.error("Method invocation failed", cause);
            }
            throw e3;
        }
    }

    private BeanIntrospectionData getIntrospectionData(Class<?> beanClass) {
        if (beanClass == null) {
            throw new IllegalArgumentException("No bean class specified");
        }
        BeanIntrospectionData data2 = this.descriptorsCache.get(beanClass);
        if (data2 == null) {
            data2 = this.fetchIntrospectionData(beanClass);
            this.descriptorsCache.put(beanClass, data2);
        }
        return data2;
    }

    private BeanIntrospectionData fetchIntrospectionData(Class<?> beanClass) {
        DefaultIntrospectionContext ictx = new DefaultIntrospectionContext(beanClass);
        for (BeanIntrospector bi : this.introspectors) {
            try {
                bi.introspect(ictx);
            }
            catch (IntrospectionException iex) {
                this.log.error("Exception during introspection", iex);
            }
        }
        return new BeanIntrospectionData(ictx.getPropertyDescriptors());
    }

    private static List<Object> toObjectList(Object obj) {
        List list = (List)obj;
        return list;
    }

    private static Map<String, Object> toPropertyMap(Object obj) {
        Map map2 = (Map)obj;
        return map2;
    }
}

