/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaBeanPropertyMapDecorator;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.LazyDynaClass;
import org.apache.commons.beanutils.MutableDynaClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyDynaBean
implements DynaBean,
Serializable {
    private transient Log logger = LogFactory.getLog(LazyDynaBean.class);
    protected static final BigInteger BigInteger_ZERO = new BigInteger("0");
    protected static final BigDecimal BigDecimal_ZERO = new BigDecimal("0");
    protected static final Character Character_SPACE = new Character(' ');
    protected static final Byte Byte_ZERO = new Byte(0);
    protected static final Short Short_ZERO = new Short(0);
    protected static final Integer Integer_ZERO = new Integer(0);
    protected static final Long Long_ZERO = new Long(0L);
    protected static final Float Float_ZERO = new Float(0.0f);
    protected static final Double Double_ZERO = new Double(0.0);
    protected Map<String, Object> values = this.newMap();
    private transient Map<String, Object> mapDecorator;
    protected MutableDynaClass dynaClass;

    public LazyDynaBean() {
        this(new LazyDynaClass());
    }

    public LazyDynaBean(String name2) {
        this(new LazyDynaClass(name2));
    }

    public LazyDynaBean(DynaClass dynaClass) {
        this.dynaClass = dynaClass instanceof MutableDynaClass ? (MutableDynaClass)dynaClass : new LazyDynaClass(dynaClass.getName(), dynaClass.getDynaProperties());
    }

    public Map<String, Object> getMap() {
        if (this.mapDecorator == null) {
            this.mapDecorator = new DynaBeanPropertyMapDecorator(this);
        }
        return this.mapDecorator;
    }

    public int size(String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object value = this.values.get(name2);
        if (value == null) {
            return 0;
        }
        if (value instanceof Map) {
            return ((Map)value).size();
        }
        if (value instanceof List) {
            return ((List)value).size();
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value);
        }
        return 0;
    }

    @Override
    public boolean contains(String name2, String key2) {
        if (name2 == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object value = this.values.get(name2);
        if (value == null) {
            return false;
        }
        if (value instanceof Map) {
            return ((Map)value).containsKey(key2);
        }
        return false;
    }

    @Override
    public Object get(String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object value = this.values.get(name2);
        if (value != null) {
            return value;
        }
        if (!this.isDynaProperty(name2)) {
            return null;
        }
        value = this.createProperty(name2, this.dynaClass.getDynaProperty(name2).getType());
        if (value != null) {
            this.set(name2, value);
        }
        return value;
    }

    @Override
    public Object get(String name2, int index2) {
        if (!this.isDynaProperty(name2)) {
            this.set(name2, this.defaultIndexedProperty(name2));
        }
        Object indexedProperty = this.get(name2);
        if (!this.dynaClass.getDynaProperty(name2).isIndexed()) {
            throw new IllegalArgumentException("Non-indexed property for '" + name2 + "[" + index2 + "]' " + this.dynaClass.getDynaProperty(name2).getName());
        }
        if ((indexedProperty = this.growIndexedProperty(name2, indexedProperty, index2)).getClass().isArray()) {
            return Array.get(indexedProperty, index2);
        }
        if (indexedProperty instanceof List) {
            return ((List)indexedProperty).get(index2);
        }
        throw new IllegalArgumentException("Non-indexed property for '" + name2 + "[" + index2 + "]' " + indexedProperty.getClass().getName());
    }

    @Override
    public Object get(String name2, String key2) {
        if (!this.isDynaProperty(name2)) {
            this.set(name2, this.defaultMappedProperty(name2));
        }
        Object mappedProperty = this.get(name2);
        if (!this.dynaClass.getDynaProperty(name2).isMapped()) {
            throw new IllegalArgumentException("Non-mapped property for '" + name2 + "(" + key2 + ")' " + this.dynaClass.getDynaProperty(name2).getType().getName());
        }
        if (mappedProperty instanceof Map) {
            return ((Map)mappedProperty).get(key2);
        }
        throw new IllegalArgumentException("Non-mapped property for '" + name2 + "(" + key2 + ")'" + mappedProperty.getClass().getName());
    }

    @Override
    public DynaClass getDynaClass() {
        return this.dynaClass;
    }

    @Override
    public void remove(String name2, String key2) {
        if (name2 == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object value = this.values.get(name2);
        if (value == null) {
            return;
        }
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException("Non-mapped property for '" + name2 + "(" + key2 + ")'" + value.getClass().getName());
        }
        ((Map)value).remove(key2);
    }

    @Override
    public void set(String name2, Object value) {
        if (!this.isDynaProperty(name2)) {
            if (this.dynaClass.isRestricted()) {
                throw new IllegalArgumentException("Invalid property name '" + name2 + "' (DynaClass is restricted)");
            }
            if (value == null) {
                this.dynaClass.add(name2);
            } else {
                this.dynaClass.add(name2, value.getClass());
            }
        }
        DynaProperty descriptor2 = this.dynaClass.getDynaProperty(name2);
        if (value == null) {
            if (descriptor2.getType().isPrimitive()) {
                throw new NullPointerException("Primitive value for '" + name2 + "'");
            }
        } else if (!this.isAssignable(descriptor2.getType(), value.getClass())) {
            throw new ConversionException("Cannot assign value of type '" + value.getClass().getName() + "' to property '" + name2 + "' of type '" + descriptor2.getType().getName() + "'");
        }
        this.values.put(name2, value);
    }

    @Override
    public void set(String name2, int index2, Object value) {
        if (!this.isDynaProperty(name2)) {
            this.set(name2, this.defaultIndexedProperty(name2));
        }
        Object indexedProperty = this.get(name2);
        if (!this.dynaClass.getDynaProperty(name2).isIndexed()) {
            throw new IllegalArgumentException("Non-indexed property for '" + name2 + "[" + index2 + "]'" + this.dynaClass.getDynaProperty(name2).getType().getName());
        }
        if ((indexedProperty = this.growIndexedProperty(name2, indexedProperty, index2)).getClass().isArray()) {
            Array.set(indexedProperty, index2, value);
        } else if (indexedProperty instanceof List) {
            List values = (List)indexedProperty;
            values.set(index2, value);
        } else {
            throw new IllegalArgumentException("Non-indexed property for '" + name2 + "[" + index2 + "]' " + indexedProperty.getClass().getName());
        }
    }

    @Override
    public void set(String name2, String key2, Object value) {
        if (!this.isDynaProperty(name2)) {
            this.set(name2, this.defaultMappedProperty(name2));
        }
        Object mappedProperty = this.get(name2);
        if (!this.dynaClass.getDynaProperty(name2).isMapped()) {
            throw new IllegalArgumentException("Non-mapped property for '" + name2 + "(" + key2 + ")'" + this.dynaClass.getDynaProperty(name2).getType().getName());
        }
        Map valuesMap = (Map)mappedProperty;
        valuesMap.put(key2, value);
    }

    protected Object growIndexedProperty(String name2, Object indexedProperty, int index2) {
        int length;
        if (indexedProperty instanceof List) {
            List list = (List)indexedProperty;
            while (index2 >= list.size()) {
                Class<?> contentType = this.getDynaClass().getDynaProperty(name2).getContentType();
                Object value = null;
                if (contentType != null) {
                    value = this.createProperty(name2 + "[" + list.size() + "]", contentType);
                }
                list.add(value);
            }
        }
        if (indexedProperty.getClass().isArray() && index2 >= (length = Array.getLength(indexedProperty))) {
            Class<?> componentType = indexedProperty.getClass().getComponentType();
            Object newArray = Array.newInstance(componentType, index2 + 1);
            System.arraycopy(indexedProperty, 0, newArray, 0, length);
            indexedProperty = newArray;
            this.set(name2, indexedProperty);
            int newLength = Array.getLength(indexedProperty);
            for (int i = length; i < newLength; ++i) {
                Array.set(indexedProperty, i, this.createProperty(name2 + "[" + i + "]", componentType));
            }
        }
        return indexedProperty;
    }

    protected Object createProperty(String name2, Class<?> type2) {
        if (type2 == null) {
            return null;
        }
        if (type2.isArray() || List.class.isAssignableFrom(type2)) {
            return this.createIndexedProperty(name2, type2);
        }
        if (Map.class.isAssignableFrom(type2)) {
            return this.createMappedProperty(name2, type2);
        }
        if (DynaBean.class.isAssignableFrom(type2)) {
            return this.createDynaBeanProperty(name2, type2);
        }
        if (type2.isPrimitive()) {
            return this.createPrimitiveProperty(name2, type2);
        }
        if (Number.class.isAssignableFrom(type2)) {
            return this.createNumberProperty(name2, type2);
        }
        return this.createOtherProperty(name2, type2);
    }

    protected Object createIndexedProperty(String name2, Class<?> type2) {
        Object indexedProperty = null;
        if (type2 == null) {
            indexedProperty = this.defaultIndexedProperty(name2);
        } else if (type2.isArray()) {
            indexedProperty = Array.newInstance(type2.getComponentType(), 0);
        } else if (List.class.isAssignableFrom(type2)) {
            if (type2.isInterface()) {
                indexedProperty = this.defaultIndexedProperty(name2);
            } else {
                try {
                    indexedProperty = type2.newInstance();
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Error instantiating indexed property of type '" + type2.getName() + "' for '" + name2 + "' " + ex);
                }
            }
        } else {
            throw new IllegalArgumentException("Non-indexed property of type '" + type2.getName() + "' for '" + name2 + "'");
        }
        return indexedProperty;
    }

    protected Object createMappedProperty(String name2, Class<?> type2) {
        Map<String, Object> mappedProperty = null;
        if (type2 == null) {
            mappedProperty = this.defaultMappedProperty(name2);
        } else if (type2.isInterface()) {
            mappedProperty = this.defaultMappedProperty(name2);
        } else if (Map.class.isAssignableFrom(type2)) {
            try {
                mappedProperty = type2.newInstance();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Error instantiating mapped property of type '" + type2.getName() + "' for '" + name2 + "' " + ex);
            }
        } else {
            throw new IllegalArgumentException("Non-mapped property of type '" + type2.getName() + "' for '" + name2 + "'");
        }
        return mappedProperty;
    }

    protected Object createDynaBeanProperty(String name2, Class<?> type2) {
        try {
            return type2.newInstance();
        }
        catch (Exception ex) {
            if (this.logger().isWarnEnabled()) {
                this.logger().warn("Error instantiating DynaBean property of type '" + type2.getName() + "' for '" + name2 + "' " + ex);
            }
            return null;
        }
    }

    protected Object createPrimitiveProperty(String name2, Class<?> type2) {
        if (type2 == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (type2 == Integer.TYPE) {
            return Integer_ZERO;
        }
        if (type2 == Long.TYPE) {
            return Long_ZERO;
        }
        if (type2 == Double.TYPE) {
            return Double_ZERO;
        }
        if (type2 == Float.TYPE) {
            return Float_ZERO;
        }
        if (type2 == Byte.TYPE) {
            return Byte_ZERO;
        }
        if (type2 == Short.TYPE) {
            return Short_ZERO;
        }
        if (type2 == Character.TYPE) {
            return Character_SPACE;
        }
        return null;
    }

    protected Object createNumberProperty(String name2, Class<?> type2) {
        return null;
    }

    protected Object createOtherProperty(String name2, Class<?> type2) {
        if (type2 == Object.class || type2 == String.class || type2 == Boolean.class || type2 == Character.class || Date.class.isAssignableFrom(type2)) {
            return null;
        }
        try {
            return type2.newInstance();
        }
        catch (Exception ex) {
            if (this.logger().isWarnEnabled()) {
                this.logger().warn("Error instantiating property of type '" + type2.getName() + "' for '" + name2 + "' " + ex);
            }
            return null;
        }
    }

    protected Object defaultIndexedProperty(String name2) {
        return new ArrayList();
    }

    protected Map<String, Object> defaultMappedProperty(String name2) {
        return new HashMap<String, Object>();
    }

    protected boolean isDynaProperty(String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        if (this.dynaClass instanceof LazyDynaClass) {
            return ((LazyDynaClass)this.dynaClass).isDynaProperty(name2);
        }
        return this.dynaClass.getDynaProperty(name2) != null;
    }

    protected boolean isAssignable(Class<?> dest, Class<?> source2) {
        return dest.isAssignableFrom(source2) || dest == Boolean.TYPE && source2 == Boolean.class || dest == Byte.TYPE && source2 == Byte.class || dest == Character.TYPE && source2 == Character.class || dest == Double.TYPE && source2 == Double.class || dest == Float.TYPE && source2 == Float.class || dest == Integer.TYPE && source2 == Integer.class || dest == Long.TYPE && source2 == Long.class || dest == Short.TYPE && source2 == Short.class;
    }

    protected Map<String, Object> newMap() {
        return new HashMap<String, Object>();
    }

    private Log logger() {
        if (this.logger == null) {
            this.logger = LogFactory.getLog(LazyDynaBean.class);
        }
        return this.logger;
    }
}

