/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaBeanPropertyMapDecorator;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDynaBean
implements DynaBean,
Serializable {
    protected DynaClass dynaClass = null;
    protected HashMap<String, Object> values = new HashMap();
    private transient Map<String, Object> mapDecorator;

    public BasicDynaBean(DynaClass dynaClass) {
        this.dynaClass = dynaClass;
    }

    public Map<String, Object> getMap() {
        if (this.mapDecorator == null) {
            this.mapDecorator = new DynaBeanPropertyMapDecorator(this);
        }
        return this.mapDecorator;
    }

    @Override
    public boolean contains(String name2, String key2) {
        Object value = this.values.get(name2);
        if (value == null) {
            throw new NullPointerException("No mapped value for '" + name2 + "(" + key2 + ")'");
        }
        if (value instanceof Map) {
            return ((Map)value).containsKey(key2);
        }
        throw new IllegalArgumentException("Non-mapped property for '" + name2 + "(" + key2 + ")'");
    }

    @Override
    public Object get(String name2) {
        Object value = this.values.get(name2);
        if (value != null) {
            return value;
        }
        Class<?> type2 = this.getDynaProperty(name2).getType();
        if (!type2.isPrimitive()) {
            return value;
        }
        if (type2 == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (type2 == Byte.TYPE) {
            return new Byte(0);
        }
        if (type2 == Character.TYPE) {
            return new Character('\u0000');
        }
        if (type2 == Double.TYPE) {
            return new Double(0.0);
        }
        if (type2 == Float.TYPE) {
            return new Float(0.0f);
        }
        if (type2 == Integer.TYPE) {
            return new Integer(0);
        }
        if (type2 == Long.TYPE) {
            return new Long(0L);
        }
        if (type2 == Short.TYPE) {
            return new Short(0);
        }
        return null;
    }

    @Override
    public Object get(String name2, int index2) {
        Object value = this.values.get(name2);
        if (value == null) {
            throw new NullPointerException("No indexed value for '" + name2 + "[" + index2 + "]'");
        }
        if (value.getClass().isArray()) {
            return Array.get(value, index2);
        }
        if (value instanceof List) {
            return ((List)value).get(index2);
        }
        throw new IllegalArgumentException("Non-indexed property for '" + name2 + "[" + index2 + "]'");
    }

    @Override
    public Object get(String name2, String key2) {
        Object value = this.values.get(name2);
        if (value == null) {
            throw new NullPointerException("No mapped value for '" + name2 + "(" + key2 + ")'");
        }
        if (value instanceof Map) {
            return ((Map)value).get(key2);
        }
        throw new IllegalArgumentException("Non-mapped property for '" + name2 + "(" + key2 + ")'");
    }

    @Override
    public DynaClass getDynaClass() {
        return this.dynaClass;
    }

    @Override
    public void remove(String name2, String key2) {
        Object value = this.values.get(name2);
        if (value == null) {
            throw new NullPointerException("No mapped value for '" + name2 + "(" + key2 + ")'");
        }
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException("Non-mapped property for '" + name2 + "(" + key2 + ")'");
        }
        ((Map)value).remove(key2);
    }

    @Override
    public void set(String name2, Object value) {
        DynaProperty descriptor2 = this.getDynaProperty(name2);
        if (value == null) {
            if (descriptor2.getType().isPrimitive()) {
                throw new NullPointerException("Primitive value for '" + name2 + "'");
            }
        } else if (!this.isAssignable(descriptor2.getType(), value.getClass())) {
            throw new ConversionException("Cannot assign value of type '" + value.getClass().getName() + "' to property '" + name2 + "' of type '" + descriptor2.getType().getName() + "'");
        }
        this.values.put(name2, value);
    }

    @Override
    public void set(String name2, int index2, Object value) {
        Object prop = this.values.get(name2);
        if (prop == null) {
            throw new NullPointerException("No indexed value for '" + name2 + "[" + index2 + "]'");
        }
        if (prop.getClass().isArray()) {
            Array.set(prop, index2, value);
        } else if (prop instanceof List) {
            try {
                List list = (List)prop;
                list.set(index2, value);
            }
            catch (ClassCastException e2) {
                throw new ConversionException(e2.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Non-indexed property for '" + name2 + "[" + index2 + "]'");
        }
    }

    @Override
    public void set(String name2, String key2, Object value) {
        Object prop = this.values.get(name2);
        if (prop == null) {
            throw new NullPointerException("No mapped value for '" + name2 + "(" + key2 + ")'");
        }
        if (!(prop instanceof Map)) {
            throw new IllegalArgumentException("Non-mapped property for '" + name2 + "(" + key2 + ")'");
        }
        Map map2 = (Map)prop;
        map2.put(key2, value);
    }

    protected DynaProperty getDynaProperty(String name2) {
        DynaProperty descriptor2 = this.getDynaClass().getDynaProperty(name2);
        if (descriptor2 == null) {
            throw new IllegalArgumentException("Invalid property name '" + name2 + "'");
        }
        return descriptor2;
    }

    protected boolean isAssignable(Class<?> dest, Class<?> source2) {
        return dest.isAssignableFrom(source2) || dest == Boolean.TYPE && source2 == Boolean.class || dest == Byte.TYPE && source2 == Byte.class || dest == Character.TYPE && source2 == Character.class || dest == Double.TYPE && source2 == Double.class || dest == Float.TYPE && source2 == Float.class || dest == Integer.TYPE && source2 == Integer.class || dest == Long.TYPE && source2 == Long.class || dest == Short.TYPE && source2 == Short.class;
    }
}

