/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.apache.catalina.Host;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class ExpandWar {
    private static final Log log = LogFactory.getLog(ExpandWar.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");

    public static String expand(Host host, URL war, String pathname) throws IOException {
        File warTrackerParent;
        JarURLConnection juc = (JarURLConnection)war.openConnection();
        juc.setUseCaches(false);
        URL jarFileUrl = juc.getJarFileURL();
        URLConnection jfuc = jarFileUrl.openConnection();
        boolean success = false;
        File docBase = new File(host.getAppBaseFile(), pathname);
        File warTracker = new File(host.getAppBaseFile(), pathname + "/META-INF/war-tracker");
        long warLastModified = -1L;
        try (InputStream is2 = jfuc.getInputStream();){
            warLastModified = jfuc.getLastModified();
        }
        if (docBase.exists()) {
            if (!warTracker.exists() || warTracker.lastModified() == warLastModified) {
                success = true;
                return docBase.getAbsolutePath();
            }
            log.info(sm.getString("expandWar.deleteOld", docBase));
            if (!ExpandWar.delete(docBase)) {
                throw new IOException(sm.getString("expandWar.deleteFailed", docBase));
            }
        }
        if (!docBase.mkdir() && !docBase.isDirectory()) {
            throw new IOException(sm.getString("expandWar.createFailed", docBase));
        }
        String canonicalDocBasePrefix = docBase.getCanonicalPath();
        if (!canonicalDocBasePrefix.endsWith(File.separator)) {
            canonicalDocBasePrefix = canonicalDocBasePrefix + File.separator;
        }
        if (!(warTrackerParent = warTracker.getParentFile()).isDirectory() && !warTrackerParent.mkdirs()) {
            throw new IOException(sm.getString("expandWar.createFailed", warTrackerParent.getAbsolutePath()));
        }
        try (JarFile jarFile = juc.getJarFile();){
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                File parent;
                JarEntry jarEntry = jarEntries.nextElement();
                String name2 = jarEntry.getName();
                File expandedFile = new File(docBase, name2);
                if (!expandedFile.getCanonicalPath().startsWith(canonicalDocBasePrefix)) {
                    throw new IllegalArgumentException(sm.getString("expandWar.illegalPath", war, name2, expandedFile.getCanonicalPath(), canonicalDocBasePrefix));
                }
                int last = name2.lastIndexOf(47);
                if (last >= 0 && !(parent = new File(docBase, name2.substring(0, last))).mkdirs() && !parent.isDirectory()) {
                    throw new IOException(sm.getString("expandWar.createFailed", parent));
                }
                if (name2.endsWith("/")) continue;
                InputStream input = jarFile.getInputStream(jarEntry);
                Throwable throwable = null;
                try {
                    if (null == input) {
                        throw new ZipException(sm.getString("expandWar.missingJarEntry", jarEntry.getName()));
                    }
                    ExpandWar.expand(input, expandedFile);
                    long lastModified = jarEntry.getTime();
                    if (lastModified == -1L || lastModified == 0L || expandedFile.setLastModified(lastModified)) continue;
                    throw new IOException(sm.getString("expandWar.lastModifiedFailed", expandedFile));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (input == null) continue;
                    if (throwable != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    input.close();
                }
            }
            if (!warTracker.createNewFile()) {
                throw new IOException(sm.getString("expandWar.createFileFailed", warTracker));
            }
            if (!warTracker.setLastModified(warLastModified)) {
                throw new IOException(sm.getString("expandWar.lastModifiedFailed", warTracker));
            }
            success = true;
        }
        catch (IOException e2) {
            throw e2;
        }
        finally {
            if (!success) {
                ExpandWar.deleteDir(docBase);
            }
        }
        return docBase.getAbsolutePath();
    }

    public static void validate(Host host, URL war, String pathname) throws IOException {
        File docBase = new File(host.getAppBaseFile(), pathname);
        String canonicalDocBasePrefix = docBase.getCanonicalPath();
        if (!canonicalDocBasePrefix.endsWith(File.separator)) {
            canonicalDocBasePrefix = canonicalDocBasePrefix + File.separator;
        }
        JarURLConnection juc = (JarURLConnection)war.openConnection();
        juc.setUseCaches(false);
        try (JarFile jarFile = juc.getJarFile();){
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                String name2 = jarEntry.getName();
                File expandedFile = new File(docBase, name2);
                if (expandedFile.getCanonicalPath().startsWith(canonicalDocBasePrefix)) continue;
                throw new IllegalArgumentException(sm.getString("expandWar.illegalPath", war, name2, expandedFile.getCanonicalPath(), canonicalDocBasePrefix));
            }
        }
    }

    public static boolean copy(File src, File dest) {
        boolean result = true;
        String[] files = null;
        if (src.isDirectory()) {
            files = src.list();
            result = dest.mkdir();
        } else {
            files = new String[]{""};
        }
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length && result; ++i) {
            File fileSrc = new File(src, files[i]);
            File fileDest = new File(dest, files[i]);
            if (fileSrc.isDirectory()) {
                result = ExpandWar.copy(fileSrc, fileDest);
                continue;
            }
            try (FileChannel ic = new FileInputStream(fileSrc).getChannel();
                 FileChannel oc = new FileOutputStream(fileDest).getChannel();){
                ic.transferTo(0L, ic.size(), oc);
                continue;
            }
            catch (IOException e2) {
                log.error(sm.getString("expandWar.copy", fileSrc, fileDest), e2);
                result = false;
            }
        }
        return result;
    }

    public static boolean delete(File dir2) {
        return ExpandWar.delete(dir2, true);
    }

    public static boolean delete(File dir2, boolean logFailure) {
        boolean result = dir2.isDirectory() ? ExpandWar.deleteDir(dir2, logFailure) : (dir2.exists() ? dir2.delete() : true);
        if (logFailure && !result) {
            log.error(sm.getString("expandWar.deleteFailed", dir2.getAbsolutePath()));
        }
        return result;
    }

    public static boolean deleteDir(File dir2) {
        return ExpandWar.deleteDir(dir2, true);
    }

    public static boolean deleteDir(File dir2, boolean logFailure) {
        String[] files = dir2.list();
        if (files == null) {
            files = new String[]{};
        }
        for (String s : files) {
            File file2 = new File(dir2, s);
            if (file2.isDirectory()) {
                ExpandWar.deleteDir(file2, logFailure);
                continue;
            }
            file2.delete();
        }
        boolean result = dir2.exists() ? dir2.delete() : true;
        if (logFailure && !result) {
            log.error(sm.getString("expandWar.deleteFailed", dir2.getAbsolutePath()));
        }
        return result;
    }

    private static void expand(InputStream input, File file2) throws IOException {
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file2));){
            int n;
            byte[] buffer = new byte[2048];
            while ((n = input.read(buffer)) > 0) {
                output.write(buffer, 0, n);
            }
        }
    }
}

