/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.manager.Constants;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.security.Escape;

public class StatusTransformer {
    public static void setContentType(HttpServletResponse response, int mode) {
        if (mode == 0) {
            response.setContentType("text/html;charset=utf-8");
        } else if (mode == 1) {
            response.setContentType("text/xml;charset=utf-8");
        }
    }

    public static void writeHeader(PrintWriter writer2, Object[] args, int mode) {
        if (mode == 0) {
            writer2.print(Constants.HTML_HEADER_SECTION);
        } else if (mode == 1) {
            writer2.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            writer2.print(MessageFormat.format("<?xml-stylesheet type=\"text/xsl\" href=\"{0}/xform.xsl\" ?>\n", args));
            writer2.write("<status>");
        }
    }

    public static void writeBody(PrintWriter writer2, Object[] args, int mode) {
        if (mode == 0) {
            writer2.print(MessageFormat.format(Constants.BODY_HEADER_SECTION, args));
        }
    }

    public static void writeManager(PrintWriter writer2, Object[] args, int mode) {
        if (mode == 0) {
            writer2.print(MessageFormat.format(Constants.MANAGER_SECTION, args));
        }
    }

    public static void writePageHeading(PrintWriter writer2, Object[] args, int mode) {
        if (mode == 0) {
            writer2.print(MessageFormat.format(Constants.SERVER_HEADER_SECTION, args));
        }
    }

    public static void writeServerInfo(PrintWriter writer2, Object[] args, int mode) {
        if (mode == 0) {
            writer2.print(MessageFormat.format(Constants.SERVER_ROW_SECTION, args));
        }
    }

    public static void writeFooter(PrintWriter writer2, int mode) {
        if (mode == 0) {
            writer2.print(Constants.HTML_TAIL_SECTION);
        } else if (mode == 1) {
            writer2.write("</status>");
        }
    }

    public static void writeOSState(PrintWriter writer2, int mode, Object[] args) {
        long[] result = new long[16];
        boolean ok = false;
        try {
            String methodName = "info";
            Class[] paramTypes = new Class[]{result.getClass()};
            Object[] paramValues = new Object[]{result};
            Method method = Class.forName("org.apache.tomcat.jni.OS").getMethod(methodName, paramTypes);
            method.invoke(null, paramValues);
            ok = true;
        }
        catch (Throwable t) {
            t = ExceptionUtils.unwrapInvocationTargetException(t);
            ExceptionUtils.handleThrowable(t);
        }
        if (ok) {
            if (mode == 0) {
                writer2.print("<h1>OS</h1>");
                writer2.print("<p>");
                writer2.print(args[0]);
                writer2.print(' ');
                writer2.print(StatusTransformer.formatSize(result[0], true));
                writer2.print(' ');
                writer2.print(args[1]);
                writer2.print(' ');
                writer2.print(StatusTransformer.formatSize(result[1], true));
                writer2.print(' ');
                writer2.print(args[2]);
                writer2.print(' ');
                writer2.print(StatusTransformer.formatSize(result[2], true));
                writer2.print(' ');
                writer2.print(args[3]);
                writer2.print(' ');
                writer2.print(StatusTransformer.formatSize(result[3], true));
                writer2.print(' ');
                writer2.print(args[4]);
                writer2.print(' ');
                writer2.print((Object)result[6]);
                writer2.print("<br>");
                writer2.print(args[5]);
                writer2.print(' ');
                writer2.print(StatusTransformer.formatTime(result[11] / 1000L, true));
                writer2.print(' ');
                writer2.print(args[6]);
                writer2.print(' ');
                writer2.print(StatusTransformer.formatTime(result[12] / 1000L, true));
                writer2.print("</p>");
            } else if (mode == 1) {
                // empty if block
            }
        }
    }

    public static void writeVMState(PrintWriter writer2, int mode, Object[] args) throws Exception {
        MemoryUsage usage;
        TreeMap<String, MemoryPoolMXBean> memoryPoolMBeans = new TreeMap<String, MemoryPoolMXBean>();
        for (MemoryPoolMXBean mbean : ManagementFactory.getMemoryPoolMXBeans()) {
            String sortKey = (Object)((Object)mbean.getType()) + ":" + mbean.getName();
            memoryPoolMBeans.put(sortKey, mbean);
        }
        if (mode == 0) {
            writer2.print("<h1>JVM</h1>");
            writer2.print("<p>");
            writer2.print(args[0]);
            writer2.print(' ');
            writer2.print(StatusTransformer.formatSize(Runtime.getRuntime().freeMemory(), true));
            writer2.print(' ');
            writer2.print(args[1]);
            writer2.print(' ');
            writer2.print(StatusTransformer.formatSize(Runtime.getRuntime().totalMemory(), true));
            writer2.print(' ');
            writer2.print(args[2]);
            writer2.print(' ');
            writer2.print(StatusTransformer.formatSize(Runtime.getRuntime().maxMemory(), true));
            writer2.print("</p>");
            writer2.write("<table border=\"0\"><thead><tr><th>" + args[3] + "</th><th>" + args[4] + "</th><th>" + args[5] + "</th><th>" + args[6] + "</th><th>" + args[7] + "</th><th>" + args[8] + "</th></tr></thead><tbody>");
            for (MemoryPoolMXBean memoryPoolMBean : memoryPoolMBeans.values()) {
                usage = memoryPoolMBean.getUsage();
                writer2.write("<tr><td>");
                writer2.print(memoryPoolMBean.getName());
                writer2.write("</td><td>");
                writer2.print((Object)memoryPoolMBean.getType());
                writer2.write("</td><td>");
                writer2.print(StatusTransformer.formatSize(usage.getInit(), true));
                writer2.write("</td><td>");
                writer2.print(StatusTransformer.formatSize(usage.getCommitted(), true));
                writer2.write("</td><td>");
                writer2.print(StatusTransformer.formatSize(usage.getMax(), true));
                writer2.write("</td><td>");
                writer2.print(StatusTransformer.formatSize(usage.getUsed(), true));
                if (usage.getMax() > 0L) {
                    writer2.write(" (" + usage.getUsed() * 100L / usage.getMax() + "%)");
                }
                writer2.write("</td></tr>");
            }
            writer2.write("</tbody></table>");
        } else if (mode == 1) {
            writer2.write("<jvm>");
            writer2.write("<memory");
            writer2.write(" free='" + Runtime.getRuntime().freeMemory() + "'");
            writer2.write(" total='" + Runtime.getRuntime().totalMemory() + "'");
            writer2.write(" max='" + Runtime.getRuntime().maxMemory() + "'/>");
            for (MemoryPoolMXBean memoryPoolMBean : memoryPoolMBeans.values()) {
                usage = memoryPoolMBean.getUsage();
                writer2.write("<memorypool");
                writer2.write(" name='" + Escape.xml("", memoryPoolMBean.getName()) + "'");
                writer2.write(" type='" + (Object)((Object)memoryPoolMBean.getType()) + "'");
                writer2.write(" usageInit='" + usage.getInit() + "'");
                writer2.write(" usageCommitted='" + usage.getCommitted() + "'");
                writer2.write(" usageMax='" + usage.getMax() + "'");
                writer2.write(" usageUsed='" + usage.getUsed() + "'/>");
            }
            writer2.write("</jvm>");
        }
    }

    public static void writeConnectorState(PrintWriter writer2, ObjectName tpName, String name2, MBeanServer mBeanServer, Vector<ObjectName> globalRequestProcessors, Vector<ObjectName> requestProcessors, int mode, Object[] args) throws Exception {
        if (mode == 0) {
            ObjectName objectName;
            writer2.print("<h1>");
            writer2.print(name2);
            writer2.print("</h1>");
            writer2.print("<p>");
            writer2.print(args[0]);
            writer2.print(' ');
            writer2.print(mBeanServer.getAttribute(tpName, "maxThreads"));
            writer2.print(' ');
            writer2.print(args[1]);
            writer2.print(' ');
            writer2.print(mBeanServer.getAttribute(tpName, "currentThreadCount"));
            writer2.print(' ');
            writer2.print(args[2]);
            writer2.print(' ');
            writer2.print(mBeanServer.getAttribute(tpName, "currentThreadsBusy"));
            writer2.print(' ');
            writer2.print(args[3]);
            writer2.print(' ');
            writer2.print(mBeanServer.getAttribute(tpName, "keepAliveCount"));
            writer2.print("<br>");
            ObjectName grpName = null;
            Enumeration<ObjectName> enumeration = globalRequestProcessors.elements();
            while (enumeration.hasMoreElements()) {
                objectName = enumeration.nextElement();
                if (!name2.equals(objectName.getKeyProperty("name"))) continue;
                grpName = objectName;
            }
            if (grpName == null) {
                return;
            }
            writer2.print(args[4]);
            writer2.print(' ');
            writer2.print(StatusTransformer.formatTime(mBeanServer.getAttribute(grpName, "maxTime"), false));
            writer2.print(' ');
            writer2.print(args[5]);
            writer2.print(' ');
            writer2.print(StatusTransformer.formatTime(mBeanServer.getAttribute(grpName, "processingTime"), true));
            writer2.print(' ');
            writer2.print(args[6]);
            writer2.print(' ');
            writer2.print(mBeanServer.getAttribute(grpName, "requestCount"));
            writer2.print(' ');
            writer2.print(args[7]);
            writer2.print(' ');
            writer2.print(mBeanServer.getAttribute(grpName, "errorCount"));
            writer2.print(' ');
            writer2.print(args[8]);
            writer2.print(' ');
            writer2.print(StatusTransformer.formatSize(mBeanServer.getAttribute(grpName, "bytesReceived"), true));
            writer2.print(' ');
            writer2.print(args[9]);
            writer2.print(' ');
            writer2.print(StatusTransformer.formatSize(mBeanServer.getAttribute(grpName, "bytesSent"), true));
            writer2.print("</p>");
            writer2.print("<table border=\"0\"><tr><th>" + args[10] + "</th><th>" + args[11] + "</th><th>" + args[12] + "</th><th>" + args[13] + "</th><th>" + args[14] + "</th><th>" + args[15] + "</th><th>" + args[16] + "</th><th>" + args[17] + "</th></tr>");
            enumeration = requestProcessors.elements();
            while (enumeration.hasMoreElements()) {
                objectName = enumeration.nextElement();
                if (!name2.equals(objectName.getKeyProperty("worker"))) continue;
                writer2.print("<tr>");
                StatusTransformer.writeProcessorState(writer2, objectName, mBeanServer, mode);
                writer2.print("</tr>");
            }
            writer2.print("</table>");
            writer2.print("<p>");
            writer2.print(args[18]);
            writer2.print("</p>");
        } else if (mode == 1) {
            ObjectName objectName;
            writer2.write("<connector name='" + name2 + "'>");
            writer2.write("<threadInfo ");
            writer2.write(" maxThreads=\"" + mBeanServer.getAttribute(tpName, "maxThreads") + "\"");
            writer2.write(" currentThreadCount=\"" + mBeanServer.getAttribute(tpName, "currentThreadCount") + "\"");
            writer2.write(" currentThreadsBusy=\"" + mBeanServer.getAttribute(tpName, "currentThreadsBusy") + "\"");
            writer2.write(" />");
            ObjectName grpName = null;
            Enumeration<ObjectName> enumeration = globalRequestProcessors.elements();
            while (enumeration.hasMoreElements()) {
                objectName = enumeration.nextElement();
                if (!name2.equals(objectName.getKeyProperty("name"))) continue;
                grpName = objectName;
            }
            if (grpName != null) {
                writer2.write("<requestInfo ");
                writer2.write(" maxTime=\"" + mBeanServer.getAttribute(grpName, "maxTime") + "\"");
                writer2.write(" processingTime=\"" + mBeanServer.getAttribute(grpName, "processingTime") + "\"");
                writer2.write(" requestCount=\"" + mBeanServer.getAttribute(grpName, "requestCount") + "\"");
                writer2.write(" errorCount=\"" + mBeanServer.getAttribute(grpName, "errorCount") + "\"");
                writer2.write(" bytesReceived=\"" + mBeanServer.getAttribute(grpName, "bytesReceived") + "\"");
                writer2.write(" bytesSent=\"" + mBeanServer.getAttribute(grpName, "bytesSent") + "\"");
                writer2.write(" />");
                writer2.write("<workers>");
                enumeration = requestProcessors.elements();
                while (enumeration.hasMoreElements()) {
                    objectName = enumeration.nextElement();
                    if (!name2.equals(objectName.getKeyProperty("worker"))) continue;
                    StatusTransformer.writeProcessorState(writer2, objectName, mBeanServer, mode);
                }
                writer2.write("</workers>");
            }
            writer2.write("</connector>");
        }
    }

    protected static void writeProcessorState(PrintWriter writer2, ObjectName pName, MBeanServer mBeanServer, int mode) throws Exception {
        Integer stageValue = (Integer)mBeanServer.getAttribute(pName, "stage");
        int stage = stageValue;
        boolean fullStatus = true;
        boolean showRequest = true;
        String stageStr = null;
        switch (stage) {
            case 1: {
                stageStr = "P";
                fullStatus = false;
                break;
            }
            case 2: {
                stageStr = "P";
                fullStatus = false;
                break;
            }
            case 3: {
                stageStr = "S";
                break;
            }
            case 4: {
                stageStr = "F";
                break;
            }
            case 5: {
                stageStr = "F";
                break;
            }
            case 7: {
                stageStr = "R";
                fullStatus = false;
                break;
            }
            case 6: {
                stageStr = "K";
                fullStatus = true;
                showRequest = false;
                break;
            }
            case 0: {
                stageStr = "R";
                fullStatus = false;
                break;
            }
            default: {
                stageStr = "?";
                fullStatus = false;
            }
        }
        if (mode == 0) {
            writer2.write("<td><strong>");
            writer2.write(stageStr);
            writer2.write("</strong></td>");
            if (fullStatus) {
                writer2.write("<td>");
                writer2.print(StatusTransformer.formatTime(mBeanServer.getAttribute(pName, "requestProcessingTime"), false));
                writer2.write("</td>");
                writer2.write("<td>");
                if (showRequest) {
                    writer2.print(StatusTransformer.formatSize(mBeanServer.getAttribute(pName, "requestBytesSent"), false));
                } else {
                    writer2.write("?");
                }
                writer2.write("</td>");
                writer2.write("<td>");
                if (showRequest) {
                    writer2.print(StatusTransformer.formatSize(mBeanServer.getAttribute(pName, "requestBytesReceived"), false));
                } else {
                    writer2.write("?");
                }
                writer2.write("</td>");
                writer2.write("<td>");
                writer2.print(Escape.htmlElementContent(mBeanServer.getAttribute(pName, "remoteAddrForwarded")));
                writer2.write("</td>");
                writer2.write("<td>");
                writer2.print(Escape.htmlElementContent(mBeanServer.getAttribute(pName, "remoteAddr")));
                writer2.write("</td>");
                writer2.write("<td nowrap>");
                writer2.write(Escape.htmlElementContent(mBeanServer.getAttribute(pName, "virtualHost")));
                writer2.write("</td>");
                writer2.write("<td nowrap class=\"row-left\">");
                if (showRequest) {
                    writer2.write(Escape.htmlElementContent(mBeanServer.getAttribute(pName, "method")));
                    writer2.write(32);
                    writer2.write(Escape.htmlElementContent(mBeanServer.getAttribute(pName, "currentUri")));
                    String queryString = (String)mBeanServer.getAttribute(pName, "currentQueryString");
                    if (queryString != null && !queryString.equals("")) {
                        writer2.write("?");
                        writer2.print(Escape.htmlElementContent(queryString));
                    }
                    writer2.write(32);
                    writer2.write(Escape.htmlElementContent(mBeanServer.getAttribute(pName, "protocol")));
                } else {
                    writer2.write("?");
                }
                writer2.write("</td>");
            } else {
                writer2.write("<td>?</td><td>?</td><td>?</td><td>?</td><td>?</td><td>?</td>");
            }
        } else if (mode == 1) {
            writer2.write("<worker ");
            writer2.write(" stage=\"" + stageStr + "\"");
            if (fullStatus) {
                writer2.write(" requestProcessingTime=\"" + mBeanServer.getAttribute(pName, "requestProcessingTime") + "\"");
                writer2.write(" requestBytesSent=\"");
                if (showRequest) {
                    writer2.write("" + mBeanServer.getAttribute(pName, "requestBytesSent"));
                } else {
                    writer2.write("0");
                }
                writer2.write("\"");
                writer2.write(" requestBytesReceived=\"");
                if (showRequest) {
                    writer2.write("" + mBeanServer.getAttribute(pName, "requestBytesReceived"));
                } else {
                    writer2.write("0");
                }
                writer2.write("\"");
                writer2.write(" remoteAddr=\"" + Escape.htmlElementContent(mBeanServer.getAttribute(pName, "remoteAddr")) + "\"");
                writer2.write(" virtualHost=\"" + Escape.htmlElementContent(mBeanServer.getAttribute(pName, "virtualHost")) + "\"");
                if (showRequest) {
                    writer2.write(" method=\"" + Escape.htmlElementContent(mBeanServer.getAttribute(pName, "method")) + "\"");
                    writer2.write(" currentUri=\"" + Escape.htmlElementContent(mBeanServer.getAttribute(pName, "currentUri")) + "\"");
                    String queryString = (String)mBeanServer.getAttribute(pName, "currentQueryString");
                    if (queryString != null && !queryString.equals("")) {
                        writer2.write(" currentQueryString=\"" + Escape.htmlElementContent(queryString) + "\"");
                    } else {
                        writer2.write(" currentQueryString=\"&#63;\"");
                    }
                    writer2.write(" protocol=\"" + Escape.htmlElementContent(mBeanServer.getAttribute(pName, "protocol")) + "\"");
                } else {
                    writer2.write(" method=\"&#63;\"");
                    writer2.write(" currentUri=\"&#63;\"");
                    writer2.write(" currentQueryString=\"&#63;\"");
                    writer2.write(" protocol=\"&#63;\"");
                }
            } else {
                writer2.write(" requestProcessingTime=\"0\"");
                writer2.write(" requestBytesSent=\"0\"");
                writer2.write(" requestBytesReceived=\"0\"");
                writer2.write(" remoteAddr=\"&#63;\"");
                writer2.write(" virtualHost=\"&#63;\"");
                writer2.write(" method=\"&#63;\"");
                writer2.write(" currentUri=\"&#63;\"");
                writer2.write(" currentQueryString=\"&#63;\"");
                writer2.write(" protocol=\"&#63;\"");
            }
            writer2.write(" />");
        }
    }

    public static void writeDetailedState(PrintWriter writer2, MBeanServer mBeanServer, int mode) throws Exception {
        if (mode == 0) {
            ObjectName queryHosts = new ObjectName("*:j2eeType=WebModule,*");
            Set<ObjectName> hostsON = mBeanServer.queryNames(queryHosts, null);
            writer2.print("<h1>");
            writer2.print("Application list");
            writer2.print("</h1>");
            writer2.print("<p>");
            int count2 = 0;
            Iterator<ObjectName> iterator = hostsON.iterator();
            while (iterator.hasNext()) {
                int slash;
                ObjectName contextON = iterator.next();
                String webModuleName = contextON.getKeyProperty("name");
                if (webModuleName.startsWith("//")) {
                    webModuleName = webModuleName.substring(2);
                }
                if ((slash = webModuleName.indexOf(47)) == -1) {
                    ++count2;
                    continue;
                }
                writer2.print("<a href=\"#" + count2++ + ".0\">");
                writer2.print(Escape.htmlElementContent(webModuleName));
                writer2.print("</a>");
                if (!iterator.hasNext()) continue;
                writer2.print("<br>");
            }
            writer2.print("</p>");
            count2 = 0;
            for (ObjectName contextON : hostsON) {
                writer2.print("<a class=\"A.name\" name=\"" + count2++ + ".0\">");
                StatusTransformer.writeContext(writer2, contextON, mBeanServer, mode);
            }
        } else if (mode == 1) {
            // empty if block
        }
    }

    protected static void writeContext(PrintWriter writer2, ObjectName objectName, MBeanServer mBeanServer, int mode) throws Exception {
        if (mode == 0) {
            int slash;
            String webModuleName = objectName.getKeyProperty("name");
            String name2 = webModuleName;
            if (name2 == null) {
                return;
            }
            String hostName = null;
            String contextName = null;
            if (name2.startsWith("//")) {
                name2 = name2.substring(2);
            }
            if ((slash = name2.indexOf(47)) == -1) {
                return;
            }
            hostName = name2.substring(0, slash);
            contextName = name2.substring(slash);
            ObjectName queryManager = new ObjectName(objectName.getDomain() + ":type=Manager,context=" + contextName + ",host=" + hostName + ",*");
            Set<ObjectName> managersON = mBeanServer.queryNames(queryManager, null);
            ObjectName managerON = null;
            Iterator<ObjectName> iterator = managersON.iterator();
            while (iterator.hasNext()) {
                ObjectName aManagersON;
                managerON = aManagersON = iterator.next();
            }
            ObjectName queryJspMonitor = new ObjectName(objectName.getDomain() + ":type=JspMonitor,WebModule=" + webModuleName + ",*");
            Set<ObjectName> jspMonitorONs = mBeanServer.queryNames(queryJspMonitor, null);
            if (contextName.equals("/")) {
                contextName = "";
            }
            writer2.print("<h1>");
            writer2.print(Escape.htmlElementContent(name2));
            writer2.print("</h1>");
            writer2.print("</a>");
            writer2.print("<p>");
            Object startTime = mBeanServer.getAttribute(objectName, "startTime");
            writer2.print(" Start time: " + new Date((Long)startTime));
            writer2.print(" Startup time: ");
            writer2.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "startupTime"), false));
            writer2.print(" TLD scan time: ");
            writer2.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "tldScanTime"), false));
            if (managerON != null) {
                StatusTransformer.writeManager(writer2, managerON, mBeanServer, mode);
            }
            if (jspMonitorONs != null) {
                StatusTransformer.writeJspMonitor(writer2, jspMonitorONs, mBeanServer, mode);
            }
            writer2.print("</p>");
            String onStr = objectName.getDomain() + ":j2eeType=Servlet,WebModule=" + webModuleName + ",*";
            ObjectName servletObjectName = new ObjectName(onStr);
            Set<ObjectInstance> set2 = mBeanServer.queryMBeans(servletObjectName, null);
            for (ObjectInstance oi : set2) {
                StatusTransformer.writeWrapper(writer2, oi.getObjectName(), mBeanServer, mode);
            }
        } else if (mode == 1) {
            // empty if block
        }
    }

    public static void writeManager(PrintWriter writer2, ObjectName objectName, MBeanServer mBeanServer, int mode) throws Exception {
        if (mode == 0) {
            writer2.print("<br>");
            writer2.print(" Active sessions: ");
            writer2.print(mBeanServer.getAttribute(objectName, "activeSessions"));
            writer2.print(" Session count: ");
            writer2.print(mBeanServer.getAttribute(objectName, "sessionCounter"));
            writer2.print(" Max active sessions: ");
            writer2.print(mBeanServer.getAttribute(objectName, "maxActive"));
            writer2.print(" Rejected session creations: ");
            writer2.print(mBeanServer.getAttribute(objectName, "rejectedSessions"));
            writer2.print(" Expired sessions: ");
            writer2.print(mBeanServer.getAttribute(objectName, "expiredSessions"));
            writer2.print(" Longest session alive time: ");
            writer2.print(StatusTransformer.formatSeconds(mBeanServer.getAttribute(objectName, "sessionMaxAliveTime")));
            writer2.print(" Average session alive time: ");
            writer2.print(StatusTransformer.formatSeconds(mBeanServer.getAttribute(objectName, "sessionAverageAliveTime")));
            writer2.print(" Processing time: ");
            writer2.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "processingTime"), false));
        } else if (mode == 1) {
            // empty if block
        }
    }

    public static void writeJspMonitor(PrintWriter writer2, Set<ObjectName> jspMonitorONs, MBeanServer mBeanServer, int mode) throws Exception {
        int jspCount = 0;
        int jspReloadCount = 0;
        for (ObjectName jspMonitorON : jspMonitorONs) {
            Object obj = mBeanServer.getAttribute(jspMonitorON, "jspCount");
            jspCount += ((Integer)obj).intValue();
            obj = mBeanServer.getAttribute(jspMonitorON, "jspReloadCount");
            jspReloadCount += ((Integer)obj).intValue();
        }
        if (mode == 0) {
            writer2.print("<br>");
            writer2.print(" JSPs loaded: ");
            writer2.print(jspCount);
            writer2.print(" JSPs reloaded: ");
            writer2.print(jspReloadCount);
        } else if (mode == 1) {
            // empty if block
        }
    }

    public static void writeWrapper(PrintWriter writer2, ObjectName objectName, MBeanServer mBeanServer, int mode) throws Exception {
        if (mode == 0) {
            String servletName = objectName.getKeyProperty("name");
            String[] mappings = (String[])mBeanServer.invoke(objectName, "findMappings", null, null);
            writer2.print("<h2>");
            writer2.print(Escape.htmlElementContent(servletName));
            if (mappings != null && mappings.length > 0) {
                writer2.print(" [ ");
                for (int i = 0; i < mappings.length; ++i) {
                    writer2.print(Escape.htmlElementContent(mappings[i]));
                    if (i >= mappings.length - 1) continue;
                    writer2.print(" , ");
                }
                writer2.print(" ] ");
            }
            writer2.print("</h2>");
            writer2.print("<p>");
            writer2.print(" Processing time: ");
            writer2.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "processingTime"), true));
            writer2.print(" Max time: ");
            writer2.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "maxTime"), false));
            writer2.print(" Request count: ");
            writer2.print(mBeanServer.getAttribute(objectName, "requestCount"));
            writer2.print(" Error count: ");
            writer2.print(mBeanServer.getAttribute(objectName, "errorCount"));
            writer2.print(" Load time: ");
            writer2.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "loadTime"), false));
            writer2.print(" Classloading time: ");
            writer2.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "classLoadTime"), false));
            writer2.print("</p>");
        } else if (mode == 1) {
            // empty if block
        }
    }

    public static String formatSize(Object obj, boolean mb) {
        long bytes2 = -1L;
        if (obj instanceof Long) {
            bytes2 = (Long)obj;
        } else if (obj instanceof Integer) {
            bytes2 = ((Integer)obj).intValue();
        }
        if (mb) {
            StringBuilder buff = new StringBuilder();
            if (bytes2 < 0L) {
                buff.append('-');
                bytes2 = -bytes2;
            }
            long mbytes = bytes2 / 0x100000L;
            long rest = (bytes2 - mbytes * 0x100000L) * 100L / 0x100000L;
            buff.append(mbytes).append('.');
            if (rest < 10L) {
                buff.append('0');
            }
            buff.append(rest).append(" MB");
            return buff.toString();
        }
        return bytes2 / 1024L + " KB";
    }

    public static String formatTime(Object obj, boolean seconds) {
        long time2 = -1L;
        if (obj instanceof Long) {
            time2 = (Long)obj;
        } else if (obj instanceof Integer) {
            time2 = ((Integer)obj).intValue();
        }
        if (seconds) {
            return (float)time2 / 1000.0f + " s";
        }
        return time2 + " ms";
    }

    public static String formatSeconds(Object obj) {
        long time2 = -1L;
        if (obj instanceof Long) {
            time2 = (Long)obj;
        } else if (obj instanceof Integer) {
            time2 = ((Integer)obj).intValue();
        }
        return time2 + " s";
    }
}

