/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.mbeans.MBeanDumper;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.tomcat.util.modeler.Registry;

public class JMXProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String[] NO_PARAMETERS = new String[0];
    private static final StringManager sm = StringManager.getManager(JMXProxyServlet.class);
    protected transient MBeanServer mBeanServer = null;
    protected transient Registry registry;

    @Override
    public void init() throws ServletException {
        this.registry = Registry.getRegistry(null, null);
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/plain;charset=utf-8");
        response.setHeader("X-Content-Type-Options", "nosniff");
        PrintWriter writer2 = response.getWriter();
        if (this.mBeanServer == null) {
            writer2.println("Error - No mbean server");
            return;
        }
        String qry = request.getParameter("set");
        if (qry != null) {
            String name2 = request.getParameter("att");
            String val2 = request.getParameter("val");
            this.setAttribute(writer2, qry, name2, val2);
            return;
        }
        qry = request.getParameter("get");
        if (qry != null) {
            String name3 = request.getParameter("att");
            this.getAttribute(writer2, qry, name3, request.getParameter("key"));
            return;
        }
        qry = request.getParameter("invoke");
        if (qry != null) {
            String opName = request.getParameter("op");
            String[] params = this.getInvokeParameters(request.getParameter("ps"));
            this.invokeOperation(writer2, qry, opName, params);
            return;
        }
        qry = request.getParameter("qry");
        if (qry == null) {
            qry = "*:*";
        }
        this.listBeans(writer2, qry);
    }

    public void getAttribute(PrintWriter writer2, String onameStr, String att, String key2) {
        try {
            ObjectName oname = new ObjectName(onameStr);
            Object value = this.mBeanServer.getAttribute(oname, att);
            if (null != key2 && value instanceof CompositeData) {
                value = ((CompositeData)value).get(key2);
            }
            String valueStr = value != null ? value.toString() : "<null>";
            writer2.print("OK - Attribute get '");
            writer2.print(onameStr);
            writer2.print("' - ");
            writer2.print(att);
            if (null != key2) {
                writer2.print(" - key '");
                writer2.print(key2);
                writer2.print("'");
            }
            writer2.print(" = ");
            writer2.println(MBeanDumper.escape(valueStr));
        }
        catch (Exception ex) {
            writer2.println("Error - " + ex.toString());
            ex.printStackTrace(writer2);
        }
    }

    public void setAttribute(PrintWriter writer2, String onameStr, String att, String val2) {
        try {
            this.setAttributeInternal(onameStr, att, val2);
            writer2.println("OK - Attribute set");
        }
        catch (Exception ex) {
            writer2.println("Error - " + ex.toString());
            ex.printStackTrace(writer2);
        }
    }

    public void listBeans(PrintWriter writer2, String qry) {
        Set<ObjectName> names = null;
        try {
            names = this.mBeanServer.queryNames(new ObjectName(qry), null);
            writer2.println("OK - Number of results: " + names.size());
            writer2.println();
        }
        catch (Exception ex) {
            writer2.println("Error - " + ex.toString());
            ex.printStackTrace(writer2);
            return;
        }
        String dump = MBeanDumper.dumpBeans(this.mBeanServer, names);
        writer2.print(dump);
    }

    public boolean isSupported(String type2) {
        return true;
    }

    private void invokeOperation(PrintWriter writer2, String onameStr, String op, String[] valuesStr) {
        try {
            Object retVal = this.invokeOperationInternal(onameStr, op, valuesStr);
            if (retVal != null) {
                writer2.println("OK - Operation " + op + " returned:");
                this.output("", writer2, retVal);
            } else {
                writer2.println("OK - Operation " + op + " without return value");
            }
        }
        catch (Exception ex) {
            writer2.println("Error - " + ex.toString());
            ex.printStackTrace(writer2);
        }
    }

    private String[] getInvokeParameters(String paramString) {
        if (paramString == null) {
            return NO_PARAMETERS;
        }
        return paramString.split(",");
    }

    private void setAttributeInternal(String onameStr, String attributeName, String value) throws OperationsException, MBeanException, ReflectionException {
        ObjectName oname = new ObjectName(onameStr);
        String type2 = this.registry.getType(oname, attributeName);
        Object valueObj = this.registry.convertValue(type2, value);
        this.mBeanServer.setAttribute(oname, new Attribute(attributeName, valueObj));
    }

    private Object invokeOperationInternal(String onameStr, String operation, String[] parameters) throws OperationsException, MBeanException, ReflectionException {
        ObjectName oname = new ObjectName(onameStr);
        int paramCount = null == parameters ? 0 : parameters.length;
        MBeanOperationInfo methodInfo = this.registry.getMethodInfo(oname, operation, paramCount);
        if (null == methodInfo) {
            MBeanInfo info = null;
            try {
                info = this.registry.getMBeanServer().getMBeanInfo(oname);
            }
            catch (InstanceNotFoundException infe) {
                throw infe;
            }
            catch (Exception e2) {
                throw new IllegalArgumentException(sm.getString("jmxProxyServlet.noBeanFound", new Object[]{onameStr}), e2);
            }
            throw new IllegalArgumentException(sm.getString("jmxProxyServlet.noOperationOnBean", new Object[]{operation, paramCount, onameStr, info.getClassName()}));
        }
        MBeanParameterInfo[] signature = methodInfo.getSignature();
        String[] signatureTypes = new String[signature.length];
        Object[] values = new Object[signature.length];
        for (int i = 0; i < signature.length; ++i) {
            MBeanParameterInfo pi = signature[i];
            signatureTypes[i] = pi.getType();
            values[i] = this.registry.convertValue(pi.getType(), parameters[i]);
        }
        return this.mBeanServer.invoke(oname, operation, values, signatureTypes);
    }

    private void output(String indent2, PrintWriter writer2, Object result) {
        if (result instanceof Object[]) {
            for (Object obj : (Object[])result) {
                this.output("  " + indent2, writer2, obj);
            }
        } else {
            String strValue = result != null ? result.toString() : "<null>";
            writer2.println(indent2 + strValue);
        }
    }
}

