/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.deploy;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.JmxEnabled;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.util.Introspection;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.ContextBindings;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.descriptor.web.ContextEjb;
import org.apache.tomcat.util.descriptor.web.ContextEnvironment;
import org.apache.tomcat.util.descriptor.web.ContextLocalEjb;
import org.apache.tomcat.util.descriptor.web.ContextResource;
import org.apache.tomcat.util.descriptor.web.ContextResourceEnvRef;
import org.apache.tomcat.util.descriptor.web.ContextResourceLink;
import org.apache.tomcat.util.descriptor.web.ContextService;
import org.apache.tomcat.util.descriptor.web.ContextTransaction;
import org.apache.tomcat.util.descriptor.web.InjectionTarget;
import org.apache.tomcat.util.descriptor.web.MessageDestinationRef;
import org.apache.tomcat.util.descriptor.web.NamingResources;
import org.apache.tomcat.util.descriptor.web.ResourceBase;
import org.apache.tomcat.util.res.StringManager;

public class NamingResourcesImpl
extends LifecycleMBeanBase
implements Serializable,
NamingResources {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(NamingResourcesImpl.class);
    private static final StringManager sm = StringManager.getManager(NamingResourcesImpl.class);
    private volatile boolean resourceRequireExplicitRegistration = false;
    private Object container = null;
    private final Set<String> entries = new HashSet<String>();
    private final Map<String, ContextEjb> ejbs = new HashMap<String, ContextEjb>();
    private final Map<String, ContextEnvironment> envs = new HashMap<String, ContextEnvironment>();
    private final Map<String, ContextLocalEjb> localEjbs = new HashMap<String, ContextLocalEjb>();
    private final Map<String, MessageDestinationRef> mdrs = new HashMap<String, MessageDestinationRef>();
    private final HashMap<String, ContextResourceEnvRef> resourceEnvRefs = new HashMap();
    private final HashMap<String, ContextResource> resources = new HashMap();
    private final HashMap<String, ContextResourceLink> resourceLinks = new HashMap();
    private final HashMap<String, ContextService> services = new HashMap();
    private ContextTransaction transaction = null;
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);

    @Override
    public Object getContainer() {
        return this.container;
    }

    public void setContainer(Object container) {
        this.container = container;
    }

    public void setTransaction(ContextTransaction transaction) {
        this.transaction = transaction;
    }

    public ContextTransaction getTransaction() {
        return this.transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEjb(ContextEjb ejb) {
        String ejbLink = ejb.getLink();
        String lookupName = ejb.getLookupName();
        if (ejbLink != null && ejbLink.length() > 0 && lookupName != null && lookupName.length() > 0) {
            throw new IllegalArgumentException(sm.getString("namingResources.ejbLookupLink", ejb.getName()));
        }
        if (this.entries.contains(ejb.getName())) {
            return;
        }
        this.entries.add(ejb.getName());
        Map<String, ContextEjb> map2 = this.ejbs;
        synchronized (map2) {
            ejb.setNamingResources(this);
            this.ejbs.put(ejb.getName(), ejb);
        }
        this.support.firePropertyChange("ejb", null, ejb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addEnvironment(ContextEnvironment environment) {
        if (this.entries.contains(environment.getName())) {
            ContextEnvironment ce = this.findEnvironment(environment.getName());
            ContextResourceLink rl = this.findResourceLink(environment.getName());
            if (ce != null) {
                if (!ce.getOverride()) return;
                this.removeEnvironment(environment.getName());
            } else {
                if (rl == null) return;
                NamingResourcesImpl global = this.getServer().getGlobalNamingResources();
                if (global.findEnvironment(rl.getGlobal()) != null) {
                    if (!global.findEnvironment(rl.getGlobal()).getOverride()) return;
                    this.removeResourceLink(environment.getName());
                }
            }
        }
        List<InjectionTarget> injectionTargets = environment.getInjectionTargets();
        String value = environment.getValue();
        String lookupName = environment.getLookupName();
        if (injectionTargets != null && injectionTargets.size() > 0 && (value == null || value.length() == 0)) {
            return;
        }
        if (value != null && value.length() > 0 && lookupName != null && lookupName.length() > 0) {
            throw new IllegalArgumentException(sm.getString("namingResources.envEntryLookupValue", environment.getName()));
        }
        if (!this.checkResourceType(environment)) {
            throw new IllegalArgumentException(sm.getString("namingResources.resourceTypeFail", environment.getName(), environment.getType()));
        }
        this.entries.add(environment.getName());
        Map<String, ContextEnvironment> map2 = this.envs;
        synchronized (map2) {
            environment.setNamingResources(this);
            this.envs.put(environment.getName(), environment);
        }
        this.support.firePropertyChange("environment", null, environment);
        if (!this.resourceRequireExplicitRegistration) return;
        try {
            MBeanUtils.createMBean(environment);
            return;
        }
        catch (Exception e2) {
            log.warn(sm.getString("namingResources.mbeanCreateFail", environment.getName()), e2);
        }
    }

    private Server getServer() {
        if (this.container instanceof Server) {
            return (Server)this.container;
        }
        if (this.container instanceof Context) {
            Engine engine = (Engine)((Context)this.container).getParent().getParent();
            return engine.getService().getServer();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalEjb(ContextLocalEjb ejb) {
        if (this.entries.contains(ejb.getName())) {
            return;
        }
        this.entries.add(ejb.getName());
        Map<String, ContextLocalEjb> map2 = this.localEjbs;
        synchronized (map2) {
            ejb.setNamingResources(this);
            this.localEjbs.put(ejb.getName(), ejb);
        }
        this.support.firePropertyChange("localEjb", null, ejb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageDestinationRef(MessageDestinationRef mdr) {
        if (this.entries.contains(mdr.getName())) {
            return;
        }
        if (!this.checkResourceType(mdr)) {
            throw new IllegalArgumentException(sm.getString("namingResources.resourceTypeFail", mdr.getName(), mdr.getType()));
        }
        this.entries.add(mdr.getName());
        Map<String, MessageDestinationRef> map2 = this.mdrs;
        synchronized (map2) {
            mdr.setNamingResources(this);
            this.mdrs.put(mdr.getName(), mdr);
        }
        this.support.firePropertyChange("messageDestinationRef", null, mdr);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResource(ContextResource resource2) {
        if (this.entries.contains(resource2.getName())) {
            return;
        }
        if (!this.checkResourceType(resource2)) {
            throw new IllegalArgumentException(sm.getString("namingResources.resourceTypeFail", resource2.getName(), resource2.getType()));
        }
        this.entries.add(resource2.getName());
        HashMap<String, ContextResource> hashMap = this.resources;
        synchronized (hashMap) {
            resource2.setNamingResources(this);
            this.resources.put(resource2.getName(), resource2);
        }
        this.support.firePropertyChange("resource", null, resource2);
        if (this.resourceRequireExplicitRegistration) {
            try {
                MBeanUtils.createMBean(resource2);
            }
            catch (Exception e2) {
                log.warn(sm.getString("namingResources.mbeanCreateFail", resource2.getName()), e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceEnvRef(ContextResourceEnvRef resource2) {
        if (this.entries.contains(resource2.getName())) {
            return;
        }
        if (!this.checkResourceType(resource2)) {
            throw new IllegalArgumentException(sm.getString("namingResources.resourceTypeFail", resource2.getName(), resource2.getType()));
        }
        this.entries.add(resource2.getName());
        HashMap<String, ContextResourceEnvRef> hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            resource2.setNamingResources(this);
            this.resourceEnvRefs.put(resource2.getName(), resource2);
        }
        this.support.firePropertyChange("resourceEnvRef", null, resource2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResourceLink(ContextResourceLink resourceLink) {
        if (this.entries.contains(resourceLink.getName())) {
            return;
        }
        this.entries.add(resourceLink.getName());
        HashMap<String, ContextResourceLink> hashMap = this.resourceLinks;
        synchronized (hashMap) {
            resourceLink.setNamingResources(this);
            this.resourceLinks.put(resourceLink.getName(), resourceLink);
        }
        this.support.firePropertyChange("resourceLink", null, resourceLink);
        if (this.resourceRequireExplicitRegistration) {
            try {
                MBeanUtils.createMBean(resourceLink);
            }
            catch (Exception e2) {
                log.warn(sm.getString("namingResources.mbeanCreateFail", resourceLink.getName()), e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addService(ContextService service) {
        if (this.entries.contains(service.getName())) {
            return;
        }
        this.entries.add(service.getName());
        HashMap<String, ContextService> hashMap = this.services;
        synchronized (hashMap) {
            service.setNamingResources(this);
            this.services.put(service.getName(), service);
        }
        this.support.firePropertyChange("service", null, service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEjb findEjb(String name2) {
        Map<String, ContextEjb> map2 = this.ejbs;
        synchronized (map2) {
            return this.ejbs.get(name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEjb[] findEjbs() {
        Map<String, ContextEjb> map2 = this.ejbs;
        synchronized (map2) {
            ContextEjb[] results = new ContextEjb[this.ejbs.size()];
            return this.ejbs.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEnvironment findEnvironment(String name2) {
        Map<String, ContextEnvironment> map2 = this.envs;
        synchronized (map2) {
            return this.envs.get(name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEnvironment[] findEnvironments() {
        Map<String, ContextEnvironment> map2 = this.envs;
        synchronized (map2) {
            ContextEnvironment[] results = new ContextEnvironment[this.envs.size()];
            return this.envs.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextLocalEjb findLocalEjb(String name2) {
        Map<String, ContextLocalEjb> map2 = this.localEjbs;
        synchronized (map2) {
            return this.localEjbs.get(name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextLocalEjb[] findLocalEjbs() {
        Map<String, ContextLocalEjb> map2 = this.localEjbs;
        synchronized (map2) {
            ContextLocalEjb[] results = new ContextLocalEjb[this.localEjbs.size()];
            return this.localEjbs.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDestinationRef findMessageDestinationRef(String name2) {
        Map<String, MessageDestinationRef> map2 = this.mdrs;
        synchronized (map2) {
            return this.mdrs.get(name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDestinationRef[] findMessageDestinationRefs() {
        Map<String, MessageDestinationRef> map2 = this.mdrs;
        synchronized (map2) {
            MessageDestinationRef[] results = new MessageDestinationRef[this.mdrs.size()];
            return this.mdrs.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResource findResource(String name2) {
        HashMap<String, ContextResource> hashMap = this.resources;
        synchronized (hashMap) {
            return this.resources.get(name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResourceLink findResourceLink(String name2) {
        HashMap<String, ContextResourceLink> hashMap = this.resourceLinks;
        synchronized (hashMap) {
            return this.resourceLinks.get(name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResourceLink[] findResourceLinks() {
        HashMap<String, ContextResourceLink> hashMap = this.resourceLinks;
        synchronized (hashMap) {
            ContextResourceLink[] results = new ContextResourceLink[this.resourceLinks.size()];
            return this.resourceLinks.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResource[] findResources() {
        HashMap<String, ContextResource> hashMap = this.resources;
        synchronized (hashMap) {
            ContextResource[] results = new ContextResource[this.resources.size()];
            return this.resources.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResourceEnvRef findResourceEnvRef(String name2) {
        HashMap<String, ContextResourceEnvRef> hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            return this.resourceEnvRefs.get(name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResourceEnvRef[] findResourceEnvRefs() {
        HashMap<String, ContextResourceEnvRef> hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            ContextResourceEnvRef[] results = new ContextResourceEnvRef[this.resourceEnvRefs.size()];
            return this.resourceEnvRefs.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextService findService(String name2) {
        HashMap<String, ContextService> hashMap = this.services;
        synchronized (hashMap) {
            return this.services.get(name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextService[] findServices() {
        HashMap<String, ContextService> hashMap = this.services;
        synchronized (hashMap) {
            ContextService[] results = new ContextService[this.services.size()];
            return this.services.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEjb(String name2) {
        this.entries.remove(name2);
        ContextEjb ejb = null;
        Map<String, ContextEjb> map2 = this.ejbs;
        synchronized (map2) {
            ejb = this.ejbs.remove(name2);
        }
        if (ejb != null) {
            this.support.firePropertyChange("ejb", ejb, null);
            ejb.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEnvironment(String name2) {
        this.entries.remove(name2);
        ContextEnvironment environment = null;
        Map<String, ContextEnvironment> map2 = this.envs;
        synchronized (map2) {
            environment = this.envs.remove(name2);
        }
        if (environment != null) {
            this.support.firePropertyChange("environment", environment, null);
            if (this.resourceRequireExplicitRegistration) {
                try {
                    MBeanUtils.destroyMBean(environment);
                }
                catch (Exception e2) {
                    log.warn(sm.getString("namingResources.mbeanDestroyFail", environment.getName()), e2);
                }
            }
            environment.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalEjb(String name2) {
        this.entries.remove(name2);
        ContextLocalEjb localEjb = null;
        Map<String, ContextLocalEjb> map2 = this.localEjbs;
        synchronized (map2) {
            localEjb = this.localEjbs.remove(name2);
        }
        if (localEjb != null) {
            this.support.firePropertyChange("localEjb", localEjb, null);
            localEjb.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageDestinationRef(String name2) {
        this.entries.remove(name2);
        MessageDestinationRef mdr = null;
        Map<String, MessageDestinationRef> map2 = this.mdrs;
        synchronized (map2) {
            mdr = this.mdrs.remove(name2);
        }
        if (mdr != null) {
            this.support.firePropertyChange("messageDestinationRef", mdr, null);
            mdr.setNamingResources(null);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResource(String name2) {
        this.entries.remove(name2);
        ContextResource resource2 = null;
        HashMap<String, ContextResource> hashMap = this.resources;
        synchronized (hashMap) {
            resource2 = this.resources.remove(name2);
        }
        if (resource2 != null) {
            this.support.firePropertyChange("resource", resource2, null);
            if (this.resourceRequireExplicitRegistration) {
                try {
                    MBeanUtils.destroyMBean(resource2);
                }
                catch (Exception e2) {
                    log.warn(sm.getString("namingResources.mbeanDestroyFail", resource2.getName()), e2);
                }
            }
            resource2.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceEnvRef(String name2) {
        this.entries.remove(name2);
        ContextResourceEnvRef resourceEnvRef = null;
        HashMap<String, ContextResourceEnvRef> hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            resourceEnvRef = this.resourceEnvRefs.remove(name2);
        }
        if (resourceEnvRef != null) {
            this.support.firePropertyChange("resourceEnvRef", resourceEnvRef, null);
            resourceEnvRef.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResourceLink(String name2) {
        this.entries.remove(name2);
        ContextResourceLink resourceLink = null;
        HashMap<String, ContextResourceLink> hashMap = this.resourceLinks;
        synchronized (hashMap) {
            resourceLink = this.resourceLinks.remove(name2);
        }
        if (resourceLink != null) {
            this.support.firePropertyChange("resourceLink", resourceLink, null);
            if (this.resourceRequireExplicitRegistration) {
                try {
                    MBeanUtils.destroyMBean(resourceLink);
                }
                catch (Exception e2) {
                    log.warn(sm.getString("namingResources.mbeanDestroyFail", resourceLink.getName()), e2);
                }
            }
            resourceLink.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeService(String name2) {
        this.entries.remove(name2);
        ContextService service = null;
        HashMap<String, ContextService> hashMap = this.services;
        synchronized (hashMap) {
            service = this.services.remove(name2);
        }
        if (service != null) {
            this.support.firePropertyChange("service", service, null);
            service.setNamingResources(null);
        }
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.resourceRequireExplicitRegistration = true;
        for (ContextResource cr : this.resources.values()) {
            try {
                MBeanUtils.createMBean(cr);
            }
            catch (Exception e2) {
                log.warn(sm.getString("namingResources.mbeanCreateFail", cr.getName()), e2);
            }
        }
        for (ContextEnvironment ce : this.envs.values()) {
            try {
                MBeanUtils.createMBean(ce);
            }
            catch (Exception e3) {
                log.warn(sm.getString("namingResources.mbeanCreateFail", ce.getName()), e3);
            }
        }
        for (ContextResourceLink crl : this.resourceLinks.values()) {
            try {
                MBeanUtils.createMBean(crl);
            }
            catch (Exception e4) {
                log.warn(sm.getString("namingResources.mbeanCreateFail", crl.getName()), e4);
            }
        }
    }

    @Override
    protected void startInternal() throws LifecycleException {
        this.fireLifecycleEvent("configure_start", null);
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.cleanUp();
        this.setState(LifecycleState.STOPPING);
        this.fireLifecycleEvent("configure_stop", null);
    }

    private void cleanUp() {
        javax.naming.Context ctxt;
        if (this.resources.size() == 0) {
            return;
        }
        try {
            if (this.container instanceof Server) {
                ctxt = ((Server)this.container).getGlobalNamingContext();
            } else {
                ctxt = ContextBindings.getClassLoader();
                ctxt = (javax.naming.Context)ctxt.lookup("comp/env");
            }
        }
        catch (NamingException e2) {
            log.warn(sm.getString("namingResources.cleanupNoContext", this.container), e2);
            return;
        }
        for (ContextResource cr : this.resources.values()) {
            Object resource2;
            String closeMethod;
            if (!cr.getSingleton() || (closeMethod = cr.getCloseMethod()) == null || closeMethod.length() <= 0) continue;
            String name2 = cr.getName();
            try {
                resource2 = ctxt.lookup(name2);
            }
            catch (NamingException e3) {
                log.warn(sm.getString("namingResources.cleanupNoResource", cr.getName(), this.container), e3);
                continue;
            }
            this.cleanUp(resource2, name2, closeMethod);
        }
    }

    private void cleanUp(Object resource2, String name2, String closeMethod) {
        Method m = null;
        try {
            m = resource2.getClass().getMethod(closeMethod, null);
        }
        catch (SecurityException e2) {
            log.debug(sm.getString("namingResources.cleanupCloseSecurity", closeMethod, name2, this.container));
            return;
        }
        catch (NoSuchMethodException e3) {
            log.debug(sm.getString("namingResources.cleanupNoClose", name2, this.container, closeMethod));
            return;
        }
        try {
            m.invoke(resource2, (Object[])null);
        }
        catch (IllegalAccessException | IllegalArgumentException e4) {
            log.warn(sm.getString("namingResources.cleanupCloseFailed", closeMethod, name2, this.container), e4);
        }
        catch (InvocationTargetException e5) {
            Throwable t = ExceptionUtils.unwrapInvocationTargetException(e5);
            ExceptionUtils.handleThrowable(t);
            log.warn(sm.getString("namingResources.cleanupCloseFailed", closeMethod, name2, this.container), t);
        }
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        this.resourceRequireExplicitRegistration = false;
        for (ContextResourceLink crl : this.resourceLinks.values()) {
            try {
                MBeanUtils.destroyMBean(crl);
            }
            catch (Exception e2) {
                log.warn(sm.getString("namingResources.mbeanDestroyFail", crl.getName()), e2);
            }
        }
        for (ContextEnvironment ce : this.envs.values()) {
            try {
                MBeanUtils.destroyMBean(ce);
            }
            catch (Exception e3) {
                log.warn(sm.getString("namingResources.mbeanDestroyFail", ce.getName()), e3);
            }
        }
        for (ContextResource cr : this.resources.values()) {
            try {
                MBeanUtils.destroyMBean(cr);
            }
            catch (Exception e4) {
                log.warn(sm.getString("namingResources.mbeanDestroyFail", cr.getName()), e4);
            }
        }
        super.destroyInternal();
    }

    @Override
    protected String getDomainInternal() {
        Object c = this.getContainer();
        if (c instanceof JmxEnabled) {
            return ((JmxEnabled)c).getDomain();
        }
        return null;
    }

    @Override
    protected String getObjectNameKeyProperties() {
        Object c = this.getContainer();
        if (c instanceof Container) {
            return "type=NamingResources" + ((Container)c).getMBeanKeyProperties();
        }
        return "type=NamingResources";
    }

    private boolean checkResourceType(ResourceBase resource2) {
        if (!(this.container instanceof Context)) {
            return true;
        }
        if (resource2.getInjectionTargets() == null || resource2.getInjectionTargets().size() == 0) {
            return true;
        }
        Context context = (Context)this.container;
        String typeName = resource2.getType();
        Class<?> typeClass = null;
        if (typeName != null && (typeClass = Introspection.loadClass(context, typeName)) == null) {
            return true;
        }
        Class<?> compatibleClass = this.getCompatibleType(context, resource2, typeClass);
        if (compatibleClass == null) {
            return false;
        }
        resource2.setType(compatibleClass.getCanonicalName());
        return true;
    }

    private Class<?> getCompatibleType(Context context, ResourceBase resource2, Class<?> typeClass) {
        Class<?> result = null;
        for (InjectionTarget injectionTarget : resource2.getInjectionTargets()) {
            Class<?> clazz = Introspection.loadClass(context, injectionTarget.getTargetClass());
            if (clazz == null) continue;
            String targetName = injectionTarget.getTargetName();
            Class<?> targetType = this.getSetterType(clazz, targetName);
            if (targetType == null) {
                targetType = this.getFieldType(clazz, targetName);
            }
            if (targetType == null) continue;
            targetType = Introspection.convertPrimitiveType(targetType);
            if (typeClass == null) {
                if (result == null) {
                    result = targetType;
                    continue;
                }
                if (targetType.isAssignableFrom(result)) continue;
                if (result.isAssignableFrom(targetType)) {
                    result = targetType;
                    continue;
                }
                return null;
            }
            if (targetType.isAssignableFrom(typeClass)) {
                result = typeClass;
                continue;
            }
            return null;
        }
        return result;
    }

    private Class<?> getSetterType(Class<?> clazz, String name2) {
        Method[] methods2 = Introspection.getDeclaredMethods(clazz);
        if (methods2 != null && methods2.length > 0) {
            for (Method method : methods2) {
                if (!Introspection.isValidSetter(method) || !Introspection.getPropertyName(method).equals(name2)) continue;
                return method.getParameterTypes()[0];
            }
        }
        return null;
    }

    private Class<?> getFieldType(Class<?> clazz, String name2) {
        Field[] fields = Introspection.getDeclaredFields(clazz);
        if (fields != null && fields.length > 0) {
            for (Field field : fields) {
                if (!field.getName().equals(name2)) continue;
                return field.getType();
            }
        }
        return null;
    }
}

