/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class CallbackHandlerImpl
implements CallbackHandler {
    private static final StringManager sm = StringManager.getManager(CallbackHandlerImpl.class);
    private static CallbackHandler instance = new CallbackHandlerImpl();

    public static CallbackHandler getInstance() {
        return instance;
    }

    private CallbackHandlerImpl() {
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        String name2 = null;
        Principal principal = null;
        Subject subject = null;
        String[] groups = null;
        if (callbacks != null) {
            for (Callback callback : callbacks) {
                if (callback instanceof CallerPrincipalCallback) {
                    CallerPrincipalCallback cpc = (CallerPrincipalCallback)callback;
                    name2 = cpc.getName();
                    principal = cpc.getPrincipal();
                    subject = cpc.getSubject();
                    continue;
                }
                if (callback instanceof GroupPrincipalCallback) {
                    GroupPrincipalCallback gpc = (GroupPrincipalCallback)callback;
                    groups = gpc.getGroups();
                    continue;
                }
                Log log = LogFactory.getLog(CallbackHandlerImpl.class);
                log.error(sm.getString("callbackHandlerImpl.jaspicCallbackMissing", callback.getClass().getName()));
            }
            Principal gp = this.getPrincipal(principal, name2, groups);
            if (subject != null && gp != null) {
                subject.getPrivateCredentials().add(gp);
            }
        }
    }

    private Principal getPrincipal(Principal principal, String name2, String[] groups) {
        if (principal instanceof GenericPrincipal) {
            return principal;
        }
        if (name2 == null && principal != null) {
            name2 = principal.getName();
        }
        if (name2 == null) {
            return null;
        }
        List<Object> roles = groups == null || groups.length == 0 ? Collections.emptyList() : Arrays.asList(groups);
        return new GenericPrincipal(name2, null, roles, principal);
    }
}

