/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

class URLPattern
implements Comparable {
    private static String DEFAULT_PATTERN = "/";
    private int patternType = -1;
    private final String pattern;
    public static final int PT_DEFAULT = 0;
    public static final int PT_EXTENSION = 1;
    public static final int PT_PREFIX = 2;
    public static final int PT_EXACT = 3;

    public URLPattern() {
        this.pattern = DEFAULT_PATTERN;
        this.patternType = 0;
    }

    public URLPattern(String p) {
        if (p == null) {
            this.pattern = DEFAULT_PATTERN;
            this.patternType = 0;
        } else {
            this.pattern = p;
        }
    }

    public int patternType() {
        if (this.patternType < 0) {
            this.patternType = this.pattern.startsWith("*.") ? 1 : (this.pattern.startsWith("/") && this.pattern.endsWith("/*") ? 2 : (this.pattern.equals(DEFAULT_PATTERN) ? 0 : 3));
        }
        return this.patternType;
    }

    public int compareTo(Object o) {
        if (!(o instanceof URLPattern)) {
            throw new ClassCastException("argument must be URLPattern");
        }
        URLPattern p = (URLPattern)o;
        int refPatternType = this.patternType();
        int result = refPatternType - p.patternType();
        if (result == 0) {
            if (refPatternType == 2 || refPatternType == 3) {
                result = this.getPatternDepth() - p.getPatternDepth();
                if (result == 0) {
                    result = this.pattern.compareTo(p.pattern);
                }
            } else {
                result = this.pattern.compareTo(p.pattern);
            }
        }
        return result > 0 ? 1 : (result < 0 ? -1 : 0);
    }

    public boolean implies(URLPattern p) {
        String path2;
        String pattern;
        if (p == null) {
            p = new URLPattern(null);
        }
        if ((pattern = this.pattern).equals(path2 = p.pattern)) {
            return true;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            int length = (pattern = pattern.substring(0, pattern.length() - 2)).length();
            if (length == 0) {
                return true;
            }
            return path2.startsWith(pattern) && (path2.length() == length || path2.substring(length).startsWith("/"));
        }
        if (pattern.startsWith("*.")) {
            int slash = path2.lastIndexOf(47);
            int period = path2.lastIndexOf(46);
            return slash >= 0 && period > slash && path2.endsWith(pattern.substring(1));
        }
        return pattern.equals(DEFAULT_PATTERN);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof URLPattern)) {
            return false;
        }
        return this.pattern.equals(((URLPattern)obj).pattern);
    }

    public String toString() {
        return this.pattern;
    }

    public int getPatternDepth() {
        int i = 0;
        int depth = 1;
        while (i >= 0) {
            if ((i = this.pattern.indexOf("/", i)) < 0) continue;
            if (i == 0 && depth != 1) {
                throw new IllegalArgumentException("// in pattern");
            }
            ++i;
        }
        return depth;
    }
}

