/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol;

import io.undertow.connector.ByteBufferPool;
import io.undertow.websockets.WebSocketExtension;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.extensions.ExtensionFunction;
import io.undertow.websockets.extensions.ExtensionHandshake;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.xnio.IoFuture;
import org.xnio.StreamConnection;

public abstract class Handshake {
    private final WebSocketVersion version;
    private final String hashAlgorithm;
    private final String magicNumber;
    protected final Set<String> subprotocols;
    private static final byte[] EMPTY = new byte[0];
    private static final Pattern PATTERN = Pattern.compile("\\s*,\\s*");
    protected Set<ExtensionHandshake> availableExtensions = new HashSet<ExtensionHandshake>();
    protected boolean allowExtensions;

    protected Handshake(WebSocketVersion version, String hashAlgorithm, String magicNumber, Set<String> subprotocols) {
        this.version = version;
        this.hashAlgorithm = hashAlgorithm;
        this.magicNumber = magicNumber;
        this.subprotocols = subprotocols;
    }

    public WebSocketVersion getVersion() {
        return this.version;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String getMagicNumber() {
        return this.magicNumber;
    }

    protected static String getWebSocketLocation(WebSocketHttpExchange exchange) {
        String scheme = "https".equals(exchange.getRequestScheme()) ? "wss" : "ws";
        return scheme + "://" + exchange.getRequestHeader("Host") + exchange.getRequestURI();
    }

    public final void handshake(WebSocketHttpExchange exchange) {
        exchange.putAttachment(WebSocketVersion.ATTACHMENT_KEY, this.version);
        this.handshakeInternal(exchange);
    }

    protected abstract void handshakeInternal(WebSocketHttpExchange var1);

    public abstract boolean matches(WebSocketHttpExchange var1);

    public abstract WebSocketChannel createChannel(WebSocketHttpExchange var1, StreamConnection var2, ByteBufferPool var3);

    protected final void performUpgrade(WebSocketHttpExchange exchange, byte[] data2) {
        exchange.setResponseHeader("Content-Length", String.valueOf(data2.length));
        exchange.setResponseHeader("Upgrade", "WebSocket");
        exchange.setResponseHeader("Connection", "Upgrade");
        this.upgradeChannel(exchange, data2);
    }

    protected void upgradeChannel(WebSocketHttpExchange exchange, byte[] data2) {
        if (data2.length > 0) {
            Handshake.writePayload(exchange, ByteBuffer.wrap(data2));
        } else {
            exchange.endExchange();
        }
    }

    private static void writePayload(final WebSocketHttpExchange exchange, ByteBuffer payload) {
        exchange.sendData(payload).addNotifier(new IoFuture.Notifier<Void, Object>(){

            @Override
            public void notify(IoFuture<? extends Void> ioFuture, Object attachment) {
                if (ioFuture.getStatus() == IoFuture.Status.DONE) {
                    exchange.endExchange();
                } else {
                    exchange.close();
                }
            }
        }, null);
    }

    protected final void performUpgrade(WebSocketHttpExchange exchange) {
        this.performUpgrade(exchange, EMPTY);
    }

    protected final void selectSubprotocol(WebSocketHttpExchange exchange) {
        String requestedSubprotocols = exchange.getRequestHeader("Sec-WebSocket-Protocol");
        if (requestedSubprotocols == null) {
            return;
        }
        String[] requestedSubprotocolArray = PATTERN.split(requestedSubprotocols);
        String subProtocol = this.supportedSubprotols(requestedSubprotocolArray);
        if (subProtocol != null && !subProtocol.isEmpty()) {
            exchange.setResponseHeader("Sec-WebSocket-Protocol", subProtocol);
        }
    }

    protected final void selectExtensions(WebSocketHttpExchange exchange) {
        List<WebSocketExtension> requestedExtensions = WebSocketExtension.parse(exchange.getRequestHeader("Sec-WebSocket-Extensions"));
        List<WebSocketExtension> extensions = this.selectedExtension(requestedExtensions);
        if (extensions != null && !extensions.isEmpty()) {
            exchange.setResponseHeader("Sec-WebSocket-Extensions", WebSocketExtension.toExtensionHeader(extensions));
        }
    }

    protected String supportedSubprotols(String[] requestedSubprotocolArray) {
        for (String p : requestedSubprotocolArray) {
            String requestedSubprotocol = p.trim();
            for (String supportedSubprotocol : this.subprotocols) {
                if (!requestedSubprotocol.equals(supportedSubprotocol)) continue;
                return supportedSubprotocol;
            }
        }
        return null;
    }

    protected List<WebSocketExtension> selectedExtension(List<WebSocketExtension> extensionList) {
        ArrayList<WebSocketExtension> selected = new ArrayList<WebSocketExtension>();
        ArrayList<ExtensionHandshake> configured = new ArrayList<ExtensionHandshake>();
        for (WebSocketExtension ext : extensionList) {
            for (ExtensionHandshake extHandshake : this.availableExtensions) {
                WebSocketExtension negotiated = extHandshake.accept(ext);
                if (negotiated == null || extHandshake.isIncompatible(configured)) continue;
                selected.add(negotiated);
                configured.add(extHandshake);
            }
        }
        return selected;
    }

    public final void addExtension(ExtensionHandshake extension) {
        this.availableExtensions.add(extension);
        this.allowExtensions = true;
    }

    protected final List<ExtensionFunction> initExtensions(WebSocketHttpExchange exchange) {
        List<WebSocketExtension> extensions;
        String extHeader = exchange.getResponseHeaders().get("Sec-WebSocket-Extensions") != null ? exchange.getResponseHeaders().get("Sec-WebSocket-Extensions").get(0) : null;
        ArrayList<ExtensionFunction> negotiated = new ArrayList<ExtensionFunction>();
        if (extHeader != null && (extensions = WebSocketExtension.parse(extHeader)) != null && !extensions.isEmpty()) {
            for (WebSocketExtension ext : extensions) {
                for (ExtensionHandshake extHandshake : this.availableExtensions) {
                    if (!extHandshake.getName().equals(ext.getName())) continue;
                    negotiated.add(extHandshake.create());
                }
            }
        }
        return negotiated;
    }
}

