/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class SubstringMap<V> {
    private static final int ALL_BUT_LAST_BIT = -2;
    private volatile Object[] table = new Object[16];
    private int size;

    public SubstringMatch<V> get(String key2, int length) {
        return this.get(key2, length, false);
    }

    public SubstringMatch<V> get(String key2) {
        return this.get(key2, key2.length(), false);
    }

    private SubstringMatch<V> get(String key2, int length, boolean exact) {
        int pos;
        if (key2.length() < length) {
            throw new IllegalArgumentException();
        }
        Object[] table = this.table;
        int hash2 = SubstringMap.hash(key2, length);
        int start = pos = this.tablePos(table, hash2);
        while (table[pos] != null) {
            if (exact ? table[pos].equals(key2) : this.doEquals((String)table[pos], key2, length)) {
                return (SubstringMatch)table[pos + 1];
            }
            if ((pos += 2) >= table.length) {
                pos = 0;
            }
            if (pos != start) continue;
            return null;
        }
        return null;
    }

    private int tablePos(Object[] table, int hash2) {
        return hash2 & table.length - 1 & 0xFFFFFFFE;
    }

    private boolean doEquals(String s1, String s2, int length) {
        if (s1.length() != length || s2.length() < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public synchronized void put(String key2, V value) {
        Object[] newTable;
        if (key2 == null) {
            throw new NullPointerException();
        }
        if ((double)this.table.length / (double)this.size < 4.0 && this.table.length != Integer.MAX_VALUE) {
            newTable = new Object[this.table.length << 1];
            for (int i = 0; i < this.table.length; i += 2) {
                if (this.table[i] == null) continue;
                this.doPut(newTable, (String)this.table[i], this.table[i + 1]);
            }
        } else {
            newTable = new Object[this.table.length];
            System.arraycopy(this.table, 0, newTable, 0, this.table.length);
        }
        this.doPut(newTable, key2, new SubstringMatch<V>(key2, value));
        this.table = newTable;
        ++this.size;
    }

    public synchronized V remove(String key2) {
        if (key2 == null) {
            throw new NullPointerException();
        }
        Object value = null;
        Object[] newTable = new Object[this.table.length];
        for (int i = 0; i < this.table.length; i += 2) {
            if (this.table[i] != null && !this.table[i].equals(key2)) {
                this.doPut(newTable, (String)this.table[i], this.table[i + 1]);
                continue;
            }
            if (this.table[i] == null) continue;
            value = this.table[i + 1];
            --this.size;
        }
        this.table = newTable;
        if (value == null) {
            return null;
        }
        return ((SubstringMatch)value).getValue();
    }

    private void doPut(Object[] newTable, String key2, Object value) {
        int hash2 = SubstringMap.hash(key2, key2.length());
        int pos = this.tablePos(newTable, hash2);
        while (newTable[pos] != null && !newTable[pos].equals(key2)) {
            if ((pos += 2) < newTable.length) continue;
            pos = 0;
        }
        newTable[pos] = key2;
        newTable[pos + 1] = value;
    }

    public Map<String, V> toMap() {
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        Object[] t = this.table;
        for (int i = 0; i < t.length; i += 2) {
            if (t[i] == null) continue;
            map2.put((String)t[i], ((SubstringMatch)t[i + 1]).value);
        }
        return map2;
    }

    public synchronized void clear() {
        this.size = 0;
        this.table = new Object[16];
    }

    private static int hash(String value, int length) {
        if (length == 0) {
            return 0;
        }
        int h = 0;
        for (int i = 0; i < length; ++i) {
            h = 31 * h + value.charAt(i);
        }
        return h;
    }

    public Iterable<String> keys() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                int i;
                final Object[] tMap = SubstringMap.this.table;
                for (i = 0; i < SubstringMap.this.table.length && tMap[i] == null; i += 2) {
                }
                final int startPos = i;
                return new Iterator<String>(){
                    private Object[] map;
                    private int pos;
                    {
                        this.map = tMap;
                        this.pos = startPos;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.pos < SubstringMap.this.table.length;
                    }

                    @Override
                    public String next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        String ret = (String)this.map[this.pos];
                        this.pos += 2;
                        while (this.pos < SubstringMap.this.table.length && tMap[this.pos] == null) {
                            this.pos += 2;
                        }
                        return ret;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static final class SubstringMatch<V> {
        private final String key;
        private final V value;

        public SubstringMatch(String key2, V value) {
            this.key = key2;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

