/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.server.HttpServerExchange;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Deque;
import java.util.Map;

public class RedirectBuilder {
    public static final String UTF_8 = StandardCharsets.UTF_8.name();

    public static String redirect(HttpServerExchange exchange, String newRelativePath) {
        return RedirectBuilder.redirect(exchange, newRelativePath, true);
    }

    public static String redirect(HttpServerExchange exchange, String newRelativePath, boolean includeParameters) {
        try {
            StringBuilder uri = new StringBuilder(exchange.getRequestScheme());
            uri.append("://");
            uri.append(exchange.getHostAndPort());
            uri.append(RedirectBuilder.encodeUrlPart(exchange.getResolvedPath()));
            if (exchange.getResolvedPath().endsWith("/")) {
                if (newRelativePath.startsWith("/")) {
                    uri.append(RedirectBuilder.encodeUrlPart(newRelativePath.substring(1)));
                } else {
                    uri.append(RedirectBuilder.encodeUrlPart(newRelativePath));
                }
            } else {
                if (!newRelativePath.startsWith("/")) {
                    uri.append('/');
                }
                uri.append(RedirectBuilder.encodeUrlPart(newRelativePath));
            }
            if (includeParameters) {
                if (!exchange.getPathParameters().isEmpty()) {
                    boolean first = true;
                    uri.append(';');
                    for (Map.Entry<String, Deque<String>> param : exchange.getPathParameters().entrySet()) {
                        for (String value : param.getValue()) {
                            if (first) {
                                first = false;
                            } else {
                                uri.append('&');
                            }
                            uri.append(URLEncoder.encode(param.getKey(), UTF_8));
                            uri.append('=');
                            uri.append(URLEncoder.encode(value, UTF_8));
                        }
                    }
                }
                if (!exchange.getQueryString().isEmpty()) {
                    uri.append('?');
                    uri.append(exchange.getQueryString());
                }
            }
            return uri.toString();
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static String encodeUrlPart(String part) throws UnsupportedEncodingException {
        char c;
        int pos = 0;
        for (int i = 0; i < part.length() && (c = part.charAt(i)) != '?'; ++i) {
            if (c == '/') {
                String original;
                String encoded;
                if (pos != i && !(encoded = URLEncoder.encode(original = part.substring(pos, i), UTF_8)).equals(original)) {
                    return RedirectBuilder.realEncode(part, pos);
                }
                pos = i + 1;
                continue;
            }
            if (c != ' ') continue;
            return RedirectBuilder.realEncode(part, pos);
        }
        return part;
    }

    private static String realEncode(String part, int startPos) throws UnsupportedEncodingException {
        char c;
        StringBuilder sb = new StringBuilder();
        sb.append(part.substring(0, startPos));
        int pos = startPos;
        for (int i = startPos; i < part.length() && (c = part.charAt(i)) != '?'; ++i) {
            if (c != '/' || pos == i) continue;
            String original = part.substring(pos, i);
            String encoded = URLEncoder.encode(original, UTF_8);
            sb.append(encoded);
            sb.append('/');
            pos = i + 1;
        }
        String original = part.substring(pos);
        String encoded = URLEncoder.encode(original, UTF_8);
        sb.append(encoded);
        return sb.toString();
    }

    private RedirectBuilder() {
    }
}

