/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowOptions;
import io.undertow.server.HttpServerExchange;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xnio.OptionMap;

public class QueryParameterUtils {
    private QueryParameterUtils() {
    }

    public static String buildQueryString(Map<String, Deque<String>> params) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, Deque<String>> entry : params.entrySet()) {
            if (entry.getValue().isEmpty()) {
                if (first) {
                    first = false;
                } else {
                    sb.append('&');
                }
                sb.append(entry.getKey());
                sb.append('=');
                continue;
            }
            for (String val2 : entry.getValue()) {
                if (first) {
                    first = false;
                } else {
                    sb.append('&');
                }
                sb.append(entry.getKey());
                sb.append('=');
                sb.append(val2);
            }
        }
        return sb.toString();
    }

    @Deprecated
    public static Map<String, Deque<String>> parseQueryString(String newQueryString) {
        return QueryParameterUtils.parseQueryString(newQueryString, null);
    }

    public static Map<String, Deque<String>> parseQueryString(String newQueryString, String encoding2) {
        LinkedHashMap<String, Deque<String>> newQueryParameters = new LinkedHashMap<String, Deque<String>>();
        int startPos = 0;
        int equalPos = -1;
        boolean needsDecode = false;
        for (int i = 0; i < newQueryString.length(); ++i) {
            char c = newQueryString.charAt(i);
            if (c == '=' && equalPos == -1) {
                equalPos = i;
                continue;
            }
            if (c == '&') {
                QueryParameterUtils.handleQueryParameter(newQueryString, newQueryParameters, startPos, equalPos, i, encoding2, needsDecode);
                needsDecode = false;
                startPos = i + 1;
                equalPos = -1;
                continue;
            }
            if (c != '%' && c != '+' || encoding2 == null) continue;
            needsDecode = true;
        }
        if (startPos != newQueryString.length()) {
            QueryParameterUtils.handleQueryParameter(newQueryString, newQueryParameters, startPos, equalPos, newQueryString.length(), encoding2, needsDecode);
        }
        return newQueryParameters;
    }

    private static void handleQueryParameter(String newQueryString, Map<String, Deque<String>> newQueryParameters, int startPos, int equalPos, int i, String encoding2, boolean needsDecode) {
        String key2;
        String value = "";
        if (equalPos == -1) {
            key2 = QueryParameterUtils.decodeParam(newQueryString, startPos, i, encoding2, needsDecode);
        } else {
            key2 = QueryParameterUtils.decodeParam(newQueryString, startPos, equalPos, encoding2, needsDecode);
            value = QueryParameterUtils.decodeParam(newQueryString, equalPos + 1, i, encoding2, needsDecode);
        }
        Deque<String> queue = newQueryParameters.get(key2);
        if (queue == null) {
            queue = new ArrayDeque<String>(1);
            newQueryParameters.put(key2, queue);
        }
        if (value != null) {
            queue.add(value);
        }
    }

    private static String decodeParam(String newQueryString, int startPos, int equalPos, String encoding2, boolean needsDecode) {
        String key2;
        if (needsDecode) {
            try {
                key2 = URLDecoder.decode(newQueryString.substring(startPos, equalPos), encoding2);
            }
            catch (UnsupportedEncodingException e2) {
                key2 = newQueryString.substring(startPos, equalPos);
            }
        } else {
            key2 = newQueryString.substring(startPos, equalPos);
        }
        return key2;
    }

    @Deprecated
    public static Map<String, Deque<String>> mergeQueryParametersWithNewQueryString(Map<String, Deque<String>> queryParameters, String newQueryString) {
        return QueryParameterUtils.mergeQueryParametersWithNewQueryString(queryParameters, newQueryString, StandardCharsets.UTF_8.name());
    }

    public static Map<String, Deque<String>> mergeQueryParametersWithNewQueryString(Map<String, Deque<String>> queryParameters, String newQueryString, String encoding2) {
        Map<String, Deque<String>> newQueryParameters = QueryParameterUtils.parseQueryString(newQueryString, encoding2);
        for (Map.Entry<String, Deque<String>> entry : queryParameters.entrySet()) {
            if (!newQueryParameters.containsKey(entry.getKey())) {
                newQueryParameters.put(entry.getKey(), new ArrayDeque(entry.getValue()));
                continue;
            }
            newQueryParameters.get(entry.getKey()).addAll((Collection<String>)entry.getValue());
        }
        return newQueryParameters;
    }

    public static String getQueryParamEncoding(HttpServerExchange exchange) {
        String encoding2 = null;
        OptionMap undertowOptions = exchange.getConnection().getUndertowOptions();
        if (undertowOptions.get(UndertowOptions.DECODE_URL, true)) {
            encoding2 = undertowOptions.get(UndertowOptions.URL_CHARSET, StandardCharsets.UTF_8.name());
        }
        return encoding2;
    }
}

