/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.SubstringMap;
import io.undertow.util.URLUtils;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;

public class PathMatcher<T> {
    private static final String STRING_PATH_SEPARATOR = "/";
    private volatile T defaultHandler;
    private final SubstringMap<T> paths = new SubstringMap();
    private final ConcurrentMap<String, T> exactPathMatches = new CopyOnWriteMap<String, T>();
    private volatile int[] lengths = new int[0];

    public PathMatcher(T defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    public PathMatcher() {
    }

    public PathMatch<T> match(String path2) {
        T match;
        if (!this.exactPathMatches.isEmpty() && (match = this.getExactPath(path2)) != null) {
            UndertowLogger.REQUEST_LOGGER.debugf("Matched exact path %s", (Object)path2);
            return new PathMatch<T>(path2, "", match);
        }
        int length = path2.length();
        int[] lengths = this.lengths;
        for (int i = 0; i < lengths.length; ++i) {
            SubstringMap.SubstringMatch<T> next2;
            char c;
            int pathLength = lengths[i];
            if (pathLength == length) {
                SubstringMap.SubstringMatch<T> next3 = this.paths.get(path2, length);
                if (next3 == null) continue;
                UndertowLogger.REQUEST_LOGGER.debugf("Matched prefix path %s for path %s", (Object)next3.getKey(), (Object)path2);
                return new PathMatch<T>(path2, "", next3.getValue());
            }
            if (pathLength >= length || (c = path2.charAt(pathLength)) != '/' || (next2 = this.paths.get(path2, pathLength)) == null) continue;
            UndertowLogger.REQUEST_LOGGER.debugf("Matched prefix path %s for path %s", (Object)next2.getKey(), (Object)path2);
            return new PathMatch<T>(next2.getKey(), path2.substring(pathLength), next2.getValue());
        }
        UndertowLogger.REQUEST_LOGGER.debugf("Matched default handler path %s", (Object)path2);
        return new PathMatch<T>("", path2, this.defaultHandler);
    }

    public synchronized PathMatcher addPrefixPath(String path2, T handler) {
        if (path2.isEmpty()) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        String normalizedPath = URLUtils.normalizeSlashes(path2);
        if (STRING_PATH_SEPARATOR.equals(normalizedPath)) {
            this.defaultHandler = handler;
            return this;
        }
        this.paths.put(normalizedPath, handler);
        this.buildLengths();
        return this;
    }

    public synchronized PathMatcher addExactPath(String path2, T handler) {
        if (path2.isEmpty()) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        this.exactPathMatches.put(URLUtils.normalizeSlashes(path2), handler);
        return this;
    }

    public T getExactPath(String path2) {
        return (T)this.exactPathMatches.get(URLUtils.normalizeSlashes(path2));
    }

    public T getPrefixPath(String path2) {
        String normalizedPath = URLUtils.normalizeSlashes(path2);
        SubstringMap.SubstringMatch<T> match = this.paths.get(normalizedPath);
        if (STRING_PATH_SEPARATOR.equals(normalizedPath) && match == null) {
            return this.defaultHandler;
        }
        if (match == null) {
            return null;
        }
        return match.getValue();
    }

    private void buildLengths() {
        TreeSet<Integer> lengths = new TreeSet<Integer>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return -o1.compareTo(o2);
            }
        });
        for (String p : this.paths.keys()) {
            lengths.add(p.length());
        }
        int[] lengthArray = new int[lengths.size()];
        int pos = 0;
        Iterator iterator = lengths.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            lengthArray[pos++] = i;
        }
        this.lengths = lengthArray;
    }

    @Deprecated
    public synchronized PathMatcher removePath(String path2) {
        return this.removePrefixPath(path2);
    }

    public synchronized PathMatcher removePrefixPath(String path2) {
        if (path2 == null || path2.isEmpty()) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        String normalizedPath = URLUtils.normalizeSlashes(path2);
        if (STRING_PATH_SEPARATOR.equals(normalizedPath)) {
            this.defaultHandler = null;
            return this;
        }
        this.paths.remove(normalizedPath);
        this.buildLengths();
        return this;
    }

    public synchronized PathMatcher removeExactPath(String path2) {
        if (path2 == null || path2.isEmpty()) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        this.exactPathMatches.remove(URLUtils.normalizeSlashes(path2));
        return this;
    }

    public synchronized PathMatcher clearPaths() {
        this.paths.clear();
        this.exactPathMatches.clear();
        this.lengths = new int[0];
        this.defaultHandler = null;
        return this;
    }

    public Map<String, T> getPaths() {
        return this.paths.toMap();
    }

    public static final class PathMatch<T> {
        private final String matched;
        private final String remaining;
        private final T value;

        public PathMatch(String matched, String remaining, T value) {
            this.matched = matched;
            this.remaining = remaining;
            this.value = value;
        }

        public String getRemaining() {
            return this.remaining;
        }

        public String getMatched() {
            return this.matched;
        }

        public T getValue() {
            return this.value;
        }
    }
}

