/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.FilterMappingInfo;
import io.undertow.servlet.spec.ServletContextImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;

public class FilterRegistrationImpl
implements FilterRegistration,
FilterRegistration.Dynamic {
    private final FilterInfo filterInfo;
    private final Deployment deployment;
    private final ServletContextImpl servletContext;

    public FilterRegistrationImpl(FilterInfo filterInfo, Deployment deployment, ServletContextImpl servletContext) {
        this.filterInfo = filterInfo;
        this.deployment = deployment;
        this.servletContext = servletContext;
    }

    @Override
    public void addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
        this.servletContext.addMappingForServletNames(this.filterInfo, dispatcherTypes, isMatchAfter, servletNames);
    }

    @Override
    public Collection<String> getServletNameMappings() {
        DeploymentInfo deploymentInfo = this.deployment.getDeploymentInfo();
        ArrayList<String> ret = new ArrayList<String>();
        for (FilterMappingInfo mapping : deploymentInfo.getFilterMappings()) {
            if (mapping.getMappingType() != FilterMappingInfo.MappingType.SERVLET || !mapping.getFilterName().equals(this.filterInfo.getName())) continue;
            ret.add(mapping.getMapping());
        }
        return ret;
    }

    @Override
    public void addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) {
        this.servletContext.addMappingForUrlPatterns(this.filterInfo, dispatcherTypes, isMatchAfter, urlPatterns);
    }

    @Override
    public Collection<String> getUrlPatternMappings() {
        DeploymentInfo deploymentInfo = this.deployment.getDeploymentInfo();
        ArrayList<String> ret = new ArrayList<String>();
        for (FilterMappingInfo mapping : deploymentInfo.getFilterMappings()) {
            if (mapping.getMappingType() != FilterMappingInfo.MappingType.URL || !mapping.getFilterName().equals(this.filterInfo.getName())) continue;
            ret.add(mapping.getMapping());
        }
        return ret;
    }

    @Override
    public String getName() {
        return this.filterInfo.getName();
    }

    @Override
    public String getClassName() {
        return this.filterInfo.getFilterClass().getName();
    }

    @Override
    public boolean setInitParameter(String name2, String value) {
        if (this.filterInfo.getInitParams().containsKey(name2)) {
            return false;
        }
        this.filterInfo.addInitParam(name2, value);
        return true;
    }

    @Override
    public String getInitParameter(String name2) {
        return this.filterInfo.getInitParams().get(name2);
    }

    @Override
    public Set<String> setInitParameters(Map<String, String> initParameters) {
        HashSet<String> ret = new HashSet<String>();
        for (Map.Entry<String, String> entry : initParameters.entrySet()) {
            if (this.setInitParameter(entry.getKey(), entry.getValue())) continue;
            ret.add(entry.getKey());
        }
        return ret;
    }

    @Override
    public Map<String, String> getInitParameters() {
        return this.filterInfo.getInitParams();
    }

    @Override
    public void setAsyncSupported(boolean isAsyncSupported) {
        this.filterInfo.setAsyncSupported(isAsyncSupported);
    }
}

