/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.core.DeploymentManagerImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ServletContainerImpl
implements ServletContainer {
    private final Map<String, DeploymentManager> deployments = Collections.synchronizedMap(new HashMap());
    private final Map<String, DeploymentManager> deploymentsByPath = Collections.synchronizedMap(new HashMap());

    @Override
    public Collection<String> listDeployments() {
        return new HashSet<String>(this.deployments.keySet());
    }

    @Override
    public DeploymentManager addDeployment(DeploymentInfo deployment) {
        DeploymentInfo dep = deployment.clone();
        DeploymentManagerImpl deploymentManager = new DeploymentManagerImpl(dep, this);
        this.deployments.put(dep.getDeploymentName(), deploymentManager);
        this.deploymentsByPath.put(dep.getContextPath(), deploymentManager);
        return deploymentManager;
    }

    @Override
    public DeploymentManager getDeployment(String deploymentName) {
        return this.deployments.get(deploymentName);
    }

    @Override
    public void removeDeployment(DeploymentInfo deploymentInfo) {
        DeploymentManager deploymentManager = this.deployments.get(deploymentInfo.getDeploymentName());
        if (deploymentManager.getState() != DeploymentManager.State.UNDEPLOYED) {
            throw UndertowServletMessages.MESSAGES.canOnlyRemoveDeploymentsWhenUndeployed(deploymentManager.getState());
        }
        this.deployments.remove(deploymentInfo.getDeploymentName());
        this.deploymentsByPath.remove(deploymentInfo.getContextPath());
    }

    @Override
    public DeploymentManager getDeploymentByPath(String path2) {
        int length;
        DeploymentManager exact = this.deploymentsByPath.get(path2.isEmpty() ? "/" : path2);
        if (exact != null) {
            return exact;
        }
        int pos = length = path2.length();
        while (pos > 1) {
            String part;
            DeploymentManager deployment;
            if (path2.charAt(--pos) != '/' || (deployment = this.deploymentsByPath.get(part = path2.substring(0, pos))) == null) continue;
            return deployment;
        }
        return this.deploymentsByPath.get("/");
    }
}

