/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.UndertowMessages;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import javax.servlet.DispatcherType;
import org.xnio.IoUtils;

public class BlockingWriterSenderImpl
implements Sender {
    public static final int BUFFER_SIZE = 128;
    private final CharsetDecoder charsetDecoder;
    private final HttpServerExchange exchange;
    private final PrintWriter writer;
    private FileChannel pendingFile;
    private volatile Thread inCall;
    private volatile Thread sendThread;
    private String next;
    private IoCallback queuedCallback;

    public BlockingWriterSenderImpl(HttpServerExchange exchange, PrintWriter writer2, String charset) {
        this.exchange = exchange;
        this.writer = writer2;
        this.charsetDecoder = Charset.forName(charset).newDecoder();
    }

    @Override
    public void send(ByteBuffer buffer, IoCallback callback) {
        this.sendThread = Thread.currentThread();
        if (this.inCall == Thread.currentThread()) {
            this.queue(new ByteBuffer[]{buffer}, callback);
            return;
        }
        if (this.writeBuffer(buffer, callback)) {
            this.invokeOnComplete(callback);
        }
    }

    @Override
    public void send(ByteBuffer[] buffer, IoCallback callback) {
        this.sendThread = Thread.currentThread();
        if (this.inCall == Thread.currentThread()) {
            this.queue(buffer, callback);
            return;
        }
        for (ByteBuffer b : buffer) {
            if (this.writeBuffer(b, callback)) continue;
            return;
        }
        this.invokeOnComplete(callback);
    }

    @Override
    public void send(String data2, IoCallback callback) {
        this.sendThread = Thread.currentThread();
        if (this.inCall == Thread.currentThread()) {
            this.queue(data2, callback);
            return;
        }
        this.writer.write(data2);
        this.invokeOnComplete(callback);
    }

    @Override
    public void send(ByteBuffer buffer) {
        this.send(buffer, IoCallback.END_EXCHANGE);
    }

    @Override
    public void send(ByteBuffer[] buffer) {
        this.send(buffer, IoCallback.END_EXCHANGE);
    }

    @Override
    public void send(String data2, Charset charset, IoCallback callback) {
        this.sendThread = Thread.currentThread();
        if (this.inCall == Thread.currentThread()) {
            this.queue(new ByteBuffer[]{ByteBuffer.wrap(data2.getBytes(charset))}, callback);
            return;
        }
        this.writer.write(data2);
        this.invokeOnComplete(callback);
    }

    @Override
    public void send(String data2) {
        this.send(data2, IoCallback.END_EXCHANGE);
    }

    @Override
    public void send(String data2, Charset charset) {
        this.send(data2, charset, IoCallback.END_EXCHANGE);
    }

    @Override
    public void transferFrom(FileChannel source2, IoCallback callback) {
        this.sendThread = Thread.currentThread();
        if (this.inCall == Thread.currentThread()) {
            this.queue(source2, callback);
            return;
        }
        this.performTransfer(source2, callback);
    }

    private void performTransfer(FileChannel source2, IoCallback callback) {
        ByteBuffer buffer = ByteBuffer.allocate(128);
        try {
            int ret;
            long pos = source2.position();
            long size = source2.size();
            while (size - pos > 0L && (ret = source2.read(buffer)) > 0) {
                pos += (long)ret;
                buffer.flip();
                if (!this.writeBuffer(buffer, callback)) {
                    return;
                }
                buffer.clear();
            }
            if (pos != size) {
                throw new EOFException("Unexpected EOF reading file");
            }
        }
        catch (IOException e2) {
            callback.onException(this.exchange, this, e2);
        }
        this.invokeOnComplete(callback);
    }

    @Override
    public void close(IoCallback callback) {
        this.writer.close();
        if (this.writer.checkError()) {
            callback.onException(this.exchange, this, new IOException());
        } else {
            this.invokeOnComplete(callback);
        }
    }

    @Override
    public void close() {
        if (this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY).getDispatcherType() != DispatcherType.INCLUDE) {
            IoUtils.safeClose((Closeable)this.writer);
        }
        this.writer.checkError();
    }

    private boolean writeBuffer(ByteBuffer buffer, IoCallback callback) {
        StringBuilder builder = new StringBuilder();
        try {
            builder.append(this.charsetDecoder.decode(buffer));
        }
        catch (CharacterCodingException e2) {
            callback.onException(this.exchange, this, e2);
            return false;
        }
        String data2 = builder.toString();
        this.writer.write(data2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeOnComplete(IoCallback callback) {
        this.sendThread = null;
        this.inCall = Thread.currentThread();
        try {
            callback.onComplete(this.exchange, this);
        }
        finally {
            this.inCall = null;
        }
        if (Thread.currentThread() != this.sendThread) {
            return;
        }
        while (this.next != null) {
            String next2 = this.next;
            IoCallback queuedCallback = this.queuedCallback;
            this.next = null;
            this.queuedCallback = null;
            this.writer.write(next2);
            if (this.writer.checkError()) {
                queuedCallback.onException(this.exchange, this, new IOException());
                continue;
            }
            this.sendThread = null;
            this.inCall = Thread.currentThread();
            try {
                queuedCallback.onComplete(this.exchange, this);
            }
            finally {
                this.inCall = null;
            }
            if (Thread.currentThread() == this.sendThread) continue;
            return;
        }
    }

    private void queue(ByteBuffer[] byteBuffers, IoCallback ioCallback) {
        if (this.next != null || this.pendingFile != null) {
            throw UndertowMessages.MESSAGES.dataAlreadyQueued();
        }
        StringBuilder builder = new StringBuilder();
        for (ByteBuffer buffer : byteBuffers) {
            try {
                builder.append(this.charsetDecoder.decode(buffer));
            }
            catch (CharacterCodingException e2) {
                ioCallback.onException(this.exchange, this, e2);
                return;
            }
        }
        this.next = builder.toString();
        this.queuedCallback = ioCallback;
    }

    private void queue(String data2, IoCallback callback) {
        if (this.next != null || this.pendingFile != null) {
            throw UndertowMessages.MESSAGES.dataAlreadyQueued();
        }
        this.next = data2;
        this.queuedCallback = callback;
    }

    private void queue(FileChannel data2, IoCallback callback) {
        if (this.next != null || this.pendingFile != null) {
            throw UndertowMessages.MESSAGES.dataAlreadyQueued();
        }
        this.pendingFile = data2;
        this.queuedCallback = callback;
    }
}

