/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.session;

import io.undertow.server.session.SessionIdGenerator;
import java.security.SecureRandom;

public class SecureRandomSessionIdGenerator
implements SessionIdGenerator {
    private final SecureRandom random = new SecureRandom();
    private volatile int length = 30;
    private static final char[] SESSION_ID_ALPHABET;
    private static final String ALPHABET_PROPERTY = "io.undertow.server.session.SecureRandomSessionIdGenerator.ALPHABET";

    @Override
    public String createSessionId() {
        byte[] bytes2 = new byte[this.length];
        this.random.nextBytes(bytes2);
        return new String(this.encode(bytes2));
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    private char[] encode(byte[] data2) {
        char[] out = new char[(data2.length + 2) / 3 * 4];
        char[] alphabet = SESSION_ID_ALPHABET;
        int i = 0;
        int index2 = 0;
        while (i < data2.length) {
            boolean quad = false;
            boolean trip = false;
            int val2 = 0xFF & data2[i];
            val2 <<= 8;
            if (i + 1 < data2.length) {
                val2 |= 0xFF & data2[i + 1];
                trip = true;
            }
            val2 <<= 8;
            if (i + 2 < data2.length) {
                val2 |= 0xFF & data2[i + 2];
                quad = true;
            }
            out[index2 + 3] = alphabet[quad ? val2 & 0x3F : 63];
            out[index2 + 2] = alphabet[trip ? (val2 >>= 6) & 0x3F : 63];
            out[index2 + 1] = alphabet[(val2 >>= 6) & 0x3F];
            out[index2] = alphabet[(val2 >>= 6) & 0x3F];
            i += 3;
            index2 += 4;
        }
        return out;
    }

    static {
        String alphabet = System.getProperty(ALPHABET_PROPERTY, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_");
        if (alphabet.length() != 64) {
            throw new RuntimeException("io.undertow.server.session.SecureRandomSessionIdGenerator must be exactly 64 characters long");
        }
        SESSION_ID_ALPHABET = alphabet.toCharArray();
    }
}

