/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.server.handlers.proxy.mod_cluster.Balancer;
import io.undertow.server.handlers.proxy.mod_cluster.Context;
import io.undertow.server.handlers.proxy.mod_cluster.Node;
import java.util.concurrent.TimeUnit;

class MCMPInfoUtil {
    private static final String NEWLINE = "\n";

    MCMPInfoUtil() {
    }

    static void printDump(Balancer balancer, StringBuilder builder) {
        builder.append("balancer: [").append(balancer.getId()).append("]").append(" Name: ").append(balancer.getName()).append(" Sticky: ").append(MCMPInfoUtil.toStringOneZero(balancer.isStickySession())).append(" [").append(balancer.getStickySessionCookie()).append("]/[").append(balancer.getStickySessionPath()).append("]").append(" remove: ").append(MCMPInfoUtil.toStringOneZero(balancer.isStickySessionRemove())).append(" force: ").append(MCMPInfoUtil.toStringOneZero(balancer.isStickySessionForce())).append(" Timeout: ").append(balancer.getWaitWorker()).append(" maxAttempts: ").append(balancer.getMaxRetries()).append(NEWLINE);
    }

    static void printInfo(Node.VHostMapping host, StringBuilder builder) {
        for (String alias2 : host.getAliases()) {
            builder.append("Vhost: [").append(host.getNode().getId()).append(":").append(host.getId()).append(":").append(-1).append("], Alias: ").append(alias2).append(NEWLINE);
        }
    }

    static void printDump(Node.VHostMapping host, StringBuilder builder) {
        for (String alias2 : host.getAliases()) {
            builder.append("host: ").append(host.getId()).append(" [").append(alias2).append("]").append(" vhost: ").append(host.getId()).append(" node: ").append(host.getNode().getId()).append(NEWLINE);
        }
    }

    static void printInfo(Context context, StringBuilder builder) {
        builder.append("Context: [").append(context.getNode().getId()).append(":").append(context.getVhost().getId()).append(":").append(context.getId()).append("]").append(", Context: ").append(context.getPath()).append(", Status: ").append((Object)context.getStatus()).append(NEWLINE);
    }

    static void printDump(Context context, StringBuilder builder) {
        builder.append("context: ").append(context.getId()).append(" [").append(context.getPath()).append("]").append(" vhost: ").append(context.getVhost().getId()).append(" node: ").append(context.getNode().getId()).append(" status: ").append(MCMPInfoUtil.formatStatus(context.getStatus())).append(NEWLINE);
    }

    static void printInfo(Node node2, StringBuilder builder) {
        builder.append("Node: ").append("[").append(node2.getId()).append("]").append(",Name: ").append(node2.getJvmRoute()).append(",Balancer: ").append(node2.getNodeConfig().getBalancer()).append(",LBGroup: ").append(MCMPInfoUtil.formatString(node2.getNodeConfig().getDomain())).append(",Host: ").append(node2.getNodeConfig().getConnectionURI().getHost()).append(",Port: ").append(node2.getNodeConfig().getConnectionURI().getPort()).append(",Type: ").append(node2.getNodeConfig().getConnectionURI().getScheme()).append(",Flushpackets: ").append(MCMPInfoUtil.toStringOnOff(node2.getNodeConfig().isFlushPackets())).append(",Flushwait: ").append(node2.getNodeConfig().getFlushwait()).append(",Ping: ").append(node2.getNodeConfig().getPing()).append(",Smax: ").append(node2.getNodeConfig().getSmax()).append(",Ttl: ").append(TimeUnit.MILLISECONDS.toSeconds(node2.getNodeConfig().getTtl())).append(",Elected: ").append(node2.getElected()).append(",Read: ").append(node2.getConnectionPool().getClientStatistics().getRead()).append(",Transfered: ").append(node2.getConnectionPool().getClientStatistics().getWritten()).append(",Connected: ").append(node2.getConnectionPool().getOpenConnections()).append(",Load: ").append(node2.getLoad()).append(NEWLINE);
    }

    static void printDump(Node node2, StringBuilder builder) {
        builder.append("node: [").append(node2.getBalancer().getId()).append(":").append(node2.getId()).append("]").append(",Balancer: ").append(node2.getNodeConfig().getBalancer()).append(",JVMRoute: ").append(node2.getJvmRoute()).append(",LBGroup: [").append(MCMPInfoUtil.formatString(node2.getNodeConfig().getDomain())).append("]").append(",Host: ").append(node2.getNodeConfig().getConnectionURI().getHost()).append(",Port: ").append(node2.getNodeConfig().getConnectionURI().getPort()).append(",Type: ").append(node2.getNodeConfig().getConnectionURI().getScheme()).append(",flushpackets: ").append(MCMPInfoUtil.toStringOneZero(node2.getNodeConfig().isFlushPackets())).append(",flushwait: ").append(node2.getNodeConfig().getFlushwait()).append(",ping: ").append(node2.getNodeConfig().getPing()).append(",smax: ").append(node2.getNodeConfig().getSmax()).append(",ttl: ").append(TimeUnit.MILLISECONDS.toSeconds(node2.getNodeConfig().getTtl())).append(",timeout: ").append(node2.getNodeConfig().getTimeout()).append(NEWLINE);
    }

    static String toStringOneZero(boolean bool) {
        return bool ? "1" : "0";
    }

    static String toStringOnOff(boolean bool) {
        return bool ? "On" : "Off";
    }

    static String formatString(String str2) {
        return str2 == null ? "" : str2;
    }

    static int formatStatus(Context.Status status) {
        return status == Context.Status.ENABLED ? 1 : (status == Context.Status.DISABLED ? 2 : (status == Context.Status.STOPPED ? 3 : -1));
    }
}

