/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.Version;
import io.undertow.io.Sender;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormEncodedDataDefinition;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.handlers.proxy.mod_cluster.Balancer;
import io.undertow.server.handlers.proxy.mod_cluster.Context;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPConfig;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPConstants;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPErrorCode;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPInfoUtil;
import io.undertow.server.handlers.proxy.mod_cluster.ModCluster;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterContainer;
import io.undertow.server.handlers.proxy.mod_cluster.Node;
import io.undertow.server.handlers.proxy.mod_cluster.NodeConfig;
import io.undertow.server.handlers.proxy.mod_cluster.NodePingUtil;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.ssl.XnioSsl;

class MCMPHandler
implements HttpHandler {
    public static final HttpString CONFIG = new HttpString("CONFIG");
    public static final HttpString ENABLE_APP = new HttpString("ENABLE-APP");
    public static final HttpString DISABLE_APP = new HttpString("DISABLE-APP");
    public static final HttpString STOP_APP = new HttpString("STOP-APP");
    public static final HttpString REMOVE_APP = new HttpString("REMOVE-APP");
    public static final HttpString STATUS = new HttpString("STATUS");
    public static final HttpString DUMP = new HttpString("DUMP");
    public static final HttpString INFO = new HttpString("INFO");
    public static final HttpString PING = new HttpString("PING");
    private static final Set<HttpString> HANDLED_METHODS = Collections.unmodifiableSet(new HashSet<HttpString>(Arrays.asList(CONFIG, ENABLE_APP, DISABLE_APP, STOP_APP, REMOVE_APP, STATUS, INFO, DUMP, PING)));
    protected static final String VERSION_PROTOCOL = "0.2.1";
    protected static final String MOD_CLUSTER_EXPOSED_VERSION = "mod_cluster_undertow/" + Version.getVersionString();
    private static final String CONTENT_TYPE = "text/plain; charset=ISO-8859-1";
    private static final String TYPESYNTAX = "SYNTAX";
    private static final String SCONBAD = "SYNTAX: Context without Alias";
    private static final String SBADFLD = "SYNTAX: Invalid field ";
    private static final String SBADFLD1 = " in message";
    private static final String SMISFLD = "SYNTAX: Mandatory field(s) missing in message";
    private final FormParserFactory parserFactory;
    private final MCMPConfig config;
    private final HttpHandler next;
    private final long creationTime = System.currentTimeMillis();
    private final ModCluster modCluster;
    protected final ModClusterContainer container;

    MCMPHandler(MCMPConfig config, ModCluster modCluster, HttpHandler next2) {
        this.config = config;
        this.next = next2;
        this.modCluster = modCluster;
        this.container = modCluster.getContainer();
        this.parserFactory = FormParserFactory.builder(false).addParser(new FormEncodedDataDefinition().setForceCreation(true)).build();
        UndertowLogger.ROOT_LOGGER.mcmpHandlerCreated();
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        HttpString method = exchange.getRequestMethod();
        if (!this.handlesMethod(method)) {
            this.next.handleRequest(exchange);
            return;
        }
        InetSocketAddress addr = exchange.getConnection().getLocalAddress(InetSocketAddress.class);
        if (!addr.isUnresolved() && addr.getPort() != this.config.getManagementSocketAddress().getPort() || !Arrays.equals(addr.getAddress().getAddress(), this.config.getManagementSocketAddress().getAddress().getAddress())) {
            this.next.handleRequest(exchange);
            return;
        }
        if (exchange.isInIoThread()) {
            exchange.dispatch(this);
            return;
        }
        try {
            this.handleRequest(method, exchange);
        }
        catch (Exception e2) {
            UndertowLogger.ROOT_LOGGER.failedToProcessManagementReq(e2);
            exchange.setStatusCode(500);
            exchange.getResponseHeaders().add(Headers.CONTENT_TYPE, CONTENT_TYPE);
            Sender sender = exchange.getResponseSender();
            sender.send("failed to process management request");
        }
    }

    protected boolean handlesMethod(HttpString method) {
        return HANDLED_METHODS.contains(method);
    }

    protected void handleRequest(HttpString method, HttpServerExchange exchange) throws Exception {
        RequestData requestData = this.parseFormData(exchange);
        boolean persistent = exchange.isPersistent();
        exchange.setPersistent(false);
        if (CONFIG.equals(method)) {
            this.processConfig(exchange, requestData);
        } else if (ENABLE_APP.equals(method)) {
            this.processCommand(exchange, requestData, MCMPAction.ENABLE);
        } else if (DISABLE_APP.equals(method)) {
            this.processCommand(exchange, requestData, MCMPAction.DISABLE);
        } else if (STOP_APP.equals(method)) {
            this.processCommand(exchange, requestData, MCMPAction.STOP);
        } else if (REMOVE_APP.equals(method)) {
            this.processCommand(exchange, requestData, MCMPAction.REMOVE);
        } else if (STATUS.equals(method)) {
            this.processStatus(exchange, requestData);
        } else if (INFO.equals(method)) {
            this.processInfo(exchange);
        } else if (DUMP.equals(method)) {
            this.processDump(exchange);
        } else if (PING.equals(method)) {
            this.processPing(exchange, requestData);
        } else {
            exchange.setPersistent(persistent);
            this.next.handleRequest(exchange);
        }
    }

    private void processConfig(HttpServerExchange exchange, RequestData requestData) {
        List<String> hosts = null;
        List<String> contexts = null;
        Balancer.BalancerBuilder balancer = Balancer.builder();
        NodeConfig.NodeBuilder node2 = NodeConfig.builder(this.modCluster);
        Iterator<HttpString> i = requestData.iterator();
        while (i.hasNext()) {
            HttpString name2 = i.next();
            String value = requestData.getFirst(name2);
            UndertowLogger.ROOT_LOGGER.mcmpKeyValue(name2, value);
            if (!MCMPHandler.checkString(value)) {
                MCMPHandler.processError(TYPESYNTAX, SBADFLD + name2 + SBADFLD1, exchange);
                return;
            }
            if (MCMPConstants.BALANCER.equals(name2)) {
                node2.setBalancer(value);
                balancer.setName(value);
                continue;
            }
            if (MCMPConstants.MAXATTEMPTS.equals(name2)) {
                balancer.setMaxRetries(Integer.parseInt(value));
                continue;
            }
            if (MCMPConstants.STICKYSESSION.equals(name2)) {
                if (!"No".equalsIgnoreCase(value)) continue;
                balancer.setStickySession(false);
                continue;
            }
            if (MCMPConstants.STICKYSESSIONCOOKIE.equals(name2)) {
                balancer.setStickySessionCookie(value);
                continue;
            }
            if (MCMPConstants.STICKYSESSIONPATH.equals(name2)) {
                balancer.setStickySessionPath(value);
                continue;
            }
            if (MCMPConstants.STICKYSESSIONREMOVE.equals(name2)) {
                if (!"Yes".equalsIgnoreCase(value)) continue;
                balancer.setStickySessionRemove(true);
                continue;
            }
            if (MCMPConstants.STICKYSESSIONFORCE.equals(name2)) {
                if (!"no".equalsIgnoreCase(value)) continue;
                balancer.setStickySessionForce(false);
                continue;
            }
            if (MCMPConstants.JVMROUTE.equals(name2)) {
                node2.setJvmRoute(value);
                continue;
            }
            if (MCMPConstants.DOMAIN.equals(name2)) {
                node2.setDomain(value);
                continue;
            }
            if (MCMPConstants.HOST.equals(name2)) {
                node2.setHostname(value);
                continue;
            }
            if (MCMPConstants.PORT.equals(name2)) {
                node2.setPort(Integer.parseInt(value));
                continue;
            }
            if (MCMPConstants.TYPE.equals(name2)) {
                node2.setType(value);
                continue;
            }
            if (MCMPConstants.REVERSED.equals(name2)) continue;
            if (MCMPConstants.FLUSH_PACKET.equals(name2)) {
                if ("on".equalsIgnoreCase(value)) {
                    node2.setFlushPackets(true);
                    continue;
                }
                if (!"auto".equalsIgnoreCase(value)) continue;
                node2.setFlushPackets(true);
                continue;
            }
            if (MCMPConstants.FLUSH_WAIT.equals(name2)) {
                node2.setFlushwait(Integer.parseInt(value));
                continue;
            }
            if (MCMPConstants.PING.equals(name2)) {
                node2.setPing(Integer.parseInt(value));
                continue;
            }
            if (MCMPConstants.SMAX.equals(name2)) {
                node2.setSmax(Integer.parseInt(value));
                continue;
            }
            if (MCMPConstants.TTL.equals(name2)) {
                node2.setTtl(TimeUnit.SECONDS.toMillis(Long.parseLong(value)));
                continue;
            }
            if (MCMPConstants.TIMEOUT.equals(name2)) {
                node2.setTimeout(Integer.parseInt(value));
                continue;
            }
            if (MCMPConstants.CONTEXT.equals(name2)) {
                String[] stringArray = value.split(",");
                contexts = Arrays.asList(stringArray);
                continue;
            }
            if (MCMPConstants.ALIAS.equals(name2)) {
                String[] stringArray = value.split(",");
                hosts = Arrays.asList(stringArray);
                continue;
            }
            if (MCMPConstants.WAITWORKER.equals(name2)) {
                node2.setWaitWorker(Integer.parseInt(value));
                continue;
            }
            MCMPHandler.processError(TYPESYNTAX, SBADFLD + name2 + SBADFLD1, exchange);
            return;
        }
        try {
            NodeConfig config = node2.build();
            if (this.container.addNode(config, balancer, exchange.getIoThread(), exchange.getConnection().getByteBufferPool())) {
                if (contexts != null && hosts != null) {
                    for (String string2 : contexts) {
                        this.container.enableContext(string2, config.getJvmRoute(), hosts);
                    }
                }
                MCMPHandler.processOK(exchange);
            } else {
                MCMPHandler.processError(MCMPErrorCode.NODE_STILL_EXISTS, exchange);
            }
        }
        catch (Exception e2) {
            MCMPHandler.processError(MCMPErrorCode.CANT_UPDATE_NODE, exchange);
        }
    }

    void processCommand(HttpServerExchange exchange, RequestData requestData, MCMPAction action) throws IOException {
        if (exchange.getRequestPath().equals("*") || exchange.getRequestPath().endsWith("/*")) {
            this.processNodeCommand(exchange, requestData, action);
        } else {
            this.processAppCommand(exchange, requestData, action);
        }
    }

    void processNodeCommand(HttpServerExchange exchange, RequestData requestData, MCMPAction action) throws IOException {
        String jvmRoute = requestData.getFirst(MCMPConstants.JVMROUTE);
        if (jvmRoute == null) {
            MCMPHandler.processError(TYPESYNTAX, SMISFLD, exchange);
            return;
        }
        if (this.processNodeCommand(jvmRoute, action)) {
            MCMPHandler.processOK(exchange);
        } else {
            MCMPHandler.processError(MCMPErrorCode.CANT_UPDATE_NODE, exchange);
        }
    }

    boolean processNodeCommand(String jvmRoute, MCMPAction action) throws IOException {
        switch (action) {
            case ENABLE: {
                return this.container.enableNode(jvmRoute);
            }
            case DISABLE: {
                return this.container.disableNode(jvmRoute);
            }
            case STOP: {
                return this.container.stopNode(jvmRoute);
            }
            case REMOVE: {
                return this.container.removeNode(jvmRoute) != null;
            }
        }
        return false;
    }

    void processAppCommand(HttpServerExchange exchange, RequestData requestData, MCMPAction action) throws IOException {
        String contextPath = requestData.getFirst(MCMPConstants.CONTEXT);
        String jvmRoute = requestData.getFirst(MCMPConstants.JVMROUTE);
        String aliases = requestData.getFirst(MCMPConstants.ALIAS);
        if (contextPath == null || jvmRoute == null || aliases == null) {
            MCMPHandler.processError(TYPESYNTAX, SMISFLD, exchange);
            return;
        }
        List<String> virtualHosts = Arrays.asList(aliases.split(","));
        if (virtualHosts == null || virtualHosts.isEmpty()) {
            MCMPHandler.processError(TYPESYNTAX, SCONBAD, exchange);
            return;
        }
        String response = null;
        switch (action) {
            case ENABLE: {
                if (this.container.enableContext(contextPath, jvmRoute, virtualHosts)) break;
                MCMPHandler.processError(MCMPErrorCode.CANT_UPDATE_CONTEXT, exchange);
                return;
            }
            case DISABLE: {
                if (this.container.disableContext(contextPath, jvmRoute, virtualHosts)) break;
                MCMPHandler.processError(MCMPErrorCode.CANT_UPDATE_CONTEXT, exchange);
                return;
            }
            case STOP: {
                int i = this.container.stopContext(contextPath, jvmRoute, virtualHosts);
                StringBuilder builder = new StringBuilder();
                builder.append("Type=STOP-APP-RSP,JvmRoute=").append(jvmRoute);
                builder.append("Alias=").append(aliases);
                builder.append("Context=").append(contextPath);
                builder.append("Requests=").append(i);
                response = builder.toString();
                break;
            }
            case REMOVE: {
                if (this.container.removeContext(contextPath, jvmRoute, virtualHosts)) break;
                MCMPHandler.processError(MCMPErrorCode.CANT_UPDATE_CONTEXT, exchange);
                return;
            }
            default: {
                MCMPHandler.processError(TYPESYNTAX, SMISFLD, exchange);
                return;
            }
        }
        if (response != null) {
            MCMPHandler.sendResponse(exchange, response);
        } else {
            MCMPHandler.processOK(exchange);
        }
    }

    void processStatus(final HttpServerExchange exchange, RequestData requestData) throws IOException {
        final String jvmRoute = requestData.getFirst(MCMPConstants.JVMROUTE);
        String loadValue = requestData.getFirst(MCMPConstants.LOAD);
        if (loadValue == null || jvmRoute == null) {
            MCMPHandler.processError(TYPESYNTAX, SMISFLD, exchange);
            return;
        }
        UndertowLogger.ROOT_LOGGER.receivedNodeLoad(jvmRoute, loadValue);
        final int load2 = Integer.parseInt(loadValue);
        if (load2 > 0 || load2 == -2) {
            final Node node2 = this.container.getNode(jvmRoute);
            if (node2 == null) {
                MCMPHandler.processError(MCMPErrorCode.CANT_READ_NODE, exchange);
                return;
            }
            NodePingUtil.PingCallback callback = new NodePingUtil.PingCallback(){

                @Override
                public void completed() {
                    String response = "Type=STATUS-RSP&State=OK&JVMRoute=" + jvmRoute + "&id=" + MCMPHandler.this.creationTime;
                    try {
                        if (load2 > 0) {
                            node2.updateLoad(load2);
                        }
                        MCMPHandler.sendResponse(exchange, response);
                    }
                    catch (Exception e2) {
                        UndertowLogger.ROOT_LOGGER.failedToSendPingResponse(e2);
                    }
                }

                @Override
                public void failed() {
                    String response = "Type=STATUS-RSP&State=NOTOK&JVMRoute=" + jvmRoute + "&id=" + MCMPHandler.this.creationTime;
                    try {
                        node2.markInError();
                        MCMPHandler.sendResponse(exchange, response);
                    }
                    catch (Exception e2) {
                        UndertowLogger.ROOT_LOGGER.failedToSendPingResponseDBG(e2, node2.getJvmRoute(), jvmRoute);
                    }
                }
            };
            node2.ping(exchange, callback);
        } else if (load2 == 0) {
            Node node3 = this.container.getNode(jvmRoute);
            if (node3 != null) {
                node3.hotStandby();
                MCMPHandler.sendResponse(exchange, "Type=STATUS-RSP&State=OK&JVMRoute=" + jvmRoute + "&id=" + this.creationTime);
            } else {
                MCMPHandler.processError(MCMPErrorCode.CANT_READ_NODE, exchange);
            }
        } else if (load2 == -1) {
            Node node4 = this.container.getNode(jvmRoute);
            if (node4 != null) {
                node4.markInError();
                MCMPHandler.sendResponse(exchange, "Type=STATUS-RSP&State=NOTOK&JVMRoute=" + jvmRoute + "&id=" + this.creationTime);
            } else {
                MCMPHandler.processError(MCMPErrorCode.CANT_READ_NODE, exchange);
            }
        } else {
            MCMPHandler.processError(TYPESYNTAX, SMISFLD, exchange);
        }
    }

    void processPing(final HttpServerExchange exchange, RequestData requestData) throws IOException {
        Node nodeConfig;
        String jvmRoute = requestData.getFirst(MCMPConstants.JVMROUTE);
        String scheme = requestData.getFirst(MCMPConstants.SCHEME);
        String host = requestData.getFirst(MCMPConstants.HOST);
        String port = requestData.getFirst(MCMPConstants.PORT);
        final String OK = "Type=PING-RSP&State=OK&id=" + this.creationTime;
        final String NOTOK = "Type=PING-RSP&State=NOTOK&id=" + this.creationTime;
        if (jvmRoute != null) {
            nodeConfig = this.container.getNode(jvmRoute);
            if (nodeConfig == null) {
                MCMPHandler.sendResponse(exchange, NOTOK);
                return;
            }
        } else {
            if (scheme == null && host == null && port == null) {
                MCMPHandler.sendResponse(exchange, OK);
                return;
            }
            if (host == null || port == null) {
                MCMPHandler.processError(TYPESYNTAX, SMISFLD, exchange);
                return;
            }
            this.checkHostUp(scheme, host, Integer.parseInt(port), exchange, new NodePingUtil.PingCallback(){

                @Override
                public void completed() {
                    MCMPHandler.sendResponse(exchange, OK);
                }

                @Override
                public void failed() {
                    MCMPHandler.sendResponse(exchange, NOTOK);
                }
            });
            return;
        }
        NodePingUtil.PingCallback callback = new NodePingUtil.PingCallback(){

            @Override
            public void completed() {
                try {
                    MCMPHandler.sendResponse(exchange, OK);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }

            @Override
            public void failed() {
                try {
                    nodeConfig.markInError();
                    MCMPHandler.sendResponse(exchange, NOTOK);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        };
        nodeConfig.ping(exchange, callback);
    }

    protected void processInfo(HttpServerExchange exchange) throws IOException {
        String data2 = this.processInfoString();
        exchange.getResponseHeaders().add(Headers.SERVER, MOD_CLUSTER_EXPOSED_VERSION);
        MCMPHandler.sendResponse(exchange, data2);
    }

    protected String processInfoString() {
        StringBuilder builder = new StringBuilder();
        ArrayList<Node.VHostMapping> vHosts = new ArrayList<Node.VHostMapping>();
        ArrayList<Context> contexts = new ArrayList<Context>();
        Collection<Node> nodes = this.container.getNodes();
        for (Node node2 : nodes) {
            MCMPInfoUtil.printInfo(node2, builder);
            vHosts.addAll(node2.getVHosts());
            contexts.addAll(node2.getContexts());
        }
        for (Node.VHostMapping vHost : vHosts) {
            MCMPInfoUtil.printInfo(vHost, builder);
        }
        for (Context context : contexts) {
            MCMPInfoUtil.printInfo(context, builder);
        }
        return builder.toString();
    }

    protected void processDump(HttpServerExchange exchange) throws IOException {
        String data2 = this.processDumpString();
        exchange.getResponseHeaders().add(Headers.SERVER, MOD_CLUSTER_EXPOSED_VERSION);
        MCMPHandler.sendResponse(exchange, data2);
    }

    protected String processDumpString() {
        StringBuilder builder = new StringBuilder();
        Collection<Balancer> balancers = this.container.getBalancers();
        for (Balancer balancer : balancers) {
            MCMPInfoUtil.printDump(balancer, builder);
        }
        ArrayList<Node.VHostMapping> vHosts = new ArrayList<Node.VHostMapping>();
        ArrayList<Context> contexts = new ArrayList<Context>();
        Collection<Node> nodes = this.container.getNodes();
        for (Node node2 : nodes) {
            MCMPInfoUtil.printDump(node2, builder);
            vHosts.addAll(node2.getVHosts());
            contexts.addAll(node2.getContexts());
        }
        for (Node.VHostMapping vHost : vHosts) {
            MCMPInfoUtil.printDump(vHost, builder);
        }
        for (Context context : contexts) {
            MCMPInfoUtil.printDump(context, builder);
        }
        return builder.toString();
    }

    protected void checkHostUp(String scheme, String host, int port, HttpServerExchange exchange, NodePingUtil.PingCallback callback) {
        XnioSsl xnioSsl = null;
        OptionMap options = OptionMap.builder().set(Options.TCP_NODELAY, true).getMap();
        try {
            if ("ajp".equalsIgnoreCase(scheme) || "http".equalsIgnoreCase(scheme)) {
                URI uri = new URI(scheme, null, host, port, "/", null, null);
                NodePingUtil.pingHttpClient(uri, callback, exchange, this.container.getClient(), xnioSsl, options);
            } else {
                InetSocketAddress address = new InetSocketAddress(host, port);
                NodePingUtil.pingHost(address, exchange, callback, options);
            }
        }
        catch (URISyntaxException e2) {
            callback.failed();
        }
    }

    static void sendResponse(HttpServerExchange exchange, String response) {
        exchange.setStatusCode(200);
        exchange.getResponseHeaders().add(Headers.CONTENT_TYPE, CONTENT_TYPE);
        Sender sender = exchange.getResponseSender();
        UndertowLogger.ROOT_LOGGER.mcmpSendingResponse(exchange.getSourceAddress(), exchange.getStatusCode(), exchange.getResponseHeaders(), response);
        sender.send(response);
    }

    static void processOK(HttpServerExchange exchange) throws IOException {
        exchange.setStatusCode(200);
        exchange.getResponseHeaders().add(Headers.CONTENT_TYPE, CONTENT_TYPE);
        exchange.endExchange();
    }

    static void processError(MCMPErrorCode errorCode, HttpServerExchange exchange) {
        MCMPHandler.processError(errorCode.getType(), errorCode.getMessage(), exchange);
    }

    static void processError(String type2, String errString, HttpServerExchange exchange) {
        exchange.setStatusCode(500);
        exchange.getResponseHeaders().add(Headers.CONTENT_TYPE, CONTENT_TYPE);
        exchange.getResponseHeaders().add(new HttpString("Version"), VERSION_PROTOCOL);
        exchange.getResponseHeaders().add(new HttpString("Type"), type2);
        exchange.getResponseHeaders().add(new HttpString("Mess"), errString);
        exchange.endExchange();
        UndertowLogger.ROOT_LOGGER.mcmpProcessingError(type2, errString);
    }

    RequestData parseFormData(HttpServerExchange exchange) throws IOException {
        FormDataParser parser = this.parserFactory.createParser(exchange);
        FormData formData = parser.parseBlocking();
        RequestData data2 = new RequestData();
        for (String name2 : formData) {
            HttpString key2 = new HttpString(name2);
            data2.add(key2, formData.get(name2));
        }
        return data2;
    }

    private static void checkStringForSuspiciousCharacters(String data2) {
        for (int i = 0; i < data2.length(); ++i) {
            char c = data2.charAt(i);
            if (c != '>' && c != '<' && c != '\\' && c != '\"' && c != '\n' && c != '\r') continue;
            throw UndertowMessages.MESSAGES.mcmpMessageRejectedDueToSuspiciousCharacters(data2);
        }
    }

    static boolean checkString(String value) {
        return value != null && value.length() > 0;
    }

    static class RequestData {
        private final Map<HttpString, Deque<String>> values = new LinkedHashMap<HttpString, Deque<String>>();

        RequestData() {
        }

        Iterator<HttpString> iterator() {
            return this.values.keySet().iterator();
        }

        void add(HttpString name2, Deque<FormData.FormValue> values) {
            MCMPHandler.checkStringForSuspiciousCharacters(name2.toString());
            for (FormData.FormValue value : values) {
                this.add(name2, value);
            }
        }

        void addValues(HttpString name2, Deque<String> value) {
            Deque<String> values = this.values.get(name2);
            for (String i : value) {
                MCMPHandler.checkStringForSuspiciousCharacters(i);
            }
            if (values == null) {
                this.values.put(name2, value);
            } else {
                values.addAll(value);
            }
        }

        void add(HttpString name2, FormData.FormValue value) {
            Deque<String> values = this.values.get(name2);
            if (values == null) {
                values = new ArrayDeque<String>(1);
                this.values.put(name2, values);
            }
            String stringVal = value.getValue();
            MCMPHandler.checkStringForSuspiciousCharacters(stringVal);
            values.add(stringVal);
        }

        String getFirst(HttpString name2) {
            Deque<String> deque = this.values.get(name2);
            return deque == null ? null : deque.peekFirst();
        }
    }

    static enum MCMPAction {
        ENABLE,
        DISABLE,
        STOP,
        REMOVE;

    }
}

