/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.builder;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeParser;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.predicate.Predicates;
import io.undertow.predicate.PredicatesHandler;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.server.handlers.builder.PredicatedHandler;
import io.undertow.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public class PredicatedHandlersParser {
    public static final String ELSE = "else";
    public static final String ARROW = "->";
    public static final String NOT = "not";
    public static final String OR = "or";
    public static final String AND = "and";
    public static final String TRUE = "true";
    public static final String FALSE = "false";

    public static List<PredicatedHandler> parse(File file2, ClassLoader classLoader) {
        return PredicatedHandlersParser.parse(file2.toPath(), classLoader);
    }

    public static List<PredicatedHandler> parse(Path file2, ClassLoader classLoader) {
        try {
            return PredicatedHandlersParser.parse(new String(Files.readAllBytes(file2), StandardCharsets.UTF_8), classLoader);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static List<PredicatedHandler> parse(InputStream inputStream, ClassLoader classLoader) {
        return PredicatedHandlersParser.parse(FileUtils.readFile(inputStream), classLoader);
    }

    public static List<PredicatedHandler> parse(String contents, ClassLoader classLoader) {
        Deque<Token> tokens = PredicatedHandlersParser.tokenize(contents);
        Node node2 = PredicatedHandlersParser.parse(contents, tokens);
        Map<String, PredicateBuilder> predicateBuilders = PredicatedHandlersParser.loadPredicateBuilders(classLoader);
        Map<String, HandlerBuilder> handlerBuilders = PredicatedHandlersParser.loadHandlerBuilders(classLoader);
        ExchangeAttributeParser attributeParser = ExchangeAttributes.parser(classLoader);
        return PredicatedHandlersParser.handleNode(contents, node2, predicateBuilders, handlerBuilders, attributeParser);
    }

    public static Predicate parsePredicate(String string2, ClassLoader classLoader) {
        Deque<Token> tokens = PredicatedHandlersParser.tokenize(string2);
        Node node2 = PredicatedHandlersParser.parse(string2, tokens);
        Map<String, PredicateBuilder> predicateBuilders = PredicatedHandlersParser.loadPredicateBuilders(classLoader);
        ExchangeAttributeParser attributeParser = ExchangeAttributes.parser(classLoader);
        return PredicatedHandlersParser.handlePredicateNode(string2, node2, predicateBuilders, attributeParser);
    }

    public static HandlerWrapper parseHandler(String string2, ClassLoader classLoader) {
        Deque<Token> tokens = PredicatedHandlersParser.tokenize(string2);
        Node node2 = PredicatedHandlersParser.parse(string2, tokens);
        Map<String, HandlerBuilder> handlerBuilders = PredicatedHandlersParser.loadHandlerBuilders(classLoader);
        ExchangeAttributeParser attributeParser = ExchangeAttributes.parser(classLoader);
        return PredicatedHandlersParser.handleHandlerNode(string2, (ExpressionNode)node2, handlerBuilders, attributeParser);
    }

    private static List<PredicatedHandler> handleNode(String contents, Node node2, Map<String, PredicateBuilder> predicateBuilders, Map<String, HandlerBuilder> handlerBuilders, ExchangeAttributeParser attributeParser) {
        if (node2 instanceof BlockNode) {
            return PredicatedHandlersParser.handleBlockNode(contents, (BlockNode)node2, predicateBuilders, handlerBuilders, attributeParser);
        }
        if (node2 instanceof ExpressionNode) {
            HandlerWrapper handler = PredicatedHandlersParser.handleHandlerNode(contents, (ExpressionNode)node2, handlerBuilders, attributeParser);
            return Collections.singletonList(new PredicatedHandler(Predicates.truePredicate(), handler));
        }
        if (node2 instanceof PredicateOperatorNode) {
            return Collections.singletonList(PredicatedHandlersParser.handlePredicateOperatorNode(contents, (PredicateOperatorNode)node2, predicateBuilders, handlerBuilders, attributeParser));
        }
        throw PredicatedHandlersParser.error(contents, node2.getToken().getPosition(), "unexpected token " + node2.getToken());
    }

    private static PredicatedHandler handlePredicateOperatorNode(String contents, PredicateOperatorNode node2, Map<String, PredicateBuilder> predicateBuilders, Map<String, HandlerBuilder> handlerBuilders, ExchangeAttributeParser parser) {
        Predicate predicate = PredicatedHandlersParser.handlePredicateNode(contents, node2.getLeft(), predicateBuilders, parser);
        HandlerWrapper ret = PredicatedHandlersParser.handlePredicatedAction(contents, node2.getRight(), predicateBuilders, handlerBuilders, parser);
        HandlerWrapper elseBranch = null;
        if (node2.getElseBranch() != null) {
            elseBranch = PredicatedHandlersParser.handlePredicatedAction(contents, node2.getElseBranch(), predicateBuilders, handlerBuilders, parser);
        }
        return new PredicatedHandler(predicate, ret, elseBranch);
    }

    private static HandlerWrapper handlePredicatedAction(String contents, Node node2, Map<String, PredicateBuilder> predicateBuilders, Map<String, HandlerBuilder> handlerBuilders, ExchangeAttributeParser parser) {
        if (node2 instanceof ExpressionNode) {
            return PredicatedHandlersParser.handleHandlerNode(contents, (ExpressionNode)node2, handlerBuilders, parser);
        }
        if (node2 instanceof BlockNode) {
            List<PredicatedHandler> handlers = PredicatedHandlersParser.handleBlockNode(contents, (BlockNode)node2, predicateBuilders, handlerBuilders, parser);
            return new PredicatesHandler.Wrapper(handlers, false);
        }
        throw PredicatedHandlersParser.error(contents, node2.getToken().getPosition(), "unexpected token " + node2.getToken());
    }

    private static List<PredicatedHandler> handleBlockNode(String contents, BlockNode node2, Map<String, PredicateBuilder> predicateBuilders, Map<String, HandlerBuilder> handlerBuilders, ExchangeAttributeParser parser) {
        ArrayList<PredicatedHandler> ret = new ArrayList<PredicatedHandler>();
        for (Node line : node2.getBlock()) {
            ret.addAll(PredicatedHandlersParser.handleNode(contents, line, predicateBuilders, handlerBuilders, parser));
        }
        return ret;
    }

    private static HandlerWrapper handleHandlerNode(String contents, ExpressionNode node2, Map<String, HandlerBuilder> handlerBuilders, ExchangeAttributeParser parser) {
        Token token = node2.getToken();
        HandlerBuilder builder = handlerBuilders.get(token.getToken());
        if (builder == null) {
            throw PredicatedHandlersParser.error(contents, token.getPosition(), "no handler named " + token.getToken() + " known handlers are " + handlerBuilders.keySet());
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (Map.Entry<String, Node> val2 : node2.getValues().entrySet()) {
            Class<?> type2;
            String name2 = val2.getKey();
            if (name2 == null) {
                if (builder.defaultParameter() == null) {
                    throw PredicatedHandlersParser.error(contents, token.getPosition(), "default parameter not supported");
                }
                name2 = builder.defaultParameter();
            }
            if ((type2 = builder.parameters().get(name2)) == null) {
                throw PredicatedHandlersParser.error(contents, val2.getValue().getToken().getPosition(), "unknown parameter " + name2);
            }
            if (val2.getValue() instanceof ValueNode) {
                parameters.put(name2, PredicatedHandlersParser.coerceToType(contents, val2.getValue().getToken(), type2, parser));
                continue;
            }
            if (val2.getValue() instanceof ArrayNode) {
                parameters.put(name2, PredicatedHandlersParser.readArrayType(contents, name2, (ArrayNode)val2.getValue(), parser, type2));
                continue;
            }
            throw PredicatedHandlersParser.error(contents, val2.getValue().getToken().getPosition(), "unexpected node " + val2.getValue());
        }
        return builder.build(parameters);
    }

    private static Predicate handlePredicateNode(String contents, Node node2, Map<String, PredicateBuilder> handlerBuilders, ExchangeAttributeParser parser) {
        if (node2 instanceof AndNode) {
            AndNode andNode = (AndNode)node2;
            return Predicates.and(PredicatedHandlersParser.handlePredicateNode(contents, andNode.getLeft(), handlerBuilders, parser), PredicatedHandlersParser.handlePredicateNode(contents, andNode.getRight(), handlerBuilders, parser));
        }
        if (node2 instanceof OrNode) {
            OrNode orNode = (OrNode)node2;
            return Predicates.or(PredicatedHandlersParser.handlePredicateNode(contents, orNode.getLeft(), handlerBuilders, parser), PredicatedHandlersParser.handlePredicateNode(contents, orNode.getRight(), handlerBuilders, parser));
        }
        if (node2 instanceof NotNode) {
            NotNode orNode = (NotNode)node2;
            return Predicates.not(PredicatedHandlersParser.handlePredicateNode(contents, orNode.getNode(), handlerBuilders, parser));
        }
        if (node2 instanceof ExpressionNode) {
            return PredicatedHandlersParser.handlePredicateExpressionNode(contents, (ExpressionNode)node2, handlerBuilders, parser);
        }
        if (node2 instanceof OperatorNode) {
            switch (node2.getToken().getToken()) {
                case "true": {
                    return Predicates.truePredicate();
                }
                case "false": {
                    return Predicates.falsePredicate();
                }
            }
        }
        throw PredicatedHandlersParser.error(contents, node2.getToken().getPosition(), "unexpected node " + node2);
    }

    private static Predicate handlePredicateExpressionNode(String contents, ExpressionNode node2, Map<String, PredicateBuilder> handlerBuilders, ExchangeAttributeParser parser) {
        Token token = node2.getToken();
        PredicateBuilder builder = handlerBuilders.get(token.getToken());
        if (builder == null) {
            throw PredicatedHandlersParser.error(contents, token.getPosition(), "no predicate named " + token.getToken() + " known predicates are " + handlerBuilders.keySet());
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (Map.Entry<String, Node> val2 : node2.getValues().entrySet()) {
            Class<?> type2;
            String name2 = val2.getKey();
            if (name2 == null) {
                if (builder.defaultParameter() == null) {
                    throw PredicatedHandlersParser.error(contents, token.getPosition(), "default parameter not supported");
                }
                name2 = builder.defaultParameter();
            }
            if ((type2 = builder.parameters().get(name2)) == null) {
                throw PredicatedHandlersParser.error(contents, val2.getValue().getToken().getPosition(), "unknown parameter " + name2);
            }
            if (val2.getValue() instanceof ValueNode) {
                parameters.put(name2, PredicatedHandlersParser.coerceToType(contents, val2.getValue().getToken(), type2, parser));
                continue;
            }
            if (val2.getValue() instanceof ArrayNode) {
                parameters.put(name2, PredicatedHandlersParser.readArrayType(contents, name2, (ArrayNode)val2.getValue(), parser, type2));
                continue;
            }
            throw PredicatedHandlersParser.error(contents, val2.getValue().getToken().getPosition(), "unexpected node " + val2.getValue());
        }
        return builder.build(parameters);
    }

    private static Object readArrayType(String string2, String paramName, ArrayNode value, ExchangeAttributeParser parser, Class type2) {
        if (!type2.isArray()) {
            throw PredicatedHandlersParser.error(string2, value.getToken().getPosition(), "parameter is not an array type " + paramName);
        }
        Class<?> componentType = type2.getComponentType();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Token token : value.getValues()) {
            values.add(PredicatedHandlersParser.coerceToType(string2, token, componentType, parser));
        }
        Object array2 = Array.newInstance(componentType, values.size());
        for (int i = 0; i < values.size(); ++i) {
            Array.set(array2, i, values.get(i));
        }
        return array2;
    }

    private static Object coerceToType(String string2, Token token, Class<?> type2, ExchangeAttributeParser attributeParser) {
        if (type2.isArray()) {
            Object array2 = Array.newInstance(type2.getComponentType(), 1);
            Array.set(array2, 0, PredicatedHandlersParser.coerceToType(string2, token, type2.getComponentType(), attributeParser));
            return array2;
        }
        if (type2 == String.class) {
            return token.getToken();
        }
        if (type2.equals(Boolean.class) || type2.equals(Boolean.TYPE)) {
            return Boolean.valueOf(token.getToken());
        }
        if (type2.equals(Byte.class) || type2.equals(Byte.TYPE)) {
            return Byte.valueOf(token.getToken());
        }
        if (type2.equals(Character.class) || type2.equals(Character.TYPE)) {
            if (token.getToken().length() != 1) {
                throw PredicatedHandlersParser.error(string2, token.getPosition(), "Cannot coerce " + token.getToken() + " to a Character");
            }
            return Character.valueOf(token.getToken().charAt(0));
        }
        if (type2.equals(Short.class) || type2.equals(Short.TYPE)) {
            return Short.valueOf(token.getToken());
        }
        if (type2.equals(Integer.class) || type2.equals(Integer.TYPE)) {
            return Integer.valueOf(token.getToken());
        }
        if (type2.equals(Long.class) || type2.equals(Long.TYPE)) {
            return Long.valueOf(token.getToken());
        }
        if (type2.equals(Float.class) || type2.equals(Float.TYPE)) {
            return Float.valueOf(token.getToken());
        }
        if (type2.equals(Double.class) || type2.equals(Double.TYPE)) {
            return Double.valueOf(token.getToken());
        }
        if (type2.equals(ExchangeAttribute.class)) {
            return attributeParser.parse(token.getToken());
        }
        return token.getToken();
    }

    private static Map<String, PredicateBuilder> loadPredicateBuilders(ClassLoader classLoader) {
        ServiceLoader<PredicateBuilder> loader = ServiceLoader.load(PredicateBuilder.class, classLoader);
        HashMap<String, PredicateBuilder> ret = new HashMap<String, PredicateBuilder>();
        for (PredicateBuilder builder : loader) {
            if (ret.containsKey(builder.name())) {
                if (((PredicateBuilder)ret.get(builder.name())).getClass() == builder.getClass()) continue;
                throw UndertowMessages.MESSAGES.moreThanOnePredicateWithName(builder.name(), builder.getClass(), ((PredicateBuilder)ret.get(builder.name())).getClass());
            }
            ret.put(builder.name(), builder);
        }
        return ret;
    }

    private static Map<String, HandlerBuilder> loadHandlerBuilders(ClassLoader classLoader) {
        ServiceLoader<HandlerBuilder> loader = ServiceLoader.load(HandlerBuilder.class, classLoader);
        HashMap<String, HandlerBuilder> ret = new HashMap<String, HandlerBuilder>();
        for (HandlerBuilder builder : loader) {
            if (ret.containsKey(builder.name())) {
                if (((HandlerBuilder)ret.get(builder.name())).getClass() == builder.getClass()) continue;
                throw UndertowMessages.MESSAGES.moreThanOneHandlerWithName(builder.name(), builder.getClass(), ((HandlerBuilder)ret.get(builder.name())).getClass());
            }
            ret.put(builder.name(), builder);
        }
        return ret;
    }

    static Node parse(String string2, Deque<Token> tokens) {
        return PredicatedHandlersParser.parse(string2, tokens, true);
    }

    static Node parse(String string2, Deque<Token> tokens, boolean topLevel) {
        ArrayDeque<Token> operatorStack = new ArrayDeque<Token>();
        ArrayDeque<Node> output = new ArrayDeque<Node>();
        ArrayList<Node> blocks = new ArrayList<Node>();
        block0: while (!tokens.isEmpty()) {
            Token token = tokens.poll();
            if (token.getToken().equals("{")) {
                output.push(PredicatedHandlersParser.parse(string2, tokens, false));
                continue;
            }
            if (token.getToken().equals("}")) {
                if (!topLevel) break;
                throw PredicatedHandlersParser.error(string2, token.getPosition(), "Unexpected token");
            }
            if (token.getToken().equals("\n") || token.getToken().equals(";")) {
                PredicatedHandlersParser.handleLineEnd(string2, operatorStack, output, blocks);
                continue;
            }
            if (PredicatedHandlersParser.isSpecialChar(token.getToken())) {
                if (token.getToken().equals("(")) {
                    operatorStack.push(token);
                    continue;
                }
                if (token.getToken().equals(")")) {
                    while (true) {
                        Token op;
                        if ((op = (Token)operatorStack.pop()) == null) {
                            throw PredicatedHandlersParser.error(string2, token.getPosition(), "Unexpected end of input");
                        }
                        if (op.getToken().equals("(")) continue block0;
                        output.push(new OperatorNode(op));
                    }
                }
                output.push(new OperatorNode(token));
                continue;
            }
            if (PredicatedHandlersParser.isOperator(token.getToken()) && !token.getToken().equals(ELSE)) {
                int exitingPrec;
                int prec = PredicatedHandlersParser.precedence(token.getToken());
                Token top = (Token)operatorStack.peek();
                while (top != null && !top.getToken().equals("(") && prec <= (exitingPrec = PredicatedHandlersParser.precedence(top.getToken()))) {
                    output.push(new OperatorNode((Token)operatorStack.pop()));
                    top = (Token)operatorStack.peek();
                }
                operatorStack.push(token);
                continue;
            }
            output.push(PredicatedHandlersParser.parseExpression(string2, token, tokens));
        }
        PredicatedHandlersParser.handleLineEnd(string2, operatorStack, output, blocks);
        if (blocks.size() == 1) {
            return (Node)blocks.get(0);
        }
        return new BlockNode(new Token("", 0), blocks);
    }

    private static void handleLineEnd(String string2, Deque<Token> operatorStack, Deque<Node> output, List<Node> blocks) {
        while (!operatorStack.isEmpty()) {
            Token op = operatorStack.pop();
            if (op.getToken().equals(")")) {
                throw PredicatedHandlersParser.error(string2, string2.length(), "Mismatched parenthesis");
            }
            output.push(new OperatorNode(op));
        }
        if (output.isEmpty()) {
            return;
        }
        Node predicate = PredicatedHandlersParser.collapseOutput(output.pop(), output);
        if (!output.isEmpty()) {
            throw PredicatedHandlersParser.error(string2, output.getFirst().getToken().getPosition(), "Invalid expression");
        }
        blocks.add(predicate);
    }

    private static Node collapseOutput(Node token, Deque<Node> tokens) {
        if (token instanceof OperatorNode) {
            OperatorNode node2 = (OperatorNode)token;
            if (node2.token.getToken().equals(AND)) {
                Node n1 = PredicatedHandlersParser.collapseOutput(tokens.pop(), tokens);
                Node n2 = PredicatedHandlersParser.collapseOutput(tokens.pop(), tokens);
                return new AndNode(token.getToken(), n2, n1);
            }
            if (node2.token.getToken().equals(OR)) {
                Node n1 = PredicatedHandlersParser.collapseOutput(tokens.pop(), tokens);
                Node n2 = PredicatedHandlersParser.collapseOutput(tokens.pop(), tokens);
                return new OrNode(token.getToken(), n2, n1);
            }
            if (node2.token.getToken().equals(NOT)) {
                Node n1 = PredicatedHandlersParser.collapseOutput(tokens.pop(), tokens);
                return new NotNode(token.getToken(), n1);
            }
            if (node2.token.getToken().equals(ARROW)) {
                Node n1 = PredicatedHandlersParser.collapseOutput(tokens.pop(), tokens);
                Node n2 = null;
                Node elseBranch = null;
                Node popped = tokens.pop();
                if (popped.getToken().getToken().equals(ELSE)) {
                    elseBranch = n1;
                    n1 = PredicatedHandlersParser.collapseOutput(tokens.pop(), tokens);
                    n2 = PredicatedHandlersParser.collapseOutput(tokens.pop(), tokens);
                } else {
                    n2 = PredicatedHandlersParser.collapseOutput(popped, tokens);
                }
                return new PredicateOperatorNode(token.getToken(), n2, n1, elseBranch);
            }
            return token;
        }
        return token;
    }

    private static Node parseExpression(String string2, Token token, Deque<Token> tokens) {
        if (token.getToken().equals(TRUE)) {
            return new OperatorNode(token);
        }
        if (token.getToken().equals(FALSE)) {
            return new OperatorNode(token);
        }
        Token next2 = tokens.peek();
        String endChar = ")";
        if (next2 != null && (next2.getToken().equals("[") || next2.getToken().equals("("))) {
            if (next2.getToken().equals("[")) {
                endChar = "]";
                UndertowLogger.ROOT_LOGGER.oldStylePredicateSyntax(string2);
            }
            HashMap<String, Node> values = new HashMap<String, Node>();
            tokens.poll();
            next2 = tokens.poll();
            if (next2 == null) {
                throw PredicatedHandlersParser.error(string2, string2.length(), "Unexpected end of input");
            }
            if (next2.getToken().equals("{")) {
                return PredicatedHandlersParser.handleSingleArrayValue(string2, token, tokens, endChar);
            }
            while (!next2.getToken().equals(endChar)) {
                Token equals = tokens.poll();
                if (equals == null) {
                    throw PredicatedHandlersParser.error(string2, string2.length(), "Unexpected end of input");
                }
                if (!equals.getToken().equals("=")) {
                    if (equals.getToken().equals(endChar) && values.isEmpty()) {
                        return PredicatedHandlersParser.handleSingleValue(token, next2);
                    }
                    if (equals.getToken().equals(",")) {
                        tokens.push(equals);
                        tokens.push(next2);
                        return PredicatedHandlersParser.handleSingleVarArgsValue(string2, token, tokens, endChar);
                    }
                    throw PredicatedHandlersParser.error(string2, equals.getPosition(), "Unexpected token");
                }
                Token value = tokens.poll();
                if (value == null) {
                    throw PredicatedHandlersParser.error(string2, string2.length(), "Unexpected end of input");
                }
                if (value.getToken().equals("{")) {
                    values.put(next2.getToken(), new ArrayNode(value, PredicatedHandlersParser.readArrayType(string2, tokens, "}")));
                } else {
                    if (PredicatedHandlersParser.isOperator(value.getToken()) || PredicatedHandlersParser.isSpecialChar(value.getToken())) {
                        throw PredicatedHandlersParser.error(string2, value.getPosition(), "Unexpected token");
                    }
                    values.put(next2.getToken(), new ValueNode(value));
                }
                next2 = tokens.poll();
                if (next2 == null) {
                    throw PredicatedHandlersParser.error(string2, string2.length(), "Unexpected end of input");
                }
                if (next2.getToken().equals(endChar)) continue;
                if (!next2.getToken().equals(",")) {
                    throw PredicatedHandlersParser.error(string2, string2.length(), "Expecting , or " + endChar);
                }
                next2 = tokens.poll();
                if (next2 != null) continue;
                throw PredicatedHandlersParser.error(string2, string2.length(), "Unexpected end of input");
            }
            return new ExpressionNode(token, values);
        }
        if (next2 != null && PredicatedHandlersParser.isSpecialChar(next2.getToken())) {
            throw PredicatedHandlersParser.error(string2, next2.getPosition(), "Unexpected character");
        }
        return new ExpressionNode(token, Collections.emptyMap());
    }

    private static Node handleSingleArrayValue(String string2, Token builder, Deque<Token> tokens, String endChar) {
        List<Token> array2 = PredicatedHandlersParser.readArrayType(string2, tokens, "}");
        Token close = tokens.poll();
        if (!close.getToken().equals(endChar)) {
            throw PredicatedHandlersParser.error(string2, close.getPosition(), "expected " + endChar);
        }
        return new ExpressionNode(builder, Collections.singletonMap(null, new ArrayNode(builder, array2)));
    }

    private static Node handleSingleVarArgsValue(String string2, Token expressionName, Deque<Token> tokens, String endChar) {
        List<Token> array2 = PredicatedHandlersParser.readArrayType(string2, tokens, endChar);
        return new ExpressionNode(expressionName, Collections.singletonMap(null, new ArrayNode(expressionName, array2)));
    }

    private static List<Token> readArrayType(String string2, Deque<Token> tokens, String expectedEndToken) {
        ArrayList<Token> values = new ArrayList<Token>();
        Token token = tokens.poll();
        if (token.getToken().equals(expectedEndToken)) {
            return Collections.emptyList();
        }
        while (token != null) {
            Token commaOrEnd = tokens.poll();
            values.add(token);
            if (commaOrEnd.getToken().equals(expectedEndToken)) {
                return values;
            }
            if (!commaOrEnd.getToken().equals(",")) {
                throw PredicatedHandlersParser.error(string2, commaOrEnd.getPosition(), "expected either , or " + expectedEndToken);
            }
            token = tokens.poll();
        }
        throw PredicatedHandlersParser.error(string2, string2.length(), "unexpected end of input in array");
    }

    private static Node handleSingleValue(Token token, Token next2) {
        return new ExpressionNode(token, Collections.singletonMap(null, new ValueNode(next2)));
    }

    private static int precedence(String operator) {
        if (operator.equals(NOT)) {
            return 3;
        }
        if (operator.equals(AND)) {
            return 2;
        }
        if (operator.equals(OR)) {
            return 1;
        }
        if (operator.equals(ARROW)) {
            return -1000;
        }
        throw new IllegalStateException();
    }

    private static boolean isOperator(String op) {
        return op.equals(AND) || op.equals(OR) || op.equals(NOT) || op.equals(ARROW);
    }

    private static boolean isSpecialChar(String token) {
        if (token.length() == 1) {
            char c = token.charAt(0);
            switch (c) {
                case '(': 
                case ')': 
                case ',': 
                case '=': 
                case '[': 
                case ']': {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static Deque<Token> tokenize(String string2) {
        char currentStringDelim = '\u0000';
        boolean inVariable = false;
        StringBuilder current = new StringBuilder();
        ArrayDeque<Token> ret = new ArrayDeque<Token>();
        block8: for (int pos = 0; pos < string2.length(); ++pos) {
            char c = string2.charAt(pos);
            if (currentStringDelim != '\u0000') {
                if (c == currentStringDelim && current.charAt(current.length() - 1) != '\\') {
                    ret.add(new Token(current.toString(), pos));
                    current.setLength(0);
                    currentStringDelim = '\u0000';
                    continue;
                }
                if (c == '\n' || c == '\r') {
                    ret.add(new Token(current.toString(), pos));
                    current.setLength(0);
                    currentStringDelim = '\u0000';
                    ret.add(new Token("\n", pos));
                    continue;
                }
                current.append(c);
                continue;
            }
            switch (c) {
                case '\t': 
                case ' ': {
                    if (current.length() == 0) continue block8;
                    ret.add(new Token(current.toString(), pos));
                    current.setLength(0);
                    continue block8;
                }
                case '\n': 
                case '\r': {
                    if (current.length() != 0) {
                        ret.add(new Token(current.toString(), pos));
                        current.setLength(0);
                    }
                    ret.add(new Token("\n", pos));
                    continue block8;
                }
                case '(': 
                case ')': 
                case ',': 
                case ';': 
                case '=': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    if (inVariable) {
                        current.append(c);
                        if (c != '}') continue block8;
                        inVariable = false;
                        continue block8;
                    }
                    if (current.length() != 0) {
                        ret.add(new Token(current.toString(), pos));
                        current.setLength(0);
                    }
                    ret.add(new Token("" + c, pos));
                    continue block8;
                }
                case '\"': 
                case '\'': {
                    if (current.length() != 0) {
                        throw PredicatedHandlersParser.error(string2, pos, "Unexpected token");
                    }
                    currentStringDelim = c;
                    continue block8;
                }
                case '$': 
                case '%': {
                    current.append(c);
                    if (string2.charAt(pos + 1) != '{') continue block8;
                    inVariable = true;
                    continue block8;
                }
                case '-': {
                    if (inVariable) {
                        current.append(c);
                        continue block8;
                    }
                    if (pos != string2.length() && string2.charAt(pos + 1) == '>') {
                        ++pos;
                        if (current.length() != 0) {
                            ret.add(new Token(current.toString(), pos));
                            current.setLength(0);
                        }
                        ret.add(new Token(ARROW, pos));
                        continue block8;
                    }
                    current.append(c);
                    continue block8;
                }
                default: {
                    current.append(c);
                }
            }
        }
        if (current.length() > 0) {
            ret.add(new Token(current.toString(), string2.length()));
        }
        return ret;
    }

    private static IllegalStateException error(String string2, int pos, String reason) {
        int i;
        StringBuilder b = new StringBuilder();
        int linePos = 0;
        for (i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '\n') {
                if (i >= pos) break;
                linePos = 0;
            } else if (i < pos) {
                ++linePos;
            }
            b.append(string2.charAt(i));
        }
        b.append('\n');
        for (i = 0; i < linePos; ++i) {
            b.append(' ');
        }
        b.append('^');
        throw UndertowMessages.MESSAGES.errorParsingPredicateString(reason, b.toString());
    }

    static final class Token {
        private final String token;
        private final int position;

        Token(String token, int position) {
            this.token = token;
            this.position = position;
        }

        public String getToken() {
            return this.token;
        }

        public int getPosition() {
            return this.position;
        }

        public String toString() {
            return this.token + " <" + this.position + ">";
        }
    }

    static class BlockNode
    implements Node {
        private final Token token;
        private final List<Node> block;

        BlockNode(Token token, List<Node> block) {
            this.token = token;
            this.block = block;
        }

        public List<Node> getBlock() {
            return this.block;
        }

        @Override
        public Token getToken() {
            return this.token;
        }
    }

    static class NotNode
    implements Node {
        private final Token token;
        private final Node node;

        NotNode(Token token, Node node2) {
            this.token = token;
            this.node = node2;
        }

        public Node getNode() {
            return this.node;
        }

        @Override
        public Token getToken() {
            return this.token;
        }
    }

    static class PredicateOperatorNode
    implements Node {
        private final Token token;
        private final Node left;
        private final Node right;
        private final Node elseBranch;

        PredicateOperatorNode(Token token, Node left2, Node right2, Node elseBranch) {
            this.token = token;
            this.left = left2;
            this.right = right2;
            this.elseBranch = elseBranch;
        }

        public Node getLeft() {
            return this.left;
        }

        public Node getRight() {
            return this.right;
        }

        public Node getElseBranch() {
            return this.elseBranch;
        }

        @Override
        public Token getToken() {
            return this.token;
        }
    }

    static class OrNode
    implements Node {
        private final Token token;
        private final Node left;
        private final Node right;

        OrNode(Token token, Node left2, Node right2) {
            this.token = token;
            this.left = left2;
            this.right = right2;
        }

        public Node getLeft() {
            return this.left;
        }

        public Node getRight() {
            return this.right;
        }

        @Override
        public Token getToken() {
            return this.token;
        }
    }

    static class AndNode
    implements Node {
        private final Token token;
        private final Node left;
        private final Node right;

        AndNode(Token token, Node left2, Node right2) {
            this.token = token;
            this.left = left2;
            this.right = right2;
        }

        public Node getLeft() {
            return this.left;
        }

        public Node getRight() {
            return this.right;
        }

        @Override
        public Token getToken() {
            return this.token;
        }
    }

    static class OperatorNode
    implements Node {
        private final Token token;

        private OperatorNode(Token token) {
            this.token = token;
        }

        @Override
        public Token getToken() {
            return this.token;
        }
    }

    static class ValueNode
    implements Node {
        private final Token value;

        private ValueNode(Token value) {
            this.value = value;
        }

        public Token getValue() {
            return this.value;
        }

        public String toString() {
            return this.value.getToken();
        }

        @Override
        public Token getToken() {
            return this.value;
        }
    }

    static class ArrayNode
    implements Node {
        private final Token start;
        private final List<Token> values;

        private ArrayNode(Token start, List<Token> tokens) {
            this.start = start;
            this.values = tokens;
        }

        public List<Token> getValues() {
            return this.values;
        }

        @Override
        public Token getToken() {
            return this.start;
        }
    }

    static class ExpressionNode
    implements Node {
        private final Token token;
        private final Map<String, Node> values;

        private ExpressionNode(Token token, Map<String, Node> values) {
            this.token = token;
            this.values = values;
        }

        @Override
        public Token getToken() {
            return this.token;
        }

        public Map<String, Node> getValues() {
            return this.values;
        }
    }

    public static interface Node {
        public Token getToken();
    }
}

