/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.conduits.StoredResponseStreamSinkConduit;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.util.ConduitFactory;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.xnio.conduits.StreamSinkConduit;

public class StoredResponseHandler
implements HttpHandler {
    private final HttpHandler next;

    public StoredResponseHandler(HttpHandler next2) {
        this.next = next2;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.addResponseWrapper(new ConduitWrapper<StreamSinkConduit>(){

            @Override
            public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
                return new StoredResponseStreamSinkConduit(factory.create(), exchange);
            }
        });
        this.next.handleRequest(exchange);
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "store-response";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new HandlerWrapper(){

                @Override
                public HttpHandler wrap(HttpHandler handler) {
                    return new StoredResponseHandler(handler);
                }
            };
        }
    }
}

