/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowMessages;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.LongUnaryOperator;

public class GracefulShutdownHandler
implements HttpHandler {
    private static final long SHUTDOWN_MASK = Long.MIN_VALUE;
    private static final long ACTIVE_COUNT_MASK = Long.MAX_VALUE;
    private static final LongUnaryOperator incrementActive = current -> {
        long incrementedActiveCount = GracefulShutdownHandler.activeCount(current) + 1L;
        return incrementedActiveCount | current & Long.MIN_VALUE;
    };
    private static final LongUnaryOperator incrementActiveAndShutdown = incrementActive.andThen(current -> current | Long.MIN_VALUE);
    private static final LongUnaryOperator decrementActive = current -> {
        long decrementedActiveCount = GracefulShutdownHandler.activeCount(current) - 1L;
        return decrementedActiveCount | current & Long.MIN_VALUE;
    };
    private final GracefulShutdownListener listener = new GracefulShutdownListener();
    private final List<ShutdownListener> shutdownListeners = new ArrayList<ShutdownListener>();
    private final Object lock = new Object();
    private volatile long state = 0L;
    private static final AtomicLongFieldUpdater<GracefulShutdownHandler> stateUpdater = AtomicLongFieldUpdater.newUpdater(GracefulShutdownHandler.class, "state");
    private final HttpHandler next;

    public GracefulShutdownHandler(HttpHandler next2) {
        this.next = next2;
    }

    private static boolean isShutdown(long state) {
        return (state & Long.MIN_VALUE) != 0L;
    }

    private static long activeCount(long state) {
        return state & Long.MAX_VALUE;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        long snapshot = stateUpdater.updateAndGet(this, incrementActive);
        if (GracefulShutdownHandler.isShutdown(snapshot)) {
            this.decrementRequests();
            exchange.setStatusCode(503);
            exchange.endExchange();
            return;
        }
        exchange.addExchangeCompleteListener(this.listener);
        this.next.handleRequest(exchange);
    }

    public void shutdown() {
        stateUpdater.updateAndGet(this, incrementActiveAndShutdown);
        this.decrementRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            stateUpdater.updateAndGet(this, current -> current & Long.MAX_VALUE);
            for (ShutdownListener listener : this.shutdownListeners) {
                listener.shutdown(false);
            }
            this.shutdownListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownComplete() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
            for (ShutdownListener listener : this.shutdownListeners) {
                listener.shutdown(true);
            }
            this.shutdownListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitShutdown() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (!GracefulShutdownHandler.isShutdown(stateUpdater.get(this))) {
                throw UndertowMessages.MESSAGES.handlerNotShutdown();
            }
            while (GracefulShutdownHandler.activeCount(stateUpdater.get(this)) > 0L) {
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitShutdown(long millis) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (!GracefulShutdownHandler.isShutdown(stateUpdater.get(this))) {
                throw UndertowMessages.MESSAGES.handlerNotShutdown();
            }
            long end = System.currentTimeMillis() + millis;
            while (GracefulShutdownHandler.activeCount(stateUpdater.get(this)) != 0L) {
                long left2 = end - System.currentTimeMillis();
                if (left2 <= 0L) {
                    return false;
                }
                this.lock.wait(left2);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownListener(ShutdownListener shutdownListener) {
        Object object = this.lock;
        synchronized (object) {
            if (!GracefulShutdownHandler.isShutdown(stateUpdater.get(this))) {
                throw UndertowMessages.MESSAGES.handlerNotShutdown();
            }
            long count2 = GracefulShutdownHandler.activeCount(stateUpdater.get(this));
            if (count2 == 0L) {
                shutdownListener.shutdown(true);
            } else {
                this.shutdownListeners.add(shutdownListener);
            }
        }
    }

    private void decrementRequests() {
        long snapshot = stateUpdater.updateAndGet(this, decrementActive);
        if (snapshot == Long.MIN_VALUE) {
            this.shutdownComplete();
        }
    }

    public static interface ShutdownListener {
        public void shutdown(boolean var1);
    }

    private final class GracefulShutdownListener
    implements ExchangeCompletionListener {
        private GracefulShutdownListener() {
        }

        @Override
        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            try {
                GracefulShutdownHandler.this.decrementRequests();
            }
            finally {
                nextListener.proceed();
            }
        }
    }
}

