/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieSameSiteMode;
import java.util.Arrays;
import java.util.Date;

public class CookieImpl
implements Cookie {
    private final String name;
    private String value;
    private String path;
    private String domain;
    private Integer maxAge;
    private Date expires;
    private boolean discard;
    private boolean secure;
    private boolean httpOnly;
    private int version = 0;
    private String comment;
    private boolean sameSite;
    private String sameSiteMode;

    public CookieImpl(String name2, String value) {
        this.name = name2;
        this.value = value;
    }

    public CookieImpl(String name2) {
        this.name = name2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public CookieImpl setValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public CookieImpl setPath(String path2) {
        this.path = path2;
        return this;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public CookieImpl setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    @Override
    public Integer getMaxAge() {
        return this.maxAge;
    }

    @Override
    public CookieImpl setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    @Override
    public boolean isDiscard() {
        return this.discard;
    }

    @Override
    public CookieImpl setDiscard(boolean discard) {
        this.discard = discard;
        return this;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public CookieImpl setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public CookieImpl setVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    @Override
    public CookieImpl setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    @Override
    public Date getExpires() {
        return this.expires;
    }

    @Override
    public CookieImpl setExpires(Date expires) {
        this.expires = expires;
        return this;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public Cookie setComment(String comment2) {
        this.comment = comment2;
        return this;
    }

    @Override
    public boolean isSameSite() {
        return this.sameSite;
    }

    @Override
    public Cookie setSameSite(boolean sameSite) {
        this.sameSite = sameSite;
        return this;
    }

    @Override
    public String getSameSiteMode() {
        return this.sameSiteMode;
    }

    @Override
    public Cookie setSameSiteMode(String mode) {
        String m = CookieSameSiteMode.lookupModeString(mode);
        if (m != null) {
            UndertowLogger.REQUEST_LOGGER.tracef("Setting SameSite mode to [%s] for cookie [%s]", (Object)m, (Object)this.name);
            this.sameSiteMode = m;
            this.setSameSite(true);
        } else {
            UndertowLogger.REQUEST_LOGGER.warnf((Throwable)UndertowMessages.MESSAGES.invalidSameSiteMode(mode, Arrays.toString((Object[])CookieSameSiteMode.values())), "Ignoring specified SameSite mode [%s] for cookie [%s]", (Object)mode, (Object)this.name);
        }
        return this;
    }
}

