/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.handlers;

import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;

public class AuthenticationCallHandler
implements HttpHandler {
    private final HttpHandler next;

    public AuthenticationCallHandler(HttpHandler next2) {
        this.next = next2;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.isInIoThread()) {
            exchange.dispatch(this);
            return;
        }
        SecurityContext context = exchange.getSecurityContext();
        if (context.authenticate()) {
            if (!exchange.isComplete()) {
                this.next.handleRequest(exchange);
            }
        } else {
            exchange.endExchange();
        }
    }
}

