/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.ssl;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.UndertowSslConnection;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Sequence;
import org.xnio.SslClientAuthMode;
import org.xnio.StreamConnection;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.ssl.SslConnection;

class UndertowAcceptingSslChannel
implements AcceptingChannel<SslConnection> {
    private final UndertowXnioSsl ssl;
    private final AcceptingChannel<? extends StreamConnection> tcpServer;
    private volatile SslClientAuthMode clientAuthMode;
    private volatile int useClientMode;
    private volatile int enableSessionCreation;
    private volatile String[] cipherSuites;
    private volatile String[] protocols;
    private static final AtomicReferenceFieldUpdater<UndertowAcceptingSslChannel, SslClientAuthMode> clientAuthModeUpdater = AtomicReferenceFieldUpdater.newUpdater(UndertowAcceptingSslChannel.class, SslClientAuthMode.class, "clientAuthMode");
    private static final AtomicIntegerFieldUpdater<UndertowAcceptingSslChannel> useClientModeUpdater = AtomicIntegerFieldUpdater.newUpdater(UndertowAcceptingSslChannel.class, "useClientMode");
    private static final AtomicIntegerFieldUpdater<UndertowAcceptingSslChannel> enableSessionCreationUpdater = AtomicIntegerFieldUpdater.newUpdater(UndertowAcceptingSslChannel.class, "enableSessionCreation");
    private final ChannelListener.Setter<AcceptingChannel<SslConnection>> closeSetter;
    private final ChannelListener.Setter<AcceptingChannel<SslConnection>> acceptSetter;
    protected final boolean startTls;
    protected final ByteBufferPool applicationBufferPool;
    private final boolean useCipherSuitesOrder;
    private static final Set<Option<?>> SUPPORTED_OPTIONS = Option.setBuilder().add((Option<?>)Options.SSL_CLIENT_AUTH_MODE).add((Option<?>)Options.SSL_USE_CLIENT_MODE).add((Option<?>)Options.SSL_ENABLE_SESSION_CREATION).add((Option<?>)Options.SSL_ENABLED_CIPHER_SUITES).add((Option<?>)Options.SSL_ENABLED_PROTOCOLS).create();

    UndertowAcceptingSslChannel(UndertowXnioSsl ssl, AcceptingChannel<? extends StreamConnection> tcpServer, OptionMap optionMap, ByteBufferPool applicationBufferPool, boolean startTls) {
        this.tcpServer = tcpServer;
        this.ssl = ssl;
        this.applicationBufferPool = applicationBufferPool;
        this.startTls = startTls;
        this.clientAuthMode = optionMap.get(Options.SSL_CLIENT_AUTH_MODE);
        this.useClientMode = optionMap.get(Options.SSL_USE_CLIENT_MODE, false) ? 1 : 0;
        this.enableSessionCreation = optionMap.get(Options.SSL_ENABLE_SESSION_CREATION, true) ? 1 : 0;
        Sequence<String> enabledCipherSuites = optionMap.get(Options.SSL_ENABLED_CIPHER_SUITES);
        this.cipherSuites = enabledCipherSuites != null ? enabledCipherSuites.toArray((String[])new String[enabledCipherSuites.size()]) : null;
        Sequence<String> enabledProtocols = optionMap.get(Options.SSL_ENABLED_PROTOCOLS);
        this.protocols = enabledProtocols != null ? enabledProtocols.toArray((String[])new String[enabledProtocols.size()]) : null;
        this.closeSetter = ChannelListeners.getDelegatingSetter(tcpServer.getCloseSetter(), this);
        this.acceptSetter = ChannelListeners.getDelegatingSetter(tcpServer.getAcceptSetter(), this);
        this.useCipherSuitesOrder = optionMap.get(UndertowOptions.SSL_USER_CIPHER_SUITES_ORDER, false);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (option == Options.SSL_CLIENT_AUTH_MODE) {
            return option.cast((Object)clientAuthModeUpdater.getAndSet(this, Options.SSL_CLIENT_AUTH_MODE.cast(value)));
        }
        if (option == Options.SSL_USE_CLIENT_MODE) {
            Boolean valueObject = Options.SSL_USE_CLIENT_MODE.cast(value);
            if (valueObject != null) {
                return option.cast(useClientModeUpdater.getAndSet(this, valueObject != false ? 1 : 0) != 0);
            }
        } else if (option == Options.SSL_ENABLE_SESSION_CREATION) {
            Boolean valueObject = Options.SSL_ENABLE_SESSION_CREATION.cast(value);
            if (valueObject != null) {
                return option.cast(enableSessionCreationUpdater.getAndSet(this, valueObject != false ? 1 : 0) != 0);
            }
        } else {
            if (option == Options.SSL_ENABLED_CIPHER_SUITES) {
                Sequence<String> seq = Options.SSL_ENABLED_CIPHER_SUITES.cast(value);
                String[] old = this.cipherSuites;
                this.cipherSuites = seq == null ? null : seq.toArray((String[])new String[seq.size()]);
                return option.cast(old);
            }
            if (option == Options.SSL_ENABLED_PROTOCOLS) {
                Sequence<String> seq = Options.SSL_ENABLED_PROTOCOLS.cast(value);
                String[] old = this.protocols;
                this.protocols = seq == null ? null : seq.toArray((String[])new String[seq.size()]);
                return option.cast(old);
            }
            return this.tcpServer.setOption(option, value);
        }
        throw UndertowLogger.ROOT_LOGGER.nullParameter("value");
    }

    @Override
    public XnioWorker getWorker() {
        return this.tcpServer.getWorker();
    }

    @Override
    public UndertowSslConnection accept() throws IOException {
        StreamConnection tcpConnection = (StreamConnection)this.tcpServer.accept();
        if (tcpConnection == null) {
            return null;
        }
        try {
            String[] protocols2;
            SslClientAuthMode clientAuthMode;
            InetSocketAddress peerAddress = tcpConnection.getPeerAddress(InetSocketAddress.class);
            SSLEngine engine = this.ssl.getSslContext().createSSLEngine(UndertowAcceptingSslChannel.getHostNameNoResolve(peerAddress), peerAddress.getPort());
            if (this.useCipherSuitesOrder) {
                SSLParameters sslParameters = engine.getSSLParameters();
                sslParameters.setUseCipherSuitesOrder(true);
                engine.setSSLParameters(sslParameters);
            }
            boolean clientMode = this.useClientMode != 0;
            engine.setUseClientMode(clientMode);
            if (!clientMode && (clientAuthMode = this.clientAuthMode) != null) {
                switch (clientAuthMode) {
                    case NOT_REQUESTED: {
                        engine.setNeedClientAuth(false);
                        engine.setWantClientAuth(false);
                        break;
                    }
                    case REQUESTED: {
                        engine.setWantClientAuth(true);
                        break;
                    }
                    case REQUIRED: {
                        engine.setNeedClientAuth(true);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            engine.setEnableSessionCreation(this.enableSessionCreation != 0);
            String[] cipherSuites = this.cipherSuites;
            if (cipherSuites != null) {
                HashSet<String> supported = new HashSet<String>(Arrays.asList(engine.getSupportedCipherSuites()));
                if (supported.isEmpty()) {
                    engine.setEnabledCipherSuites(cipherSuites);
                } else {
                    ArrayList<String> finalList = new ArrayList<String>();
                    for (String name2 : cipherSuites) {
                        if (!supported.contains(name2)) continue;
                        finalList.add(name2);
                    }
                    engine.setEnabledCipherSuites(finalList.toArray(new String[finalList.size()]));
                }
            }
            if ((protocols2 = this.protocols) != null) {
                HashSet<String> supported = new HashSet<String>(Arrays.asList(engine.getSupportedProtocols()));
                if (supported.isEmpty()) {
                    engine.setEnabledProtocols(protocols2);
                } else {
                    ArrayList<String> finalList = new ArrayList<String>();
                    for (String name3 : protocols2) {
                        if (!supported.contains(name3)) continue;
                        finalList.add(name3);
                    }
                    engine.setEnabledProtocols(finalList.toArray(new String[finalList.size()]));
                }
            }
            return this.accept(tcpConnection, engine);
        }
        catch (IOException | RuntimeException e2) {
            IoUtils.safeClose((Closeable)tcpConnection);
            UndertowLogger.REQUEST_LOGGER.failedToAcceptSSLRequest(e2);
            return null;
        }
    }

    protected UndertowSslConnection accept(StreamConnection tcpServer, SSLEngine sslEngine) throws IOException {
        return new UndertowSslConnection(tcpServer, sslEngine, this.applicationBufferPool);
    }

    @Override
    public ChannelListener.Setter<? extends AcceptingChannel<SslConnection>> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public boolean isOpen() {
        return this.tcpServer.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.tcpServer.close();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return SUPPORTED_OPTIONS.contains(option) || this.tcpServer.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        if (option == Options.SSL_CLIENT_AUTH_MODE) {
            return option.cast((Object)this.clientAuthMode);
        }
        if (option == Options.SSL_USE_CLIENT_MODE) {
            return option.cast(this.useClientMode != 0);
        }
        if (option == Options.SSL_ENABLE_SESSION_CREATION) {
            return option.cast(this.enableSessionCreation != 0);
        }
        if (option == Options.SSL_ENABLED_CIPHER_SUITES) {
            String[] cipherSuites = this.cipherSuites;
            return cipherSuites == null ? null : (T)option.cast(Sequence.of(cipherSuites));
        }
        if (option == Options.SSL_ENABLED_PROTOCOLS) {
            String[] protocols2 = this.protocols;
            return protocols2 == null ? null : (T)option.cast(Sequence.of(protocols2));
        }
        return this.tcpServer.getOption(option);
    }

    @Override
    public ChannelListener.Setter<? extends AcceptingChannel<SslConnection>> getAcceptSetter() {
        return this.acceptSetter;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.tcpServer.getLocalAddress();
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type2) {
        return this.tcpServer.getLocalAddress(type2);
    }

    @Override
    public void suspendAccepts() {
        this.tcpServer.suspendAccepts();
    }

    @Override
    public void resumeAccepts() {
        this.tcpServer.resumeAccepts();
    }

    @Override
    public boolean isAcceptResumed() {
        return this.tcpServer.isAcceptResumed();
    }

    @Override
    public void wakeupAccepts() {
        this.tcpServer.wakeupAccepts();
    }

    @Override
    public void awaitAcceptable() throws IOException {
        this.tcpServer.awaitAcceptable();
    }

    @Override
    public void awaitAcceptable(long time2, TimeUnit timeUnit) throws IOException {
        this.tcpServer.awaitAcceptable(time2, timeUnit);
    }

    @Override
    @Deprecated
    public XnioExecutor getAcceptThread() {
        return this.tcpServer.getAcceptThread();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.tcpServer.getIoThread();
    }

    private static String getHostNameNoResolve(InetSocketAddress socketAddress) {
        return socketAddress.getHostString();
    }
}

