/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.protocols.http2.ConnectionErrorException;
import io.undertow.protocols.http2.HpackDecoder;
import io.undertow.protocols.http2.HpackException;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.protocols.http2.Http2FrameHeaderParser;
import io.undertow.protocols.http2.Http2PushBackParser;
import io.undertow.protocols.http2.StreamErrorException;
import io.undertow.server.Connectors;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.xnio.Bits;

abstract class Http2HeaderBlockParser
extends Http2PushBackParser
implements HpackDecoder.HeaderEmitter {
    private final HeaderMap headerMap = new HeaderMap();
    private boolean beforeHeadersHandled = false;
    private final HpackDecoder decoder;
    private int frameRemaining = -1;
    private boolean invalid = false;
    private boolean processingPseudoHeaders = true;
    private final boolean client;
    private final int maxHeaders;
    private final int maxHeaderListSize;
    private int currentPadding;
    private final int streamId;
    private int headerSize;
    private static final Set<HttpString> SERVER_HEADERS;

    Http2HeaderBlockParser(int frameLength, HpackDecoder decoder, boolean client, int maxHeaders, int streamId, int maxHeaderListSize) {
        super(frameLength);
        this.decoder = decoder;
        this.client = client;
        this.maxHeaders = maxHeaders;
        this.streamId = streamId;
        this.maxHeaderListSize = maxHeaderListSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleData(ByteBuffer resource2, Http2FrameHeaderParser header) throws IOException {
        boolean continuationFramesComing = Bits.anyAreClear(header.flags, 4);
        if (this.frameRemaining == -1) {
            this.frameRemaining = header.length;
        }
        boolean moreDataThisFrame = resource2.remaining() < this.frameRemaining;
        int pos = resource2.position();
        int readInBeforeHeader = 0;
        try {
            if (!this.beforeHeadersHandled) {
                if (!this.handleBeforeHeader(resource2, header)) {
                    return;
                }
                this.currentPadding = this.getPaddingLength();
                readInBeforeHeader = resource2.position() - pos;
            }
            this.beforeHeadersHandled = true;
            this.decoder.setHeaderEmitter(this);
            int oldLimit = -1;
            if (this.currentPadding > 0) {
                int actualData = this.frameRemaining - readInBeforeHeader - this.currentPadding;
                if (actualData < 0) {
                    throw new ConnectionErrorException(1);
                }
                if (resource2.remaining() > actualData) {
                    oldLimit = resource2.limit();
                    resource2.limit(resource2.position() + actualData);
                }
            }
            try {
                this.decoder.decode(resource2, moreDataThisFrame || continuationFramesComing);
            }
            catch (HpackException e2) {
                throw new ConnectionErrorException(e2.getCloseCode(), (Throwable)e2);
            }
            if (this.maxHeaders > 0 && this.headerMap.size() > this.maxHeaders) {
                throw new StreamErrorException(6);
            }
            if (oldLimit != -1) {
                if (resource2.remaining() == 0) {
                    int paddingInBuffer = oldLimit - resource2.limit();
                    this.currentPadding -= paddingInBuffer;
                    resource2.limit(oldLimit);
                    resource2.position(oldLimit);
                } else {
                    resource2.limit(oldLimit);
                }
            }
        }
        finally {
            int used = resource2.position() - pos;
            this.frameRemaining -= used;
        }
    }

    protected abstract boolean handleBeforeHeader(ByteBuffer var1, Http2FrameHeaderParser var2);

    HeaderMap getHeaderMap() {
        return this.headerMap;
    }

    @Override
    public void emitHeader(HttpString name2, String value, boolean neverIndex) throws HpackException {
        if (this.maxHeaderListSize > 0) {
            this.headerSize += name2.length() + value.length() + 32;
            if (this.headerSize > this.maxHeaderListSize) {
                throw new HpackException(UndertowMessages.MESSAGES.headerBlockTooLarge(), 1);
            }
        }
        if (this.maxHeaders > 0 && this.headerMap.size() > this.maxHeaders) {
            return;
        }
        this.headerMap.add(name2, value);
        if (name2.length() == 0) {
            throw UndertowMessages.MESSAGES.invalidHeader();
        }
        if (name2.equals(Headers.TRANSFER_ENCODING)) {
            throw new HpackException(1);
        }
        if (name2.byteAt(0) == 58) {
            if (this.client) {
                if (!name2.equals(Http2Channel.STATUS)) {
                    this.invalid = true;
                }
            } else if (!SERVER_HEADERS.contains(name2)) {
                this.invalid = true;
            }
            if (!this.processingPseudoHeaders) {
                throw new HpackException(UndertowMessages.MESSAGES.pseudoHeaderInWrongOrder(name2), 1);
            }
        } else {
            this.processingPseudoHeaders = false;
        }
        for (int i = 0; i < name2.length(); ++i) {
            byte c = name2.byteAt(i);
            if (c >= 65 && c <= 90) {
                this.invalid = true;
                UndertowLogger.REQUEST_LOGGER.debugf("Malformed request, header %s contains uppercase characters", (Object)name2);
                continue;
            }
            if (c == 58 || Connectors.isValidTokenCharacter(c)) continue;
            this.invalid = true;
            UndertowLogger.REQUEST_LOGGER.debugf("Malformed request, header %s contains invalid token character", (Object)name2);
        }
    }

    protected abstract int getPaddingLength();

    @Override
    protected void moreData(int data2) {
        super.moreData(data2);
        this.frameRemaining += data2;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public int getStreamId() {
        return this.streamId;
    }

    static {
        HashSet<HttpString> server2 = new HashSet<HttpString>();
        server2.add(Http2Channel.METHOD);
        server2.add(Http2Channel.AUTHORITY);
        server2.add(Http2Channel.SCHEME);
        server2.add(Http2Channel.PATH);
        SERVER_HEADERS = Collections.unmodifiableSet(server2);
    }
}

