/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegularExpressionPredicate
implements Predicate {
    private final Pattern pattern;
    private final ExchangeAttribute matchAttribute;
    private final boolean requireFullMatch;

    public RegularExpressionPredicate(String regex, ExchangeAttribute matchAttribute, boolean requireFullMatch, boolean caseSensitive) {
        this.requireFullMatch = requireFullMatch;
        this.pattern = Pattern.compile(regex, caseSensitive ? 0 : 2);
        this.matchAttribute = matchAttribute;
    }

    public RegularExpressionPredicate(String regex, ExchangeAttribute matchAttribute, boolean requireFullMatch) {
        this(regex, matchAttribute, requireFullMatch, true);
    }

    public RegularExpressionPredicate(String regex, ExchangeAttribute matchAttribute) {
        this(regex, matchAttribute, false);
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        String input = this.matchAttribute.readAttribute(value);
        if (input == null) {
            return false;
        }
        Matcher matcher = this.pattern.matcher(input);
        boolean matches = this.requireFullMatch ? matcher.matches() : matcher.find();
        if (matches) {
            TreeMap<String, String> context = (TreeMap<String, String>)value.getAttachment(PREDICATE_CONTEXT);
            if (context == null) {
                context = new TreeMap<String, String>();
                value.putAttachment(PREDICATE_CONTEXT, context);
            }
            int count2 = matcher.groupCount();
            for (int i = 0; i <= count2; ++i) {
                context.put(Integer.toString(i), matcher.group(i));
            }
        }
        return matches;
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "regex";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("pattern", String.class);
            params.put("value", ExchangeAttribute.class);
            params.put("full-match", Boolean.class);
            params.put("case-sensitive", Boolean.class);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            HashSet<String> params = new HashSet<String>();
            params.add("pattern");
            return params;
        }

        @Override
        public String defaultParameter() {
            return "pattern";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            ExchangeAttribute value = (ExchangeAttribute)config.get("value");
            if (value == null) {
                value = ExchangeAttributes.relativePath();
            }
            Boolean fullMatch = (Boolean)config.get("full-match");
            Boolean caseSensitive = (Boolean)config.get("case-sensitive");
            String pattern = (String)config.get("pattern");
            return new RegularExpressionPredicate(pattern, value, fullMatch == null ? false : fullMatch, caseSensitive == null ? true : caseSensitive);
        }
    }
}

