/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.PathTemplate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PathTemplatePredicate
implements Predicate {
    private final ExchangeAttribute attribute;
    private final PathTemplate value;

    public PathTemplatePredicate(String template2, ExchangeAttribute attribute) {
        this.attribute = attribute;
        this.value = PathTemplate.create(template2);
    }

    @Override
    public boolean resolve(HttpServerExchange exchange) {
        HashMap<String, String> params = new HashMap<String, String>();
        String path2 = this.attribute.readAttribute(exchange);
        if (path2 == null) {
            return false;
        }
        boolean result = this.value.matches(path2, params);
        if (result) {
            TreeMap<String, String> context = (TreeMap<String, String>)exchange.getAttachment(PREDICATE_CONTEXT);
            if (context == null) {
                context = new TreeMap<String, String>();
                exchange.putAttachment(PREDICATE_CONTEXT, context);
            }
            context.putAll(params);
        }
        return result;
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "path-template";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("value", String.class);
            params.put("match", ExchangeAttribute.class);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            HashSet<String> params = new HashSet<String>();
            params.add("value");
            return params;
        }

        @Override
        public String defaultParameter() {
            return "value";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            ExchangeAttribute match = (ExchangeAttribute)config.get("match");
            if (match == null) {
                match = ExchangeAttributes.relativePath();
            }
            String value = (String)config.get("value");
            return new PathTemplatePredicate(value, match);
        }
    }
}

