/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.PathMatcher;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class PathMatchPredicate
implements Predicate {
    private final PathMatcher<Boolean> pathMatcher;

    PathMatchPredicate(String ... paths) {
        PathMatcher<Boolean> matcher = new PathMatcher<Boolean>();
        for (String path2 : paths) {
            if (!path2.startsWith("/")) {
                matcher.addExactPath("/" + path2, Boolean.TRUE);
                continue;
            }
            matcher.addExactPath(path2, Boolean.TRUE);
        }
        this.pathMatcher = matcher;
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        String relativePath = value.getRelativePath();
        PathMatcher.PathMatch<Boolean> result = this.pathMatcher.match(relativePath);
        return Boolean.TRUE.equals(result.getValue());
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "path";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("path", String[].class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("path");
        }

        @Override
        public String defaultParameter() {
            return "path";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            String[] path2 = (String[])config.get("path");
            return new PathMatchPredicate(path2);
        }
    }
}

