/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.AbstractServerConnection;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Buffers;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.AbstractStreamSourceConduit;
import org.xnio.conduits.ConduitReadableByteChannel;
import org.xnio.conduits.StreamSourceConduit;

public class ReadDataStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    private final AbstractServerConnection connection;

    public ReadDataStreamSourceConduit(StreamSourceConduit next2, AbstractServerConnection connection) {
        super(next2);
        this.connection = connection;
    }

    @Override
    public long transferTo(long position, long count2, FileChannel target) throws IOException {
        return target.transferFrom(new ConduitReadableByteChannel(this), position, count2);
    }

    @Override
    public long transferTo(long count2, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return IoUtils.transfer(new ConduitReadableByteChannel(this), count2, throughBuffer, target);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        PooledByteBuffer eb = this.connection.getExtraBytes();
        if (eb != null) {
            ByteBuffer buffer = eb.getBuffer();
            int result = Buffers.copy(dst, buffer);
            if (!buffer.hasRemaining()) {
                eb.close();
                this.connection.setExtraBytes(null);
            }
            return result;
        }
        return super.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offs, int len) throws IOException {
        PooledByteBuffer eb = this.connection.getExtraBytes();
        if (eb != null) {
            ByteBuffer buffer = eb.getBuffer();
            int result = Buffers.copy(dsts, offs, len, buffer);
            if (!buffer.hasRemaining()) {
                eb.close();
                this.connection.setExtraBytes(null);
            }
            return result;
        }
        return super.read(dsts, offs, len);
    }

    @Override
    public void resumeReads() {
        if (this.connection.getExtraBytes() != null) {
            this.wakeupReads();
        } else {
            super.resumeReads();
        }
    }

    @Override
    public void awaitReadable() throws IOException {
        if (this.connection.getExtraBytes() != null) {
            return;
        }
        super.awaitReadable();
    }

    @Override
    public void awaitReadable(long time2, TimeUnit timeUnit) throws IOException {
        if (this.connection.getExtraBytes() != null) {
            return;
        }
        super.awaitReadable(time2, timeUnit);
    }
}

