/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;

public class RangeStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private final long start;
    private final long end;
    private final long originalResponseLength;
    private long written;

    public RangeStreamSinkConduit(StreamSinkConduit next2, long start, long end, long originalResponseLength) {
        super(next2);
        this.start = start;
        this.end = end;
        this.originalResponseLength = originalResponseLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        long bytesRemaining;
        boolean currentInclude;
        boolean bl = currentInclude = this.written >= this.start && this.written <= this.end;
        long l = this.written < this.start ? this.start - this.written : (bytesRemaining = this.written <= this.end ? this.end - this.written + 1L : Long.MAX_VALUE);
        if (currentInclude) {
            int written;
            int old = src.limit();
            src.limit((int)Math.min((long)src.position() + bytesRemaining, (long)src.limit()));
            int toConsume = 0;
            try {
                written = super.write(src);
                this.written += (long)written;
            }
            finally {
                if (!src.hasRemaining()) {
                    src.limit(old);
                    if (src.hasRemaining()) {
                        toConsume = src.remaining();
                        this.written += (long)toConsume;
                        src.position(src.limit());
                    }
                } else {
                    src.limit(old);
                }
            }
            return written + toConsume;
        }
        if ((long)src.remaining() <= bytesRemaining) {
            int rem2 = src.remaining();
            this.written += (long)rem2;
            src.position(src.limit());
            return rem2;
        }
        this.written += bytesRemaining;
        src.position((int)((long)src.position() + bytesRemaining));
        return (int)bytesRemaining + this.write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        long ret = 0L;
        for (int i = offs; i < offs + len; ++i) {
            ByteBuffer buf = srcs[i];
            if (buf.remaining() <= 0) continue;
            ret += (long)this.write(buf);
            if (!buf.hasRemaining()) continue;
            return ret;
        }
        return ret;
    }

    @Override
    public long transferFrom(StreamSourceChannel source2, long count2, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer(source2, count2, throughBuffer, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count2) throws IOException {
        return src.transferTo(position, count2, new ConduitWritableByteChannel(this));
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic(this, src);
    }
}

