/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowMessages;
import io.undertow.conduits.ChunkReader;
import io.undertow.conduits.ConduitListener;
import io.undertow.server.protocol.http.HttpAttachments;
import io.undertow.util.Attachable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;

public class PreChunkedStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private final ConduitListener<? super PreChunkedStreamSinkConduit> finishListener;
    private static final int FLAG_WRITES_SHUTDOWN = 1;
    private static final int FLAG_FINISHED = 4;
    int state = 0;
    final ChunkReader<PreChunkedStreamSinkConduit> chunkReader;

    public PreChunkedStreamSinkConduit(StreamSinkConduit next2, ConduitListener<? super PreChunkedStreamSinkConduit> finishListener, Attachable attachable) {
        super(next2);
        this.chunkReader = new ChunkReader<PreChunkedStreamSinkConduit>(attachable, HttpAttachments.RESPONSE_TRAILERS, this);
        this.finishListener = finishListener;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.doWrite(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int doWrite(ByteBuffer src) throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw new ClosedChannelException();
        }
        if (this.chunkReader.getChunkRemaining() == -1L) {
            throw UndertowMessages.MESSAGES.extraDataWrittenAfterChunkEnd();
        }
        if (src.remaining() == 0) {
            return 0;
        }
        int oldPos = src.position();
        int oldLimit = src.limit();
        int ret = ((StreamSinkConduit)this.next).write(src);
        if (ret == 0) {
            return ret;
        }
        int newPos = src.position();
        src.position(oldPos);
        src.limit(oldPos + ret);
        try {
            do {
                int remaining;
                int n;
                long chunkRemaining;
                if ((chunkRemaining = this.chunkReader.readChunk(src)) == -1L) {
                    if (src.remaining() == 0) {
                        n = ret;
                        return n;
                    }
                    throw UndertowMessages.MESSAGES.extraDataWrittenAfterChunkEnd();
                }
                if (chunkRemaining == 0L) {
                    n = ret;
                    return n;
                }
                if ((long)src.remaining() >= chunkRemaining) {
                    src.position((int)((long)src.position() + chunkRemaining));
                    remaining = 0;
                } else {
                    remaining = (int)(chunkRemaining - (long)src.remaining());
                    src.position(src.limit());
                }
                this.chunkReader.setChunkRemaining(remaining);
            } while (src.hasRemaining());
        }
        finally {
            src.position(newPos);
            src.limit(oldLimit);
        }
        return ret;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        for (int i = offset; i < length; ++i) {
            if (!srcs[i].hasRemaining()) continue;
            return this.write(srcs[i]);
        }
        return 0L;
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        if (!src.hasRemaining()) {
            this.terminateWrites();
            return 0;
        }
        int ret = this.doWrite(src);
        this.terminateWrites();
        return ret;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count2) throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw new ClosedChannelException();
        }
        return src.transferTo(position, count2, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source2, long count2, ByteBuffer throughBuffer) throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw new ClosedChannelException();
        }
        return IoUtils.transfer(source2, count2, throughBuffer, new ConduitWritableByteChannel(this));
    }

    @Override
    public boolean flush() throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            boolean val2 = ((StreamSinkConduit)this.next).flush();
            if (val2 && Bits.allAreClear(this.state, 4)) {
                this.invokeFinishListener();
            }
            return val2;
        }
        return ((StreamSinkConduit)this.next).flush();
    }

    private void invokeFinishListener() {
        this.state |= 4;
        if (this.finishListener != null) {
            this.finishListener.handleEvent(this);
        }
    }

    @Override
    public void terminateWrites() throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            return;
        }
        if (this.chunkReader.getChunkRemaining() != -1L) {
            throw UndertowMessages.MESSAGES.chunkedChannelClosedMidChunk();
        }
        this.state |= 1;
    }

    @Override
    public void awaitWritable() throws IOException {
        ((StreamSinkConduit)this.next).awaitWritable();
    }

    @Override
    public void awaitWritable(long time2, TimeUnit timeUnit) throws IOException {
        ((StreamSinkConduit)this.next).awaitWritable(time2, timeUnit);
    }
}

