/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowMessages;
import io.undertow.conduits.ConduitListener;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.AbstractStreamSourceConduit;
import org.xnio.conduits.StreamSourceConduit;

public final class FixedLengthStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    private final ConduitListener<? super FixedLengthStreamSourceConduit> finishListener;
    private long state;
    private static final long FLAG_CLOSED = Long.MIN_VALUE;
    private static final long FLAG_FINISHED = 0x4000000000000000L;
    private static final long FLAG_LENGTH_CHECKED = 0x2000000000000000L;
    private static final long MASK_COUNT = Bits.longBitMask(0, 60);
    private final HttpServerExchange exchange;

    public FixedLengthStreamSourceConduit(StreamSourceConduit next2, long contentLength, ConduitListener<? super FixedLengthStreamSourceConduit> finishListener, HttpServerExchange exchange) {
        super(next2);
        this.finishListener = finishListener;
        if (contentLength < 0L) {
            throw new IllegalArgumentException("Content length must be greater than or equal to zero");
        }
        if (contentLength > MASK_COUNT) {
            throw new IllegalArgumentException("Content length is too long");
        }
        this.state = contentLength;
        this.exchange = exchange;
    }

    public FixedLengthStreamSourceConduit(StreamSourceConduit next2, long contentLength, ConduitListener<? super FixedLengthStreamSourceConduit> finishListener) {
        this(next2, contentLength, finishListener, null);
    }

    @Override
    public long transferTo(long position, long count2, FileChannel target) throws IOException {
        long val2 = this.state;
        this.checkMaxSize(val2);
        if (Bits.anyAreSet(val2, -4611686018427387904L) || Bits.allAreClear(val2, MASK_COUNT)) {
            if (Bits.allAreClear(val2, 0x4000000000000000L)) {
                this.invokeFinishListener();
            }
            return -1L;
        }
        long res = 0L;
        try {
            long l = res = ((StreamSourceConduit)this.next).transferTo(position, Math.min(count2, val2 & MASK_COUNT), target);
            return l;
        }
        catch (IOException | Error | RuntimeException e2) {
            IoUtils.safeClose((Closeable)this.exchange.getConnection());
            throw e2;
        }
        finally {
            this.exitRead(res);
        }
    }

    @Override
    public long transferTo(long count2, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        if (count2 == 0L) {
            return 0L;
        }
        long val2 = this.state;
        this.checkMaxSize(val2);
        if (Bits.anyAreSet(val2, -4611686018427387904L) || Bits.allAreClear(val2, MASK_COUNT)) {
            if (Bits.allAreClear(val2, 0x4000000000000000L)) {
                this.invokeFinishListener();
            }
            return -1L;
        }
        long res = 0L;
        try {
            long l = res = ((StreamSourceConduit)this.next).transferTo(Math.min(count2, val2 & MASK_COUNT), throughBuffer, target);
            return l;
        }
        catch (IOException | Error | RuntimeException e2) {
            IoUtils.safeClose((Closeable)this.exchange.getConnection());
            throw e2;
        }
        finally {
            this.exitRead(res + (long)throughBuffer.remaining());
        }
    }

    private void checkMaxSize(long state) throws IOException {
        if (Bits.anyAreClear(state, 0x2000000000000000L)) {
            HttpServerExchange exchange = this.exchange;
            if (exchange != null && exchange.getMaxEntitySize() > 0L && exchange.getMaxEntitySize() < (state & MASK_COUNT)) {
                Connectors.terminateRequest(exchange);
                exchange.setPersistent(false);
                this.finishListener.handleEvent(this);
                this.state |= 0xC000000000000000L;
                throw UndertowMessages.MESSAGES.requestEntityWasTooLarge(exchange.getMaxEntitySize());
            }
            this.state |= 0x2000000000000000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (length == 0) {
            return 0L;
        }
        if (length == 1) {
            return this.read(dsts[offset]);
        }
        long val2 = this.state;
        this.checkMaxSize(val2);
        if (Bits.allAreSet(val2, Long.MIN_VALUE) || Bits.allAreClear(val2, MASK_COUNT)) {
            if (Bits.allAreClear(val2, 0x4000000000000000L)) {
                this.invokeFinishListener();
            }
            return -1L;
        }
        long res = 0L;
        try {
            if ((val2 & MASK_COUNT) == 0L) {
                long l = -1L;
                return l;
            }
            long t = 0L;
            for (int i = 0; i < length; ++i) {
                ByteBuffer buffer = dsts[i + offset];
                int lim = buffer.limit();
                if ((t += (long)(lim - buffer.position())) <= (val2 & MASK_COUNT)) continue;
                buffer.limit(lim - (int)(t - (val2 & MASK_COUNT)));
                try {
                    long l = res = ((StreamSourceConduit)this.next).read(dsts, offset, i + 1);
                    return l;
                }
                finally {
                    buffer.limit(lim);
                }
            }
        }
        catch (IOException | Error | RuntimeException e2) {
            IoUtils.safeClose((Closeable)this.exchange.getConnection());
            throw e2;
        }
        finally {
            this.exitRead(res);
        }
        long l = res = ((StreamSourceConduit)this.next).read(dsts, offset, length);
        return l;
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        long val2 = this.state;
        this.checkMaxSize(val2);
        if (Bits.allAreSet(val2, Long.MIN_VALUE) || Bits.allAreClear(val2, MASK_COUNT)) {
            if (Bits.allAreClear(val2, 0x4000000000000000L)) {
                this.invokeFinishListener();
            }
            return -1;
        }
        int res = 0;
        long remaining = val2 & MASK_COUNT;
        try {
            int lim = dst.limit();
            int pos = dst.position();
            if ((long)(lim - pos) > remaining) {
                dst.limit((int)(remaining + (long)pos));
                try {
                    int n = res = ((StreamSourceConduit)this.next).read(dst);
                    return n;
                }
                finally {
                    dst.limit(lim);
                }
            }
            int n = res = ((StreamSourceConduit)this.next).read(dst);
            return n;
        }
        catch (IOException | Error | RuntimeException e2) {
            IoUtils.safeClose((Closeable)this.exchange.getConnection());
            throw e2;
        }
        finally {
            this.exitRead(res);
        }
    }

    @Override
    public boolean isReadResumed() {
        return Bits.allAreClear(this.state, Long.MIN_VALUE) && ((StreamSourceConduit)this.next).isReadResumed();
    }

    @Override
    public void wakeupReads() {
        long val2 = this.state;
        if (Bits.anyAreSet(val2, -4611686018427387904L)) {
            return;
        }
        ((StreamSourceConduit)this.next).wakeupReads();
    }

    @Override
    public void terminateReads() throws IOException {
        long val2 = this.enterShutdownReads();
        if (Bits.allAreSet(val2, Long.MIN_VALUE)) {
            return;
        }
        this.exitShutdownReads(val2);
    }

    @Override
    public void awaitReadable() throws IOException {
        long val2 = this.state;
        if (Bits.allAreSet(val2, Long.MIN_VALUE) || val2 == 0L) {
            return;
        }
        ((StreamSourceConduit)this.next).awaitReadable();
    }

    @Override
    public void awaitReadable(long time2, TimeUnit timeUnit) throws IOException {
        long val2 = this.state;
        if (Bits.allAreSet(val2, Long.MIN_VALUE) || val2 == 0L) {
            return;
        }
        try {
            ((StreamSourceConduit)this.next).awaitReadable(time2, timeUnit);
        }
        catch (IOException | Error | RuntimeException e2) {
            IoUtils.safeClose((Closeable)this.exchange.getConnection());
            throw e2;
        }
    }

    public long getRemaining() {
        return this.state & MASK_COUNT;
    }

    private long enterShutdownReads() {
        long newVal;
        long oldVal = this.state;
        if (Bits.anyAreSet(oldVal, Long.MIN_VALUE)) {
            return oldVal;
        }
        this.state = newVal = oldVal | Long.MIN_VALUE;
        return oldVal;
    }

    private void exitShutdownReads(long oldVal) {
        if (!Bits.allAreClear(oldVal, MASK_COUNT)) {
            this.invokeFinishListener();
        }
    }

    private void exitRead(long consumed) throws IOException {
        long newVal;
        long oldVal = this.state;
        if (consumed == -1L) {
            if (Bits.anyAreSet(oldVal, MASK_COUNT)) {
                this.invokeFinishListener();
                this.state &= MASK_COUNT ^ 0xFFFFFFFFFFFFFFFFL;
                throw UndertowMessages.MESSAGES.couldNotReadContentLengthData();
            }
            return;
        }
        this.state = newVal = oldVal - consumed;
    }

    private void invokeFinishListener() {
        this.state |= 0x4000000000000000L;
        this.finishListener.handleEvent(this);
    }
}

