/*
 * Decompiled with CFR 0.152.
 */
package com.arronlong.httpclientutil.common.util;

import com.arronlong.httpclientutil.HttpClientUtil;
import com.arronlong.httpclientutil.builder.HCB;
import com.arronlong.httpclientutil.common.HttpConfig;
import com.arronlong.httpclientutil.common.HttpHeader;
import com.arronlong.httpclientutil.common.Utils;
import com.arronlong.httpclientutil.common.util.PropertiesUtil;
import com.arronlong.httpclientutil.common.util.StringUtil;
import com.arronlong.httpclientutil.exception.HttpProcessException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.client.HttpClient;

public class OldOCR {
    private static final String apiUrl = "http://lab.ocrking.com/ok.html";
    private static final String apiKey = PropertiesUtil.getProperty("OCR.key");
    private static final String boundary = "----------------------------OcrKing_Client_Aven_s_Lab";
    private static final String end = "\r\n------------------------------OcrKing_Client_Aven_s_Lab--\r\n";
    private static final Header[] headers = HttpHeader.custom().accept("text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2").userAgent("Mozilla/5.0 (Windows NT 5.1; zh-CN; rv:1.9.1.3) Gecko/20100101 Firefox/8.0").contentType("multipart/form-data; boundary=----------------------------OcrKing_Client_Aven_s_Lab").referer("http://lab.ocrking.com/?javaclient0.1)").build();
    private static final Map<String, Object> map = OldOCR.getParaMap();
    private static HttpClient client = null;

    public static void enableCatch() {
        client = HCB.custom().proxy("127.0.0.1", 8888).build();
    }

    public static void unEnableCatch() {
        client = null;
    }

    private static Map<String, Object> getParaMap() {
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("service", "OcrKingForCaptcha");
        map2.put("language", "eng");
        map2.put("charset", "7");
        map2.put("type", "http://www.unknown.com");
        map2.put("apiKey", apiKey);
        return map2;
    }

    public static String ocrCode(String filePath) {
        return OldOCR.ocrCode(filePath, 0);
    }

    public static String ocrCode(String imgFilePath, int limitCodeLen) {
        byte[] data2 = null;
        String fileName = imgFilePath.replaceAll("[^/]*/|[^\\\\]*\\\\", "");
        StringBuffer strBuf = new StringBuffer();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            strBuf.append("\r\n").append("--").append(boundary).append("\r\n");
            strBuf.append("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"\r\n\r\n");
            strBuf.append(entry.getValue());
        }
        strBuf.append("\r\n").append("--").append(boundary).append("\r\n");
        strBuf.append("Content-Disposition: form-data; name=\"ocrfile\"; filename=\"" + fileName + "\"\r\n");
        strBuf.append("Content-Type:application/octet-stream\r\n\r\n");
        File f = new File(imgFilePath);
        if (!f.exists()) {
            return "Error:\u6587\u4ef6\u4e0d\u5b58\u5728!";
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(strBuf.length() + (int)f.length() + end.length());
        try {
            bos.write(strBuf.toString().getBytes());
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
            int buf_size = 1024;
            int len = 0;
            byte[] buf = new byte[buf_size];
            while (-1 != (len = in.read(buf, 0, buf_size))) {
                bos.write(buf, 0, len);
            }
            bos.write(end.getBytes());
            data2 = bos.toByteArray();
        }
        catch (IOException e2) {
            Utils.exception(e2);
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("$ENTITY_BYTES$", data2);
        try {
            String html = HttpClientUtil.post(HttpConfig.custom().client(client).url(apiUrl).headers(headers).map(m));
            String[] results = StringUtil.regex("<Result>([^<]*)</Result>\\s*<Status>([^<]*)</Status>", html);
            if (results.length > 0) {
                if (Boolean.parseBoolean(results[1])) {
                    if (limitCodeLen <= 0 || limitCodeLen == results[0].length()) {
                        return results[0];
                    }
                    return "Error:\u83b7\u53d6\u5931\u8d25! \u539f\u56e0\uff1a\u8bc6\u522b\u7ed3\u679c\u957f\u5ea6\u4e3a:" + results[0].length() + "\uff08\u671f\u671b\u957f\u5ea6:" + limitCodeLen + "\uff09";
                }
                return "Error:\u83b7\u53d6\u5931\u8d25! \u539f\u56e0\uff1a" + results[0];
            }
        }
        catch (HttpProcessException e3) {
            Utils.exception(e3);
        }
        return "Error:\u83b7\u53d6\u5931\u8d25!";
    }

    public static String ocrCode4Net(String imgUrl) {
        return OldOCR.ocrCode4Net(imgUrl, 0);
    }

    public static String ocrCode4Net(String imgUrl, int limitCodeLen) {
        Map<String, Object> map2 = OldOCR.getParaMap();
        map2.put("url", imgUrl);
        Header[] headers = HttpHeader.custom().userAgent("Mozilla/5.0 (Windows NT 5.1; zh-CN; rv:1.9.1.3) Gecko/20100101 Firefox/8.0").build();
        try {
            String html = HttpClientUtil.post(HttpConfig.custom().client(client).url(apiUrl).headers(headers).map(map2));
            String[] results = StringUtil.regex("<Result>([^<]*)</Result>\\s*<Status>([^<]*)</Status>", html);
            if (results.length > 0) {
                if (Boolean.parseBoolean(results[1])) {
                    if (limitCodeLen <= 0 || limitCodeLen == results[0].length()) {
                        return results[0];
                    }
                    return "Error:\u83b7\u53d6\u5931\u8d25! \u539f\u56e0\uff1a\u8bc6\u522b\u7ed3\u679c\u957f\u5ea6\u4e3a:" + results[0].length() + "\uff08\u671f\u671b\u957f\u5ea6:" + limitCodeLen + "\uff09";
                }
                return "Error:\u83b7\u53d6\u5931\u8d25! \u539f\u56e0\uff1a" + results[0];
            }
        }
        catch (HttpProcessException e2) {
            Utils.exception(e2);
        }
        return "Error:\u83b7\u53d6\u5931\u8d25!";
    }

    public static String ocrCode4Net(HttpConfig config, String savePath) {
        return OldOCR.ocrCode4Net(config, savePath, 0);
    }

    public static String ocrCode4Net(HttpConfig config, String savePath, int limitCodeLen) {
        if (savePath == null || savePath.equals("")) {
            return OldOCR.ocrCode4Net(config.url(), limitCodeLen);
        }
        byte[] data2 = null;
        StringBuffer strBuf = new StringBuffer();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            strBuf.append("\r\n").append("--").append(boundary).append("\r\n");
            strBuf.append("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"\r\n\r\n");
            strBuf.append(entry.getValue());
        }
        strBuf.append("\r\n").append("--").append(boundary).append("\r\n");
        strBuf.append("Content-Disposition: form-data; name=\"ocrfile\"; filename=\"aaa\"\r\n");
        strBuf.append("Content-Type:application/octet-stream\r\n\r\n");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out = (ByteArrayOutputStream)HttpClientUtil.down(config.client(client).out(out));
            FileOutputStream fos = new FileOutputStream(savePath);
            fos.write(out.toByteArray());
            ByteArrayOutputStream bos = new ByteArrayOutputStream(out.size() + strBuf.length() + end.length());
            bos.write(strBuf.toString().getBytes());
            bos.write(out.toByteArray());
            bos.write(end.getBytes());
            data2 = bos.toByteArray();
        }
        catch (HttpProcessException e2) {
            Utils.exception(e2);
        }
        catch (IOException e3) {
            Utils.exception(e3);
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("$ENTITY_BYTES$", data2);
        try {
            String html = HttpClientUtil.post(config.client(client).url(apiUrl).headers(headers).map(m));
            String[] results = StringUtil.regex("<Result>([^<]*)</Result>\\s*<Status>([^<]*)</Status>", html);
            if (results.length > 0) {
                if (Boolean.parseBoolean(results[1])) {
                    if (limitCodeLen <= 0 || limitCodeLen == results[0].length()) {
                        return results[0];
                    }
                    return "Error:\u83b7\u53d6\u5931\u8d25! \u539f\u56e0\uff1a\u8bc6\u522b\u7ed3\u679c\u957f\u5ea6\u4e3a:" + results[0].length() + "\uff08\u671f\u671b\u957f\u5ea6:" + limitCodeLen + "\uff09";
                }
                return "Error:\u83b7\u53d6\u5931\u8d25! \u539f\u56e0\uff1a" + results[0];
            }
        }
        catch (HttpProcessException e4) {
            Utils.exception(e4);
        }
        return "Error:\u83b7\u53d6\u5931\u8d25!";
    }

    public static void main(String[] args) throws HttpProcessException, IOException {
        String filePath = "C:/Users/160049/Desktop/\u4e2d\u56fd.png";
        String url = "http://file.ocrking.net:6080/small/20161104/w4fCjnzCl8KTwphpwqnCv2bCn8Kp/66fcff8d-61b1-49d6-bbfe-7428cf7accdf_debug.png?e9gFvJmkLbmgsZNTUCCNkjfi8J0Wbpn1CZHeP98eT1kxZ0ISBDt8Ql6h6zQ79pJg";
        String url2 = "http://59.41.9.91/GZCX/WebUI/Content/Handler/ValidateCode.ashx?0.3271647585525703";
        String code1 = OldOCR.ocrCode(filePath, 5);
        String code2 = OldOCR.ocrCode4Net(url, 5);
        String code3 = OldOCR.ocrCode4Net(HttpConfig.custom().url(url2), System.getProperty("user.dir") + System.getProperty("file.separator") + "123.png", 5);
        System.out.println(code1);
        System.out.println(code2);
        System.out.println(code3);
        System.out.println("----");
    }
}

