/*
 * Decompiled with CFR 0.152.
 */
package com.arronlong.httpclientutil.common;

import com.arronlong.httpclientutil.exception.HttpProcessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContexts;

public class SSLs {
    private static final SSLHandler simpleVerifier = new SSLHandler();
    private static SSLSocketFactory sslFactory;
    private static SSLConnectionSocketFactory sslConnFactory;
    private static SSLIOSessionStrategy sslIOSessionStrategy;
    private static SSLs sslutil;
    private SSLContext sc;

    public static SSLs getInstance() {
        return sslutil;
    }

    public static SSLs custom() {
        return new SSLs();
    }

    public static HostnameVerifier getVerifier() {
        return simpleVerifier;
    }

    public synchronized SSLSocketFactory getSSLSF(SSLProtocolVersion sslpv) throws HttpProcessException {
        if (sslFactory != null) {
            return sslFactory;
        }
        try {
            SSLContext sc = this.getSSLContext(sslpv);
            sc.init(null, new TrustManager[]{simpleVerifier}, null);
            sslFactory = sc.getSocketFactory();
        }
        catch (KeyManagementException e2) {
            throw new HttpProcessException(e2);
        }
        return sslFactory;
    }

    public synchronized SSLConnectionSocketFactory getSSLCONNSF(SSLProtocolVersion sslpv) throws HttpProcessException {
        if (sslConnFactory != null) {
            return sslConnFactory;
        }
        try {
            SSLContext sc = this.getSSLContext(sslpv);
            sc.init(null, new TrustManager[]{simpleVerifier}, new SecureRandom());
            sslConnFactory = new SSLConnectionSocketFactory(sc, (HostnameVerifier)simpleVerifier);
        }
        catch (KeyManagementException e2) {
            throw new HttpProcessException(e2);
        }
        return sslConnFactory;
    }

    public synchronized SSLIOSessionStrategy getSSLIOSS(SSLProtocolVersion sslpv) throws HttpProcessException {
        if (sslIOSessionStrategy != null) {
            return sslIOSessionStrategy;
        }
        try {
            SSLContext sc = this.getSSLContext(sslpv);
            sc.init(null, new TrustManager[]{simpleVerifier}, new SecureRandom());
            sslIOSessionStrategy = new SSLIOSessionStrategy(sc, simpleVerifier);
        }
        catch (KeyManagementException e2) {
            throw new HttpProcessException(e2);
        }
        return sslIOSessionStrategy;
    }

    public SSLs customSSL(String keyStorePath, String keyStorepass) throws HttpProcessException {
        FileInputStream instream = null;
        KeyStore trustStore = null;
        try {
            trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            instream = new FileInputStream(new File(keyStorePath));
            trustStore.load(instream, keyStorepass.toCharArray());
            this.sc = SSLContexts.custom().loadTrustMaterial(trustStore, new TrustSelfSignedStrategy()).build();
        }
        catch (KeyManagementException e2) {
            throw new HttpProcessException(e2);
        }
        catch (KeyStoreException e3) {
            throw new HttpProcessException(e3);
        }
        catch (FileNotFoundException e4) {
            throw new HttpProcessException(e4);
        }
        catch (NoSuchAlgorithmException e5) {
            throw new HttpProcessException(e5);
        }
        catch (CertificateException e6) {
            throw new HttpProcessException(e6);
        }
        catch (IOException e7) {
            throw new HttpProcessException(e7);
        }
        finally {
            try {
                instream.close();
            }
            catch (IOException iOException) {}
        }
        return this;
    }

    public SSLContext getSSLContext(SSLProtocolVersion sslpv) throws HttpProcessException {
        try {
            if (this.sc == null) {
                this.sc = SSLContext.getInstance(sslpv.getName());
            }
            return this.sc;
        }
        catch (NoSuchAlgorithmException e2) {
            throw new HttpProcessException(e2);
        }
    }

    static {
        sslutil = new SSLs();
    }

    public static enum SSLProtocolVersion {
        SSL("SSL"),
        SSLv3("SSLv3"),
        TLSv1("TLSv1"),
        TLSv1_1("TLSv1.1"),
        TLSv1_2("TLSv1.2");

        private String name;

        private SSLProtocolVersion(String name2) {
            this.name = name2;
        }

        public String getName() {
            return this.name;
        }

        public static SSLProtocolVersion find(String name2) {
            for (SSLProtocolVersion pv : SSLProtocolVersion.values()) {
                if (!pv.getName().toUpperCase().equals(name2.toUpperCase())) continue;
                return pv;
            }
            throw new RuntimeException("\u672a\u652f\u6301\u5f53\u524dssl\u7248\u672c\u53f7\uff1a" + name2);
        }
    }

    private static class SSLHandler
    implements X509TrustManager,
    HostnameVerifier {
        private SSLHandler() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public boolean verify(String paramString, SSLSession paramSSLSession) {
            return true;
        }
    }
}

